/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.searchview;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.AdapterView;
import android.widget.EditText;
import android.widget.Filter;
import android.widget.Filterable;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.xuexiang.xui.R;
import com.xuexiang.xui.utils.ResUtils;
import com.xuexiang.xui.widget.searchview.AnimationUtils;
import com.xuexiang.xui.widget.searchview.SearchAdapter;
import java.lang.reflect.Field;
import java.util.List;

public class MaterialSearchView
extends FrameLayout
implements Filter.FilterListener {
    public static final int REQUEST_VOICE = 9999;
    private MenuItem mMenuItem;
    private boolean mIsSearchOpen = false;
    private int mAnimationDuration;
    private boolean mClearingFocus;
    private View mSearchLayout;
    private View mTintView;
    private ListView mSuggestionsListView;
    private EditText mSearchSrcTextView;
    private ImageButton mBackBtn;
    private ImageButton mVoiceBtn;
    private ImageButton mClearBtn;
    private RelativeLayout mSearchTopBar;
    private CharSequence mOldQueryText;
    private CharSequence mUserQuery;
    private OnQueryTextListener mOnQueryChangeListener;
    private SearchViewListener mSearchViewListener;
    private ListAdapter mAdapter;
    private SavedState mSavedState;
    private boolean submit = false;
    private boolean ellipsize = false;
    private boolean allowVoiceSearch;
    private Drawable suggestionIcon;
    private Context mContext;
    private final View.OnClickListener mOnClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            if (v == MaterialSearchView.this.mBackBtn) {
                MaterialSearchView.this.closeSearch();
            } else if (v == MaterialSearchView.this.mVoiceBtn) {
                MaterialSearchView.this.onVoiceClicked();
            } else if (v == MaterialSearchView.this.mClearBtn) {
                MaterialSearchView.this.mSearchSrcTextView.setText(null);
            } else if (v == MaterialSearchView.this.mSearchSrcTextView) {
                MaterialSearchView.this.showSuggestions();
            } else if (v == MaterialSearchView.this.mTintView) {
                MaterialSearchView.this.closeSearch();
            }
        }
    };

    public MaterialSearchView(Context context) {
        super(context);
        this.initiateView(context);
        this.initStyle(null, 0);
    }

    public MaterialSearchView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initiateView(context);
        this.initStyle(attrs, 0);
    }

    public MaterialSearchView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs);
        this.initiateView(context);
        this.initStyle(attrs, defStyleAttr);
    }

    private void initStyle(AttributeSet attrs, int defStyleAttr) {
        TypedArray a = this.mContext.obtainStyledAttributes(attrs, R.styleable.MaterialSearchView, defStyleAttr, 0);
        if (a != null) {
            if (a.hasValue(R.styleable.MaterialSearchView_msv_searchBackground)) {
                this.setBackground(ResUtils.getDrawableAttrRes(this.getContext(), a, R.styleable.MaterialSearchView_msv_searchBackground));
            }
            if (a.hasValue(R.styleable.MaterialSearchView_android_textColor)) {
                this.setTextColor(a.getColor(R.styleable.MaterialSearchView_android_textColor, 0));
            }
            if (a.hasValue(R.styleable.MaterialSearchView_android_textColorHint)) {
                this.setHintTextColor(a.getColor(R.styleable.MaterialSearchView_android_textColorHint, 0));
            }
            if (a.hasValue(R.styleable.MaterialSearchView_android_hint)) {
                this.setHint(a.getString(R.styleable.MaterialSearchView_android_hint));
            }
            if (a.hasValue(R.styleable.MaterialSearchView_msv_searchVoiceIcon)) {
                this.setVoiceIcon(ResUtils.getDrawableAttrRes(this.getContext(), a, R.styleable.MaterialSearchView_msv_searchVoiceIcon));
            }
            if (a.hasValue(R.styleable.MaterialSearchView_msv_searchClearIcon)) {
                this.setCloseIcon(ResUtils.getDrawableAttrRes(this.getContext(), a, R.styleable.MaterialSearchView_msv_searchClearIcon));
            }
            if (a.hasValue(R.styleable.MaterialSearchView_msv_searchBackIcon)) {
                this.setBackIcon(ResUtils.getDrawableAttrRes(this.getContext(), a, R.styleable.MaterialSearchView_msv_searchBackIcon));
            }
            if (a.hasValue(R.styleable.MaterialSearchView_msv_searchSuggestionBackground)) {
                this.setSuggestionBackground(ResUtils.getDrawableAttrRes(this.getContext(), a, R.styleable.MaterialSearchView_msv_searchSuggestionBackground));
            }
            if (a.hasValue(R.styleable.MaterialSearchView_msv_searchSuggestionIcon)) {
                this.setSuggestionIcon(ResUtils.getDrawableAttrRes(this.getContext(), a, R.styleable.MaterialSearchView_msv_searchSuggestionIcon));
            }
            if (a.hasValue(R.styleable.MaterialSearchView_android_inputType)) {
                this.setInputType(a.getInt(R.styleable.MaterialSearchView_android_inputType, 0));
            }
            a.recycle();
        }
    }

    private void initiateView(Context context) {
        this.mContext = context;
        LayoutInflater.from((Context)this.mContext).inflate(R.layout.xui_layout_search_view, (ViewGroup)this, true);
        this.mSearchLayout = this.findViewById(R.id.search_layout);
        this.mSearchTopBar = (RelativeLayout)this.mSearchLayout.findViewById(R.id.search_top_bar);
        this.mSuggestionsListView = (ListView)this.mSearchLayout.findViewById(R.id.suggestion_list);
        this.mSearchSrcTextView = (EditText)this.mSearchLayout.findViewById(R.id.searchTextView);
        this.mBackBtn = (ImageButton)this.mSearchLayout.findViewById(R.id.action_up_btn);
        this.mVoiceBtn = (ImageButton)this.mSearchLayout.findViewById(R.id.action_voice_btn);
        this.mClearBtn = (ImageButton)this.mSearchLayout.findViewById(R.id.action_clear_btn);
        this.mTintView = this.mSearchLayout.findViewById(R.id.transparent_view);
        this.mSearchSrcTextView.setOnClickListener(this.mOnClickListener);
        this.mBackBtn.setOnClickListener(this.mOnClickListener);
        this.mVoiceBtn.setOnClickListener(this.mOnClickListener);
        this.mClearBtn.setOnClickListener(this.mOnClickListener);
        this.mTintView.setOnClickListener(this.mOnClickListener);
        this.allowVoiceSearch = false;
        this.showVoice(true);
        this.initSearchView();
        this.mSuggestionsListView.setVisibility(8);
        this.setAnimationDuration(AnimationUtils.ANIMATION_DURATION_MEDIUM);
    }

    private void initSearchView() {
        this.mSearchSrcTextView.setOnEditorActionListener(new TextView.OnEditorActionListener(){

            public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
                MaterialSearchView.this.onSubmitQuery();
                return true;
            }
        });
        this.mSearchSrcTextView.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
                MaterialSearchView.this.mUserQuery = s;
                MaterialSearchView.this.startFilter(s);
                MaterialSearchView.this.onTextChanged(s);
            }

            public void afterTextChanged(Editable s) {
            }
        });
        this.mSearchSrcTextView.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                if (hasFocus) {
                    MaterialSearchView.this.showKeyboard((View)MaterialSearchView.this.mSearchSrcTextView);
                    MaterialSearchView.this.showSuggestions();
                }
            }
        });
    }

    private void startFilter(CharSequence s) {
        if (this.mAdapter != null && this.mAdapter instanceof Filterable) {
            ((Filterable)this.mAdapter).getFilter().filter(s, (Filter.FilterListener)this);
        }
    }

    private void onVoiceClicked() {
        Intent intent = new Intent("android.speech.action.RECOGNIZE_SPEECH");
        intent.putExtra("android.speech.extra.LANGUAGE_MODEL", "web_search");
        intent.putExtra("android.speech.extra.MAX_RESULTS", 1);
        if (this.mContext instanceof Activity) {
            ((Activity)this.mContext).startActivityForResult(intent, 9999);
        }
    }

    private void onTextChanged(CharSequence newText) {
        boolean hasText;
        Editable text = this.mSearchSrcTextView.getText();
        this.mUserQuery = text;
        boolean bl = hasText = !TextUtils.isEmpty((CharSequence)text);
        if (hasText) {
            this.mClearBtn.setVisibility(0);
            this.showVoice(false);
        } else {
            this.mClearBtn.setVisibility(8);
            this.showVoice(true);
        }
        if (this.mOnQueryChangeListener != null && !TextUtils.equals((CharSequence)newText, (CharSequence)this.mOldQueryText)) {
            this.mOnQueryChangeListener.onQueryTextChange(newText.toString());
        }
        this.mOldQueryText = newText.toString();
    }

    private void onSubmitQuery() {
        Editable query = this.mSearchSrcTextView.getText();
        if (!(query == null || TextUtils.getTrimmedLength((CharSequence)query) <= 0 || this.mOnQueryChangeListener != null && this.mOnQueryChangeListener.onQueryTextSubmit(query.toString()))) {
            this.closeSearch();
            this.mSearchSrcTextView.setText(null);
        }
    }

    private boolean isVoiceAvailable() {
        if (this.isInEditMode()) {
            return true;
        }
        PackageManager pm = this.getContext().getPackageManager();
        List activities = pm.queryIntentActivities(new Intent("android.speech.action.RECOGNIZE_SPEECH"), 0);
        return activities.size() == 0;
    }

    public void hideKeyboard(View view) {
        InputMethodManager imm = (InputMethodManager)view.getContext().getSystemService("input_method");
        imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
    }

    public void showKeyboard(View view) {
        if (Build.VERSION.SDK_INT <= 10 && view.hasFocus()) {
            view.clearFocus();
        }
        view.requestFocus();
        InputMethodManager imm = (InputMethodManager)view.getContext().getSystemService("input_method");
        imm.showSoftInput(view, 0);
    }

    public void setBackground(Drawable background) {
        if (Build.VERSION.SDK_INT >= 16) {
            this.mSearchTopBar.setBackground(background);
        } else {
            this.mSearchTopBar.setBackgroundDrawable(background);
        }
    }

    public void setBackgroundColor(int color2) {
        this.mSearchTopBar.setBackgroundColor(color2);
    }

    public void setTextColor(int color2) {
        this.mSearchSrcTextView.setTextColor(color2);
    }

    public void setHintTextColor(int color2) {
        this.mSearchSrcTextView.setHintTextColor(color2);
    }

    public void setHint(CharSequence hint) {
        this.mSearchSrcTextView.setHint(hint);
    }

    public void setVoiceIcon(Drawable drawable2) {
        this.mVoiceBtn.setImageDrawable(drawable2);
    }

    public void setCloseIcon(Drawable drawable2) {
        this.mClearBtn.setImageDrawable(drawable2);
    }

    public void setBackIcon(Drawable drawable2) {
        this.mBackBtn.setImageDrawable(drawable2);
    }

    public void setSuggestionIcon(Drawable drawable2) {
        this.suggestionIcon = drawable2;
    }

    public void setInputType(int inputType) {
        this.mSearchSrcTextView.setInputType(inputType);
    }

    public void setSuggestionBackground(Drawable background) {
        if (Build.VERSION.SDK_INT >= 16) {
            this.mSuggestionsListView.setBackground(background);
        } else {
            this.mSuggestionsListView.setBackgroundDrawable(background);
        }
    }

    public void setCursorDrawable(int drawable2) {
        try {
            Field f = TextView.class.getDeclaredField("mCursorDrawableRes");
            f.setAccessible(true);
            f.set(this.mSearchSrcTextView, drawable2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setVoiceSearch(boolean voiceSearch) {
        this.allowVoiceSearch = voiceSearch;
    }

    public void showSuggestions() {
        if (this.mAdapter != null && this.mAdapter.getCount() > 0 && this.mSuggestionsListView.getVisibility() == 8) {
            this.mSuggestionsListView.setVisibility(0);
        }
    }

    public void setSubmitOnClick(boolean submit) {
        this.submit = submit;
    }

    public void setOnItemClickListener(AdapterView.OnItemClickListener listener) {
        this.mSuggestionsListView.setOnItemClickListener(listener);
    }

    public void setAdapter(ListAdapter adapter) {
        this.mAdapter = adapter;
        this.mSuggestionsListView.setAdapter(adapter);
        this.startFilter((CharSequence)this.mSearchSrcTextView.getText());
    }

    public void setSuggestions(String[] suggestions) {
        if (suggestions != null && suggestions.length > 0) {
            this.mTintView.setVisibility(0);
            final SearchAdapter adapter = new SearchAdapter(this.mContext, suggestions, this.suggestionIcon, this.ellipsize);
            this.setAdapter((ListAdapter)adapter);
            this.setOnItemClickListener(new AdapterView.OnItemClickListener(){

                public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                    MaterialSearchView.this.setQuery((String)adapter.getItem(position), MaterialSearchView.this.submit);
                }
            });
        } else {
            this.mTintView.setVisibility(8);
        }
    }

    public void dismissSuggestions() {
        if (this.mSuggestionsListView.getVisibility() == 0) {
            this.mSuggestionsListView.setVisibility(8);
        }
    }

    public void setQuery(CharSequence query, boolean submit) {
        this.mSearchSrcTextView.setText(query);
        if (query != null) {
            this.mSearchSrcTextView.setSelection(this.mSearchSrcTextView.length());
            this.mUserQuery = query;
        }
        if (submit && !TextUtils.isEmpty((CharSequence)query)) {
            this.onSubmitQuery();
        }
    }

    public void showVoice(boolean show) {
        if (show && this.isVoiceAvailable() && this.allowVoiceSearch) {
            this.mVoiceBtn.setVisibility(0);
        } else {
            this.mVoiceBtn.setVisibility(8);
        }
    }

    public void setMenuItem(MenuItem menuItem) {
        this.mMenuItem = menuItem;
        this.mMenuItem.setOnMenuItemClickListener(new MenuItem.OnMenuItemClickListener(){

            public boolean onMenuItemClick(MenuItem item) {
                MaterialSearchView.this.showSearch();
                return true;
            }
        });
    }

    public boolean isSearchOpen() {
        return this.mIsSearchOpen;
    }

    public void setAnimationDuration(int duration) {
        this.mAnimationDuration = duration;
    }

    public void showSearch() {
        this.showSearch(true);
    }

    public void showSearch(boolean animate) {
        if (this.isSearchOpen()) {
            return;
        }
        this.mSearchSrcTextView.setText(null);
        this.mSearchSrcTextView.requestFocus();
        if (animate) {
            this.setVisibleWithAnimation();
        } else {
            this.mSearchLayout.setVisibility(0);
            if (this.mSearchViewListener != null) {
                this.mSearchViewListener.onSearchViewShown();
            }
        }
        this.mIsSearchOpen = true;
    }

    private void setVisibleWithAnimation() {
        AnimationUtils.AnimationListener animationListener = new AnimationUtils.AnimationListener(){

            @Override
            public boolean onAnimationStart(View view) {
                return false;
            }

            @Override
            public boolean onAnimationEnd(View view) {
                if (MaterialSearchView.this.mSearchViewListener != null) {
                    MaterialSearchView.this.mSearchViewListener.onSearchViewShown();
                }
                return false;
            }

            @Override
            public boolean onAnimationCancel(View view) {
                return false;
            }
        };
        if (Build.VERSION.SDK_INT >= 21) {
            this.mSearchLayout.setVisibility(0);
            AnimationUtils.reveal((View)this.mSearchTopBar, animationListener);
        } else {
            AnimationUtils.fadeInView(this.mSearchLayout, this.mAnimationDuration, animationListener);
        }
    }

    public void closeSearch() {
        if (!this.isSearchOpen()) {
            return;
        }
        this.mSearchSrcTextView.setText(null);
        this.dismissSuggestions();
        this.clearFocus();
        this.mSearchLayout.setVisibility(8);
        if (this.mSearchViewListener != null) {
            this.mSearchViewListener.onSearchViewClosed();
        }
        this.mIsSearchOpen = false;
    }

    public void setOnQueryTextListener(OnQueryTextListener listener) {
        this.mOnQueryChangeListener = listener;
    }

    public void setOnSearchViewListener(SearchViewListener listener) {
        this.mSearchViewListener = listener;
    }

    public void setEllipsize(boolean ellipsize) {
        this.ellipsize = ellipsize;
    }

    public void onFilterComplete(int count) {
        if (count > 0) {
            this.showSuggestions();
        } else {
            this.dismissSuggestions();
        }
    }

    public boolean requestFocus(int direction, Rect previouslyFocusedRect) {
        if (this.mClearingFocus) {
            return false;
        }
        if (!this.isFocusable()) {
            return false;
        }
        return this.mSearchSrcTextView.requestFocus(direction, previouslyFocusedRect);
    }

    public void clearFocus() {
        this.mClearingFocus = true;
        this.hideKeyboard((View)this);
        super.clearFocus();
        this.mSearchSrcTextView.clearFocus();
        this.mClearingFocus = false;
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        this.mSavedState = new SavedState(superState);
        this.mSavedState.query = this.mUserQuery != null ? this.mUserQuery.toString() : null;
        this.mSavedState.isSearchOpen = this.mIsSearchOpen;
        return this.mSavedState;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        this.mSavedState = (SavedState)state;
        if (this.mSavedState.isSearchOpen) {
            this.showSearch(false);
            this.setQuery(this.mSavedState.query, false);
        }
        super.onRestoreInstanceState(this.mSavedState.getSuperState());
    }

    public static interface SearchViewListener {
        public void onSearchViewShown();

        public void onSearchViewClosed();
    }

    public static interface OnQueryTextListener {
        public boolean onQueryTextSubmit(String var1);

        public boolean onQueryTextChange(String var1);
    }

    static class SavedState
    extends View.BaseSavedState {
        String query;
        boolean isSearchOpen;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.query = in.readString();
            this.isSearchOpen = in.readInt() == 1;
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeString(this.query);
            out.writeInt(this.isSearchOpen ? 1 : 0);
        }
    }
}

