/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.progress.materialprogressbar;

import android.animation.Animator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.support.annotation.Keep;
import com.xuexiang.xui.utils.ThemeUtils;
import com.xuexiang.xui.widget.progress.materialprogressbar.Animators;
import com.xuexiang.xui.widget.progress.materialprogressbar.BaseIndeterminateProgressDrawable;
import com.xuexiang.xui.widget.progress.materialprogressbar.MaterialProgressDrawable;
import com.xuexiang.xui.widget.progress.materialprogressbar.ShowBackgroundDrawable;

public class IndeterminateHorizontalProgressDrawable
extends BaseIndeterminateProgressDrawable
implements MaterialProgressDrawable,
ShowBackgroundDrawable {
    private static final int PROGRESS_INTRINSIC_HEIGHT_DP = 4;
    private static final int PADDED_INTRINSIC_HEIGHT_DP = 16;
    private static final RectF RECT_BOUND = new RectF(-180.0f, -1.0f, 180.0f, 1.0f);
    private static final RectF RECT_PADDED_BOUND = new RectF(-180.0f, -4.0f, 180.0f, 4.0f);
    private static final RectF RECT_PROGRESS = new RectF(-144.0f, -1.0f, 144.0f, 1.0f);
    private static final RectTransformX RECT_1_TRANSFORM_X = new RectTransformX(-522.6f, 0.1f);
    private static final RectTransformX RECT_2_TRANSFORM_X = new RectTransformX(-197.6f, 0.1f);
    private int mProgressIntrinsicHeight;
    private int mPaddedIntrinsicHeight;
    private boolean mShowBackground = true;
    private float mBackgroundAlpha;
    private RectTransformX mRect1TransformX = new RectTransformX(RECT_1_TRANSFORM_X);
    private RectTransformX mRect2TransformX = new RectTransformX(RECT_2_TRANSFORM_X);

    public IndeterminateHorizontalProgressDrawable(Context context) {
        super(context);
        float density = context.getResources().getDisplayMetrics().density;
        this.mProgressIntrinsicHeight = Math.round(4.0f * density);
        this.mPaddedIntrinsicHeight = Math.round(16.0f * density);
        this.mBackgroundAlpha = ThemeUtils.resolveFloat(context, 0x1010033, 0.0f);
        this.mAnimators = new Animator[]{Animators.createIndeterminateHorizontalRect1(this.mRect1TransformX), Animators.createIndeterminateHorizontalRect2(this.mRect2TransformX)};
    }

    @Override
    public boolean getShowBackground() {
        return this.mShowBackground;
    }

    @Override
    public void setShowBackground(boolean show) {
        if (this.mShowBackground != show) {
            this.mShowBackground = show;
            this.invalidateSelf();
        }
    }

    public int getIntrinsicHeight() {
        return this.mUseIntrinsicPadding ? this.mPaddedIntrinsicHeight : this.mProgressIntrinsicHeight;
    }

    @Override
    protected void onPreparePaint(Paint paint) {
        paint.setStyle(Paint.Style.FILL);
    }

    @Override
    protected void onDraw(Canvas canvas, int width, int height, Paint paint) {
        if (this.mUseIntrinsicPadding) {
            canvas.scale((float)width / RECT_PADDED_BOUND.width(), (float)height / RECT_PADDED_BOUND.height());
            canvas.translate(RECT_PADDED_BOUND.width() / 2.0f, RECT_PADDED_BOUND.height() / 2.0f);
        } else {
            canvas.scale((float)width / RECT_BOUND.width(), (float)height / RECT_BOUND.height());
            canvas.translate(RECT_BOUND.width() / 2.0f, RECT_BOUND.height() / 2.0f);
        }
        if (this.mShowBackground) {
            paint.setAlpha(Math.round((float)this.mAlpha * this.mBackgroundAlpha));
            IndeterminateHorizontalProgressDrawable.drawBackgroundRect(canvas, paint);
            paint.setAlpha(this.mAlpha);
        }
        IndeterminateHorizontalProgressDrawable.drawProgressRect(canvas, this.mRect2TransformX, paint);
        IndeterminateHorizontalProgressDrawable.drawProgressRect(canvas, this.mRect1TransformX, paint);
    }

    private static void drawBackgroundRect(Canvas canvas, Paint paint) {
        canvas.drawRect(RECT_BOUND, paint);
    }

    private static void drawProgressRect(Canvas canvas, RectTransformX transformX, Paint paint) {
        int saveCount = canvas.save();
        canvas.translate(transformX.mTranslateX, 0.0f);
        canvas.scale(transformX.mScaleX, 1.0f);
        canvas.drawRect(RECT_PROGRESS, paint);
        canvas.restoreToCount(saveCount);
    }

    private static class RectTransformX {
        public float mTranslateX;
        public float mScaleX;

        public RectTransformX(float translateX, float scaleX) {
            this.mTranslateX = translateX;
            this.mScaleX = scaleX;
        }

        public RectTransformX(RectTransformX that) {
            this.mTranslateX = that.mTranslateX;
            this.mScaleX = that.mScaleX;
        }

        @Keep
        public void setTranslateX(float translateX) {
            this.mTranslateX = translateX;
        }

        @Keep
        public void setScaleX(float scaleX) {
            this.mScaleX = scaleX;
        }
    }
}

