/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.progress;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import android.support.annotation.ColorInt;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.OvershootInterpolator;
import com.xuexiang.xui.R;
import com.xuexiang.xui.utils.DensityUtils;
import com.xuexiang.xui.utils.ThemeUtils;

public class HorizontalProgressView
extends View {
    public static final int ACCELERATE_DECELERATE_INTERPOLATOR = 0;
    public static final int LINEAR_INTERPOLATOR = 1;
    public static final int ACCELERATE_INTERPOLATOR = 2;
    public static final int DECELERATE_INTERPOLATOR = 3;
    public static final int OVERSHOOT_INTERPOLATOR = 4;
    private int mAnimateType = 0;
    private float mStartProgress = 0.0f;
    private float mEndProgress = 60.0f;
    private int mStartColor = this.getResources().getColor(R.color.xui_config_color_light_orange);
    private int mEndColor = this.getResources().getColor(R.color.xui_config_color_dark_orange);
    private boolean trackEnabled = false;
    private int mTrackWidth = 6;
    private int mProgressTextSize = 48;
    private int mProgressTextColor;
    private int mTrackColor = this.getResources().getColor(R.color.default_pv_track_color);
    private int mProgressDuration = 1200;
    private boolean textVisibility = true;
    private int mCornerRadius = 30;
    private int mTextPaddingBottomOffset = 5;
    private boolean isTextMoved = true;
    private ObjectAnimator progressAnimator;
    private float moveProgress = 0.0f;
    private Paint progressPaint;
    private LinearGradient mShader;
    private RectF mRect;
    private RectF mTrackRect;
    private Paint mTextPaint;
    private Interpolator mInterpolator;
    private HorizontalProgressUpdateListener animatorUpdateListener;

    public HorizontalProgressView(Context context) {
        this(context, null);
    }

    public HorizontalProgressView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, R.attr.HorizontalProgressViewStyle);
    }

    public HorizontalProgressView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.obtainAttrs(context, attrs, defStyleAttr);
        this.init();
    }

    private void obtainAttrs(Context context, AttributeSet attrs, int defStyleAttr) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.HorizontalProgressView, defStyleAttr, 0);
        this.mStartProgress = typedArray.getInt(R.styleable.HorizontalProgressView_hpv_start_progress, 0);
        this.mEndProgress = typedArray.getInt(R.styleable.HorizontalProgressView_hpv_end_progress, 60);
        this.mStartColor = typedArray.getColor(R.styleable.HorizontalProgressView_hpv_start_color, this.getResources().getColor(R.color.xui_config_color_light_orange));
        this.mEndColor = typedArray.getColor(R.styleable.HorizontalProgressView_hpv_end_color, this.getResources().getColor(R.color.xui_config_color_dark_orange));
        this.trackEnabled = typedArray.getBoolean(R.styleable.HorizontalProgressView_hpv_isTracked, false);
        this.mProgressTextColor = typedArray.getColor(R.styleable.HorizontalProgressView_hpv_progress_textColor, ThemeUtils.resolveColor(this.getContext(), R.attr.colorAccent));
        this.mProgressTextSize = typedArray.getDimensionPixelSize(R.styleable.HorizontalProgressView_hpv_progress_textSize, this.getResources().getDimensionPixelSize(R.dimen.default_pv_horizontal_text_size));
        this.mTrackWidth = typedArray.getDimensionPixelSize(R.styleable.HorizontalProgressView_hpv_track_width, this.getResources().getDimensionPixelSize(R.dimen.default_pv_trace_width));
        this.mAnimateType = typedArray.getInt(R.styleable.HorizontalProgressView_hpv_animate_type, 0);
        this.mTrackColor = typedArray.getColor(R.styleable.HorizontalProgressView_hpv_track_color, this.getResources().getColor(R.color.default_pv_track_color));
        this.textVisibility = typedArray.getBoolean(R.styleable.HorizontalProgressView_hpv_progress_textVisibility, true);
        this.mProgressDuration = typedArray.getInt(R.styleable.HorizontalProgressView_hpv_progress_duration, 1200);
        this.mCornerRadius = typedArray.getDimensionPixelSize(R.styleable.HorizontalProgressView_hpv_corner_radius, this.getResources().getDimensionPixelSize(R.dimen.default_pv_corner_radius));
        this.mTextPaddingBottomOffset = typedArray.getDimensionPixelSize(R.styleable.HorizontalProgressView_hpv_text_padding_bottom, this.getResources().getDimensionPixelSize(R.dimen.default_pv_corner_radius));
        this.isTextMoved = typedArray.getBoolean(R.styleable.HorizontalProgressView_hpv_text_movedEnable, true);
        typedArray.recycle();
        this.moveProgress = this.mStartProgress;
    }

    private void init() {
        this.progressPaint = new Paint(1);
        this.progressPaint.setStyle(Paint.Style.FILL);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.updateTheTrack();
        this.drawTrack(canvas);
        this.progressPaint.setShader((Shader)this.mShader);
        canvas.drawRoundRect(this.mRect, (float)this.mCornerRadius, (float)this.mCornerRadius, this.progressPaint);
        this.drawProgressText(canvas);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mShader = new LinearGradient((float)(this.getPaddingLeft() - 50), (float)(this.getHeight() - this.getPaddingTop() - 50), (float)(this.getWidth() - this.getPaddingRight()), (float)(this.getHeight() / 2 + this.getPaddingTop() + this.mTrackWidth), this.mStartColor, this.mEndColor, Shader.TileMode.CLAMP);
    }

    private void drawTrack(Canvas canvas) {
        if (this.trackEnabled) {
            this.progressPaint.setShader(null);
            this.progressPaint.setColor(this.mTrackColor);
            canvas.drawRoundRect(this.mTrackRect, (float)this.mCornerRadius, (float)this.mCornerRadius, this.progressPaint);
        }
    }

    private void drawProgressText(Canvas canvas) {
        if (this.textVisibility) {
            this.mTextPaint = new Paint(1);
            this.mTextPaint.setStyle(Paint.Style.FILL);
            this.mTextPaint.setTextSize((float)this.mProgressTextSize);
            this.mTextPaint.setColor(this.mProgressTextColor);
            this.mTextPaint.setTextAlign(Paint.Align.CENTER);
            String progressText = (int)this.moveProgress + "%";
            if (this.isTextMoved) {
                canvas.drawText(progressText, (float)(this.getWidth() - this.getPaddingLeft() - this.getPaddingRight() - DensityUtils.dp2px(this.getContext(), 28.0f)) * (this.moveProgress / 100.0f) + (float)DensityUtils.dp2px(this.getContext(), 10.0f), (float)(this.getHeight() / 2 - this.getPaddingTop() - this.mTextPaddingBottomOffset), this.mTextPaint);
            } else {
                canvas.drawText(progressText, (float)((this.getWidth() - this.getPaddingLeft()) / 2), (float)(this.getHeight() / 2 - this.getPaddingTop() - this.mTextPaddingBottomOffset), this.mTextPaint);
            }
        }
    }

    public void setAnimateType(int type) {
        this.mAnimateType = type;
        this.setObjectAnimatorType(type);
    }

    private void setObjectAnimatorType(int animatorType) {
        switch (animatorType) {
            case 0: {
                if (this.mInterpolator != null) {
                    this.mInterpolator = null;
                }
                this.mInterpolator = new AccelerateDecelerateInterpolator();
                break;
            }
            case 1: {
                if (this.mInterpolator != null) {
                    this.mInterpolator = null;
                }
                this.mInterpolator = new LinearInterpolator();
                break;
            }
            case 2: {
                if (this.mInterpolator == null) break;
                this.mInterpolator = null;
                this.mInterpolator = new AccelerateInterpolator();
                break;
            }
            case 3: {
                if (this.mInterpolator != null) {
                    this.mInterpolator = null;
                }
                this.mInterpolator = new DecelerateInterpolator();
                break;
            }
            case 4: {
                if (this.mInterpolator != null) {
                    this.mInterpolator = null;
                }
                this.mInterpolator = new OvershootInterpolator();
                break;
            }
        }
    }

    public void setProgress(float progress) {
        this.moveProgress = progress;
        this.refreshTheView();
    }

    public float getProgress() {
        return this.moveProgress;
    }

    public void setStartProgress(float startProgress) {
        if (startProgress < 0.0f || startProgress > 100.0f) {
            throw new IllegalArgumentException("Illegal progress value, please change it!");
        }
        this.moveProgress = this.mStartProgress = startProgress;
        this.refreshTheView();
    }

    public void setEndProgress(float endProgress) {
        if (endProgress < 0.0f || endProgress > 100.0f) {
            throw new IllegalArgumentException("Illegal progress value, please change it!");
        }
        this.mEndProgress = endProgress;
        this.refreshTheView();
    }

    public void setStartColor(@ColorInt int startColor) {
        this.mStartColor = startColor;
        this.mShader = new LinearGradient((float)(this.getPaddingLeft() - 50), (float)(this.getHeight() - this.getPaddingTop() - 50), (float)(this.getWidth() - this.getPaddingRight()), (float)(this.getHeight() / 2 + this.getPaddingTop() + this.mTrackWidth), this.mStartColor, this.mEndColor, Shader.TileMode.CLAMP);
        this.refreshTheView();
    }

    public void setEndColor(@ColorInt int endColor) {
        this.mEndColor = endColor;
        this.mShader = new LinearGradient((float)(this.getPaddingLeft() - 50), (float)(this.getHeight() - this.getPaddingTop() - 50), (float)(this.getWidth() - this.getPaddingRight()), (float)(this.getHeight() / 2 + this.getPaddingTop() + this.mTrackWidth), this.mStartColor, this.mEndColor, Shader.TileMode.CLAMP);
        this.refreshTheView();
    }

    public void setTrackWidth(int width) {
        this.mTrackWidth = DensityUtils.dp2px(this.getContext(), width);
        this.refreshTheView();
    }

    public void setTrackColor(@ColorInt int color2) {
        this.mTrackColor = color2;
        this.refreshTheView();
    }

    public void setProgressTextColor(@ColorInt int textColor) {
        this.mProgressTextColor = textColor;
    }

    public void setProgressTextSize(int size) {
        this.mProgressTextSize = DensityUtils.sp2px(this.getContext(), size);
        this.refreshTheView();
    }

    public void setProgressDuration(int duration) {
        this.mProgressDuration = duration;
    }

    public void setTrackEnabled(boolean trackAble) {
        this.trackEnabled = trackAble;
        this.refreshTheView();
    }

    public void setProgressTextVisibility(boolean visibility) {
        this.textVisibility = visibility;
        this.refreshTheView();
    }

    public void setProgressTextMoved(boolean moved) {
        this.isTextMoved = moved;
    }

    public void startProgressAnimation() {
        this.progressAnimator = ObjectAnimator.ofFloat((Object)((Object)this), (String)"progress", (float[])new float[]{this.mStartProgress, this.mEndProgress});
        this.progressAnimator.setInterpolator((TimeInterpolator)this.mInterpolator);
        this.progressAnimator.setDuration((long)this.mProgressDuration);
        this.progressAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float progress = ((Float)animation.getAnimatedValue("progress")).floatValue();
                if (HorizontalProgressView.this.animatorUpdateListener != null) {
                    HorizontalProgressView.this.animatorUpdateListener.onHorizontalProgressUpdate(HorizontalProgressView.this, progress);
                }
            }
        });
        this.progressAnimator.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animator) {
                if (HorizontalProgressView.this.animatorUpdateListener != null) {
                    HorizontalProgressView.this.animatorUpdateListener.onHorizontalProgressStart(HorizontalProgressView.this);
                }
            }

            public void onAnimationEnd(Animator animator) {
                if (HorizontalProgressView.this.animatorUpdateListener != null) {
                    HorizontalProgressView.this.animatorUpdateListener.onHorizontalProgressFinished(HorizontalProgressView.this);
                }
            }

            public void onAnimationCancel(Animator animator) {
            }

            public void onAnimationRepeat(Animator animator) {
            }
        });
        this.progressAnimator.start();
    }

    public void stopProgressAnimation() {
        if (this.progressAnimator != null) {
            this.progressAnimator.cancel();
            this.progressAnimator = null;
        }
    }

    public void setProgressCornerRadius(int radius) {
        this.mCornerRadius = DensityUtils.dp2px(this.getContext(), radius);
        this.refreshTheView();
    }

    public void setProgressTextPaddingBottom(int offset) {
        this.mTextPaddingBottomOffset = DensityUtils.dp2px(this.getContext(), offset);
    }

    private void refreshTheView() {
        this.invalidate();
    }

    private void updateTheTrack() {
        this.mRect = new RectF((float)this.getPaddingLeft() + this.mStartProgress * (float)(this.getWidth() - this.getPaddingLeft() - this.getPaddingRight() + 60) / 100.0f, (float)(this.getHeight() / 2 - this.getPaddingTop()), (float)(this.getWidth() - this.getPaddingRight() - 20) * (this.moveProgress / 100.0f), (float)(this.getHeight() / 2 + this.getPaddingTop() + this.mTrackWidth));
        this.mTrackRect = new RectF((float)this.getPaddingLeft(), (float)(this.getHeight() / 2 - this.getPaddingTop()), (float)(this.getWidth() - this.getPaddingRight() - 20), (float)(this.getHeight() / 2 + this.getPaddingTop() + this.mTrackWidth));
    }

    public void setProgressViewUpdateListener(HorizontalProgressUpdateListener listener) {
        this.animatorUpdateListener = listener;
    }

    public static interface HorizontalProgressUpdateListener {
        public void onHorizontalProgressStart(View var1);

        public void onHorizontalProgressUpdate(View var1, float var2);

        public void onHorizontalProgressFinished(View var1);
    }
}

