/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.popupwindow.popup;

import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Point;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.Display;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.PopupWindow;

public abstract class XUIBasePopup {
    private Context mContext;
    private PopupWindow mPopupWindow;
    private RootView mRootViewWrapper;
    protected View mRootView;
    protected Drawable mBackground = null;
    protected WindowManager mWindowManager;
    private PopupWindow.OnDismissListener mDismissListener;
    protected Point mScreenSize = new Point();
    protected int mWindowHeight = 0;
    protected int mWindowWidth = 0;
    private boolean mNeedCacheSize = true;

    public XUIBasePopup(Context context) {
        this.mContext = context;
        this.mPopupWindow = new PopupWindow(context);
        this.mPopupWindow.setTouchInterceptor(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                if (event.getAction() == 4) {
                    XUIBasePopup.this.mPopupWindow.dismiss();
                    return false;
                }
                return false;
            }
        });
        this.mWindowManager = (WindowManager)context.getSystemService("window");
    }

    protected void onDismiss() {
    }

    protected void onPreShow() {
    }

    public final void show(View view) {
        this.show(view, view);
    }

    public final void show(View parent, View anchorView) {
        this.preShow();
        Display screenDisplay = this.mWindowManager.getDefaultDisplay();
        screenDisplay.getSize(this.mScreenSize);
        if (this.mWindowWidth == 0 || this.mWindowHeight == 0 || !this.mNeedCacheSize) {
            this.measureWindowSize();
        }
        Point point = this.onShow(anchorView);
        this.mPopupWindow.showAtLocation(parent, 0, point.x, point.y);
        anchorView.addOnAttachStateChangeListener(new View.OnAttachStateChangeListener(){

            public void onViewAttachedToWindow(View v) {
            }

            public void onViewDetachedFromWindow(View v) {
                if (XUIBasePopup.this.isShowing()) {
                    XUIBasePopup.this.dismiss();
                }
            }
        });
    }

    protected abstract Point onShow(View var1);

    private void preShow() {
        if (this.mRootViewWrapper == null) {
            throw new IllegalStateException("setContentView was not called with a view to display.");
        }
        this.onPreShow();
        if (this.mBackground == null) {
            this.mPopupWindow.setBackgroundDrawable((Drawable)new ColorDrawable(0));
        } else {
            this.mPopupWindow.setBackgroundDrawable(this.mBackground);
        }
        this.mPopupWindow.setWidth(-2);
        this.mPopupWindow.setHeight(-2);
        this.mPopupWindow.setTouchable(true);
        this.mPopupWindow.setFocusable(true);
        this.mPopupWindow.setOutsideTouchable(true);
        this.mPopupWindow.setContentView((View)this.mRootViewWrapper);
    }

    public boolean isShowing() {
        return this.mPopupWindow != null && this.mPopupWindow.isShowing();
    }

    private void measureWindowSize() {
        this.mRootView.measure(-2, -2);
        this.mWindowWidth = this.mRootView.getMeasuredWidth();
        this.mWindowHeight = this.mRootView.getMeasuredHeight();
    }

    public void setBackgroundDrawable(Drawable background) {
        this.mBackground = background;
    }

    public void setContentView(View root) {
        if (root == null) {
            throw new IllegalStateException("setContentView was not called with a view to display.");
        }
        this.mRootViewWrapper = new RootView(this.mContext);
        this.mRootViewWrapper.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
        this.mRootView = root;
        this.mRootViewWrapper.addView(root);
        this.mPopupWindow.setContentView((View)this.mRootViewWrapper);
        this.mPopupWindow.setOnDismissListener(new PopupWindow.OnDismissListener(){

            public void onDismiss() {
                XUIBasePopup.this.onDismiss();
                if (XUIBasePopup.this.mDismissListener != null) {
                    XUIBasePopup.this.mDismissListener.onDismiss();
                }
            }
        });
    }

    public void setContentView(int layoutResID) {
        LayoutInflater inflater = (LayoutInflater)this.mContext.getSystemService("layout_inflater");
        this.setContentView(inflater.inflate(layoutResID, null));
    }

    public XUIBasePopup setOnDismissListener(PopupWindow.OnDismissListener listener) {
        this.mDismissListener = listener;
        return this;
    }

    public void dismiss() {
        this.mPopupWindow.dismiss();
    }

    protected void onConfigurationChanged(Configuration newConfig) {
    }

    public void setNeedCacheSize(boolean needCacheSize) {
        this.mNeedCacheSize = needCacheSize;
    }

    public Context getContext() {
        return this.mContext;
    }

    public PopupWindow getPopupWindow() {
        return this.mPopupWindow;
    }

    public class RootView
    extends FrameLayout {
        public RootView(Context context) {
            super(context);
        }

        public RootView(Context context, AttributeSet attrs) {
            super(context, attrs);
        }

        protected void onConfigurationChanged(Configuration newConfig) {
            if (XUIBasePopup.this.mPopupWindow != null && XUIBasePopup.this.mPopupWindow.isShowing()) {
                XUIBasePopup.this.mPopupWindow.dismiss();
            }
            XUIBasePopup.this.onConfigurationChanged(newConfig);
        }
    }
}

