/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.popupwindow.bar;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.ColorRes;
import android.support.annotation.DrawableRes;
import android.support.annotation.StringRes;
import android.view.View;
import android.view.ViewGroup;
import com.xuexiang.xui.widget.popupwindow.bar.Cookie;
import java.lang.ref.WeakReference;

public final class CookieBar {
    private Cookie mCookieView;
    private WeakReference<Activity> mActivityWeakRef;

    private CookieBar() {
    }

    private CookieBar(Activity activity, Params params) {
        this.mActivityWeakRef = new WeakReference<Activity>(activity);
        this.mCookieView = new Cookie((Context)this.getActivity());
        this.mCookieView.setParams(params);
    }

    public void show() {
        if (this.mCookieView != null && this.getActivity() != null) {
            ViewGroup decorView = (ViewGroup)this.getActivity().getWindow().getDecorView();
            ViewGroup content = (ViewGroup)decorView.findViewById(0x1020002);
            if (this.mCookieView.getParent() == null) {
                if (this.mCookieView.getLayoutGravity() == 80) {
                    content.addView((View)this.mCookieView);
                } else {
                    decorView.addView((View)this.mCookieView);
                }
            }
        }
    }

    public void dismiss() {
        if (this.mCookieView != null) {
            this.mCookieView.dismiss();
        }
    }

    public Activity getActivity() {
        if (this.mActivityWeakRef != null && this.mActivityWeakRef.get() != null) {
            return (Activity)this.mActivityWeakRef.get();
        }
        return null;
    }

    public static Builder builder(Activity activity) {
        return new Builder(activity);
    }

    static final class Params {
        public String title;
        public String message;
        public String action;
        public int actionIcon;
        public View.OnClickListener onActionClickListener;
        public int iconResId;
        public int backgroundColor;
        public int titleColor;
        public int messageColor;
        public int actionColor;
        public long duration = 2000L;
        public int layoutGravity = 48;

        Params() {
        }
    }

    public static class Builder {
        private Params params = new Params();
        public Activity context;

        public Builder(Activity activity) {
            this.context = activity;
        }

        public Builder setIcon(@DrawableRes int iconResId) {
            this.params.iconResId = iconResId;
            return this;
        }

        public Builder setTitle(String title) {
            this.params.title = title;
            return this;
        }

        public Builder setTitle(@StringRes int resId) {
            this.params.title = this.context.getString(resId);
            return this;
        }

        public Builder setMessage(String message) {
            this.params.message = message;
            return this;
        }

        public Builder setMessage(@StringRes int resId) {
            this.params.message = this.context.getString(resId);
            return this;
        }

        public Builder setDuration(long duration) {
            this.params.duration = duration;
            return this;
        }

        public Builder setTitleColor(@ColorRes int titleColor) {
            this.params.titleColor = titleColor;
            return this;
        }

        public Builder setMessageColor(@ColorRes int messageColor) {
            this.params.messageColor = messageColor;
            return this;
        }

        public Builder setBackgroundColor(@ColorRes int backgroundColor) {
            this.params.backgroundColor = backgroundColor;
            return this;
        }

        public Builder setActionColor(@ColorRes int actionColor) {
            this.params.actionColor = actionColor;
            return this;
        }

        public Builder setAction(String action, View.OnClickListener onActionClickListener) {
            this.params.action = action;
            this.params.onActionClickListener = onActionClickListener;
            return this;
        }

        public Builder setAction(@StringRes int resId, View.OnClickListener onActionClickListener) {
            this.params.action = this.context.getString(resId);
            this.params.onActionClickListener = onActionClickListener;
            return this;
        }

        public Builder setActionWithIcon(@DrawableRes int resId, View.OnClickListener onActionClickListener) {
            this.params.actionIcon = resId;
            this.params.onActionClickListener = onActionClickListener;
            return this;
        }

        public Builder setLayoutGravity(int layoutGravity) {
            this.params.layoutGravity = layoutGravity;
            return this;
        }

        public CookieBar create() {
            return new CookieBar(this.context, this.params);
        }

        public CookieBar show() {
            CookieBar cookie = this.create();
            cookie.show();
            return cookie;
        }
    }
}

