/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.popupwindow.bar;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.xuexiang.xui.R;
import com.xuexiang.xui.utils.ThemeUtils;
import com.xuexiang.xui.widget.popupwindow.bar.CookieBar;

final class Cookie
extends LinearLayout {
    public static final long DEFAULT_COOKIE_DURATION = 2000L;
    private Animation mSlideInAnimation;
    private Animation mSlideOutAnimation;
    private LinearLayout mLayoutCookie;
    private TextView mTvTitle;
    private TextView mTvMessage;
    private ImageView mIvIcon;
    private TextView mBtnAction;
    private ImageView mBtnActionWithIcon;
    private long mDuration = 2000L;
    private int mGravity = 80;

    public Cookie(@NonNull Context context) {
        this(context, null);
    }

    public Cookie(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public Cookie(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initViews(context);
    }

    public int getLayoutGravity() {
        return this.mGravity;
    }

    private void initViews(Context context) {
        Cookie.inflate((Context)this.getContext(), (int)R.layout.xui_layout_cookie, (ViewGroup)this);
        this.mLayoutCookie = (LinearLayout)this.findViewById(R.id.cookie);
        this.mTvTitle = (TextView)this.findViewById(R.id.tv_title);
        this.mTvMessage = (TextView)this.findViewById(R.id.tv_message);
        this.mIvIcon = (ImageView)this.findViewById(R.id.iv_icon);
        this.mBtnAction = (TextView)this.findViewById(R.id.btn_action);
        this.mBtnActionWithIcon = (ImageView)this.findViewById(R.id.btn_action_with_icon);
        this.initDefaultStyle(context);
    }

    private void initDefaultStyle(Context context) {
        int titleColor = ThemeUtils.resolveColor(context, R.attr.cookieTitleColor, -1);
        int messageColor = ThemeUtils.resolveColor(context, R.attr.cookieMessageColor, -1);
        int actionColor = ThemeUtils.resolveColor(context, R.attr.cookieActionColor, -1);
        int backgroundColor = ThemeUtils.resolveColor(context, R.attr.cookieBackgroundColor, ContextCompat.getColor((Context)context, (int)R.color.cookie_bar_default_bg_color));
        this.mTvTitle.setTextColor(titleColor);
        this.mTvMessage.setTextColor(messageColor);
        this.mBtnAction.setTextColor(actionColor);
        this.mLayoutCookie.setBackgroundColor(backgroundColor);
    }

    public void setParams(final CookieBar.Params params) {
        if (params != null) {
            this.mDuration = params.duration;
            this.mGravity = params.layoutGravity;
            if (params.iconResId != 0) {
                this.mIvIcon.setVisibility(0);
                this.mIvIcon.setBackgroundResource(params.iconResId);
            }
            if (!TextUtils.isEmpty((CharSequence)params.title)) {
                this.mTvTitle.setVisibility(0);
                this.mTvTitle.setText((CharSequence)params.title);
                if (params.titleColor != 0) {
                    this.mTvTitle.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)params.titleColor));
                }
            }
            if (!TextUtils.isEmpty((CharSequence)params.message)) {
                this.mTvMessage.setVisibility(0);
                this.mTvMessage.setText((CharSequence)params.message);
                if (params.messageColor != 0) {
                    this.mTvMessage.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)params.messageColor));
                }
                if (TextUtils.isEmpty((CharSequence)params.title)) {
                    LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)this.mTvMessage.getLayoutParams();
                    layoutParams.topMargin = 0;
                }
            }
            if (!(TextUtils.isEmpty((CharSequence)params.action) && params.actionIcon == 0 || params.onActionClickListener == null)) {
                this.mBtnAction.setVisibility(0);
                this.mBtnAction.setText((CharSequence)params.action);
                this.mBtnAction.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        params.onActionClickListener.onClick(view);
                        Cookie.this.dismiss();
                    }
                });
                if (params.actionColor != 0) {
                    this.mBtnAction.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)params.actionColor));
                }
            }
            if (params.actionIcon != 0 && params.onActionClickListener != null) {
                this.mBtnAction.setVisibility(8);
                this.mBtnActionWithIcon.setVisibility(0);
                this.mBtnActionWithIcon.setBackgroundResource(params.actionIcon);
                this.mBtnActionWithIcon.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        params.onActionClickListener.onClick(view);
                        Cookie.this.dismiss();
                    }
                });
            }
            if (params.backgroundColor != 0) {
                this.mLayoutCookie.setBackgroundColor(ContextCompat.getColor((Context)this.getContext(), (int)params.backgroundColor));
            }
            int padding = ThemeUtils.resolveDimension(this.getContext(), R.attr.xui_config_content_spacing_horizontal);
            if (this.mGravity == 80) {
                this.mLayoutCookie.setPadding(padding, padding, padding, padding);
            }
            this.createInAnim();
            this.createOutAnim();
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        if (this.mGravity == 48) {
            super.onLayout(changed, l, 0, r, this.mLayoutCookie.getMeasuredHeight());
        } else {
            super.onLayout(changed, l, t, r, b);
        }
    }

    private void createInAnim() {
        this.mSlideInAnimation = AnimationUtils.loadAnimation((Context)this.getContext(), (int)(this.mGravity == 80 ? R.anim.cookiebar_slide_in_from_bottom : R.anim.cookiebar_slide_in_from_top));
        this.mSlideInAnimation.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                if (Cookie.this.mDuration < 0L) {
                    return;
                }
                Cookie.this.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        Cookie.this.dismiss();
                    }
                }, Cookie.this.mDuration);
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        this.setAnimation(this.mSlideInAnimation);
    }

    private void createOutAnim() {
        this.mSlideOutAnimation = AnimationUtils.loadAnimation((Context)this.getContext(), (int)(this.mGravity == 80 ? R.anim.cookiebar_slide_out_to_bottom : R.anim.cookiebar_slide_out_to_top));
        this.mSlideOutAnimation.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
    }

    public void dismiss() {
        this.mSlideOutAnimation.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                Cookie.this.destroy();
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        this.startAnimation(this.mSlideOutAnimation);
    }

    private void destroy() {
        this.postDelayed(new Runnable(){

            @Override
            public void run() {
                ViewParent parent = Cookie.this.getParent();
                if (parent != null) {
                    Cookie.this.clearAnimation();
                    ((ViewGroup)parent).removeView((View)Cookie.this);
                }
            }
        }, 200L);
    }
}

