/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.picker;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.support.annotation.Nullable;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import com.xuexiang.xui.R;
import com.xuexiang.xui.utils.ResUtils;
import java.lang.ref.WeakReference;
import java.math.BigDecimal;
import uk.co.chrisjenx.calligraphy.HasTypeface;

public class RulerView
extends View
implements HasTypeface {
    private int scaleLimit = 1;
    private int rulerHeight = 50;
    private int rulerToResultGap = this.rulerHeight / 4;
    private int scaleCount = 10;
    private int scaleGap = 10;
    private int minScale = 0;
    private float firstScale = 50.0f;
    private int maxScale = 100;
    private int bgColor;
    private int smallScaleColor;
    private int midScaleColor;
    private int largeScaleColor;
    private int scaleNumColor;
    private int resultNumColor;
    private String unit = "kg";
    private int unitColor;
    private int smallScaleStroke = 2;
    private int midScaleStroke = 3;
    private int largeScaleStroke = 5;
    private int resultNumTextSize = 20;
    private int scaleNumTextSize = 16;
    private int unitTextSize = 13;
    private boolean showScaleResult = true;
    private boolean isBgRoundRect = true;
    private int roundRadius = 10;
    private OnChooseResultListener onChooseResultListener;
    private float computeScale = -1.0f;
    public float currentScale = this.firstScale;
    private ValueAnimator valueAnimator;
    private VelocityTracker velocityTracker = VelocityTracker.obtain();
    private String resultText = String.valueOf(this.firstScale);
    private Paint bgPaint;
    private Paint smallScalePaint;
    private Paint midScalePaint;
    private Paint lagScalePaint;
    private TextPaint scaleNumPaint;
    private TextPaint resultNumPaint;
    private TextPaint unitPaint;
    private Rect scaleNumRect;
    private Rect resultNumRect;
    private Rect kgRect;
    private RectF bgRect;
    private int height;
    private int width;
    private int smallScaleHeight;
    private int midScaleHeight;
    private int lagScaleHeight;
    private int rulerRight = 0;
    private int resultNumRight;
    private float downX;
    private float moveX = 0.0f;
    private float currentX;
    private float lastMoveX = 0.0f;
    private boolean isUp = false;
    private int leftScroll;
    private int rightScroll;
    private int xVelocity;

    public RulerView(Context context) {
        this(context, null, R.attr.RulerViewStyle);
    }

    public RulerView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, R.attr.RulerViewStyle);
    }

    public RulerView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initAttrs(attrs, defStyleAttr);
        this.init();
    }

    private void initAttrs(AttributeSet attrs, int defStyleAttr) {
        TypedArray a = this.getContext().getTheme().obtainStyledAttributes(attrs, R.styleable.RulerView, defStyleAttr, 0);
        this.scaleLimit = a.getInt(R.styleable.RulerView_rv_scaleLimit, this.scaleLimit);
        this.rulerHeight = a.getDimensionPixelSize(R.styleable.RulerView_rv_rulerHeight, (int)TypedValue.applyDimension((int)1, (float)this.rulerHeight, (DisplayMetrics)this.getResources().getDisplayMetrics()));
        this.rulerToResultGap = a.getDimensionPixelSize(R.styleable.RulerView_rv_rulerToResultGap, (int)TypedValue.applyDimension((int)1, (float)this.rulerToResultGap, (DisplayMetrics)this.getResources().getDisplayMetrics()));
        this.scaleCount = a.getInt(R.styleable.RulerView_rv_scaleCount, this.scaleCount);
        this.scaleGap = a.getDimensionPixelSize(R.styleable.RulerView_rv_scaleGap, (int)TypedValue.applyDimension((int)1, (float)this.scaleGap, (DisplayMetrics)this.getResources().getDisplayMetrics()));
        this.minScale = a.getInt(R.styleable.RulerView_rv_minScale, this.minScale) / this.scaleLimit;
        this.firstScale = a.getFloat(R.styleable.RulerView_rv_firstScale, this.firstScale) / (float)this.scaleLimit;
        this.maxScale = a.getInt(R.styleable.RulerView_rv_maxScale, this.maxScale) / this.scaleLimit;
        this.bgColor = a.getColor(R.styleable.RulerView_rv_bgColor, ResUtils.getColor(R.color.default_ruler_view_bg_color));
        this.smallScaleColor = a.getColor(R.styleable.RulerView_rv_smallScaleColor, ResUtils.getColor(R.color.default_ruler_view_small_scale_color));
        this.midScaleColor = a.getColor(R.styleable.RulerView_rv_midScaleColor, ResUtils.getColor(R.color.default_ruler_view_mid_scale_color));
        this.largeScaleColor = a.getColor(R.styleable.RulerView_rv_largeScaleColor, ResUtils.getColor(R.color.default_ruler_view_large_scale_color));
        this.scaleNumColor = a.getColor(R.styleable.RulerView_rv_scaleNumColor, ResUtils.getColor(R.color.default_ruler_view_scale_num_color));
        this.resultNumColor = a.getColor(R.styleable.RulerView_rv_resultNumColor, ResUtils.getColor(R.color.default_ruler_view_result_num_color));
        this.unitColor = a.getColor(R.styleable.RulerView_rv_unitColor, ResUtils.getColor(R.color.default_ruler_view_unit_color));
        String tempUnit = this.unit;
        this.unit = a.getString(R.styleable.RulerView_rv_unit);
        if (TextUtils.isEmpty((CharSequence)this.unit)) {
            this.unit = tempUnit;
        }
        this.smallScaleStroke = a.getDimensionPixelSize(R.styleable.RulerView_rv_smallScaleStroke, (int)TypedValue.applyDimension((int)1, (float)this.smallScaleStroke, (DisplayMetrics)this.getResources().getDisplayMetrics()));
        this.midScaleStroke = a.getDimensionPixelSize(R.styleable.RulerView_rv_midScaleStroke, (int)TypedValue.applyDimension((int)1, (float)this.midScaleStroke, (DisplayMetrics)this.getResources().getDisplayMetrics()));
        this.largeScaleStroke = a.getDimensionPixelSize(R.styleable.RulerView_rv_largeScaleStroke, (int)TypedValue.applyDimension((int)1, (float)this.largeScaleStroke, (DisplayMetrics)this.getResources().getDisplayMetrics()));
        this.resultNumTextSize = a.getDimensionPixelSize(R.styleable.RulerView_rv_resultNumTextSize, (int)TypedValue.applyDimension((int)2, (float)this.resultNumTextSize, (DisplayMetrics)this.getResources().getDisplayMetrics()));
        this.scaleNumTextSize = a.getDimensionPixelSize(R.styleable.RulerView_rv_scaleNumTextSize, (int)TypedValue.applyDimension((int)2, (float)this.scaleNumTextSize, (DisplayMetrics)this.getResources().getDisplayMetrics()));
        this.unitTextSize = a.getDimensionPixelSize(R.styleable.RulerView_rv_unitTextSize, (int)TypedValue.applyDimension((int)2, (float)this.unitTextSize, (DisplayMetrics)this.getResources().getDisplayMetrics()));
        this.showScaleResult = a.getBoolean(R.styleable.RulerView_rv_showScaleResult, this.showScaleResult);
        this.isBgRoundRect = a.getBoolean(R.styleable.RulerView_rv_isBgRoundRect, this.isBgRoundRect);
        this.roundRadius = a.getDimensionPixelSize(R.styleable.RulerView_rv_roundRadius, (int)TypedValue.applyDimension((int)1, (float)this.roundRadius, (DisplayMetrics)this.getResources().getDisplayMetrics()));
        a.recycle();
    }

    private void init() {
        this.bgPaint = new Paint(1);
        this.smallScalePaint = new Paint(1);
        this.midScalePaint = new Paint(1);
        this.lagScalePaint = new Paint(1);
        this.scaleNumPaint = new TextPaint(1);
        this.resultNumPaint = new TextPaint(1);
        this.unitPaint = new TextPaint(1);
        this.bgPaint.setColor(this.bgColor);
        this.smallScalePaint.setColor(this.smallScaleColor);
        this.midScalePaint.setColor(this.midScaleColor);
        this.lagScalePaint.setColor(this.largeScaleColor);
        this.scaleNumPaint.setColor(this.scaleNumColor);
        this.resultNumPaint.setColor(this.resultNumColor);
        this.unitPaint.setColor(this.unitColor);
        this.resultNumPaint.setStyle(Paint.Style.FILL);
        this.unitPaint.setStyle(Paint.Style.FILL);
        this.bgPaint.setStyle(Paint.Style.FILL);
        this.smallScalePaint.setStyle(Paint.Style.FILL);
        this.midScalePaint.setStyle(Paint.Style.FILL);
        this.lagScalePaint.setStyle(Paint.Style.FILL);
        this.lagScalePaint.setStrokeCap(Paint.Cap.ROUND);
        this.midScalePaint.setStrokeCap(Paint.Cap.ROUND);
        this.smallScalePaint.setStrokeCap(Paint.Cap.ROUND);
        this.smallScalePaint.setStrokeWidth((float)this.smallScaleStroke);
        this.midScalePaint.setStrokeWidth((float)this.midScaleStroke);
        this.lagScalePaint.setStrokeWidth((float)this.largeScaleStroke);
        this.resultNumPaint.setTextSize((float)this.resultNumTextSize);
        this.unitPaint.setTextSize((float)this.unitTextSize);
        this.scaleNumPaint.setTextSize((float)this.scaleNumTextSize);
        this.bgRect = new RectF();
        this.resultNumRect = new Rect();
        this.scaleNumRect = new Rect();
        this.kgRect = new Rect();
        this.resultNumPaint.getTextBounds(this.resultText, 0, this.resultText.length(), this.resultNumRect);
        this.unitPaint.getTextBounds(this.resultText, 0, 1, this.kgRect);
        this.smallScaleHeight = this.rulerHeight / 4;
        this.midScaleHeight = this.rulerHeight / 2;
        this.lagScaleHeight = this.rulerHeight / 2 + 5;
        this.valueAnimator = new ValueAnimator();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int heightModule = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        switch (heightModule) {
            case -2147483648: {
                this.height = this.rulerHeight + (this.showScaleResult ? this.resultNumRect.height() : 0) + this.rulerToResultGap * 2 + this.getPaddingTop() + this.getPaddingBottom();
                break;
            }
            case 0: 
            case 0x40000000: {
                this.height = heightSize + this.getPaddingTop() + this.getPaddingBottom();
                break;
            }
        }
        this.width = widthSize + this.getPaddingLeft() + this.getPaddingRight();
        this.setMeasuredDimension(this.width, this.height);
    }

    protected void onDraw(Canvas canvas) {
        this.drawBg(canvas);
        this.drawScaleAndNum(canvas);
        this.drawResultText(canvas, this.resultText);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.getParent() != null) {
            this.getParent().requestDisallowInterceptTouchEvent(true);
        }
        this.currentX = event.getX();
        this.isUp = false;
        this.velocityTracker.computeCurrentVelocity(500);
        this.velocityTracker.addMovement(event);
        switch (event.getAction()) {
            case 0: {
                if (this.valueAnimator != null && this.valueAnimator.isRunning()) {
                    this.valueAnimator.end();
                    this.valueAnimator.cancel();
                }
                this.downX = event.getX();
                break;
            }
            case 2: {
                this.moveX = this.currentX - this.downX + this.lastMoveX;
                if (this.moveX >= (float)(this.width / 2)) {
                    this.moveX = this.width / 2;
                    break;
                }
                if (!(this.moveX <= this.getWhichScaleMoveX(this.maxScale))) break;
                this.moveX = this.getWhichScaleMoveX(this.maxScale);
                break;
            }
            case 1: {
                this.lastMoveX = this.moveX;
                this.xVelocity = (int)this.velocityTracker.getXVelocity();
                this.autoVelocityScroll(this.xVelocity);
                this.velocityTracker.clear();
                break;
            }
        }
        this.invalidate();
        return true;
    }

    private void autoVelocityScroll(int xVelocity) {
        if (Math.abs(xVelocity) < 50) {
            this.isUp = true;
            return;
        }
        if (this.valueAnimator.isRunning()) {
            return;
        }
        this.valueAnimator = ValueAnimator.ofInt((int[])new int[]{0, xVelocity / 20}).setDuration((long)Math.abs(xVelocity / 10));
        this.valueAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        this.valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                RulerView.this.moveX = RulerView.this.moveX + (float)((Integer)animation.getAnimatedValue()).intValue();
                if (RulerView.this.moveX >= (float)(RulerView.this.width / 2)) {
                    RulerView.this.moveX = RulerView.this.width / 2;
                } else if (RulerView.this.moveX <= RulerView.this.getWhichScaleMoveX(RulerView.this.maxScale)) {
                    RulerView.this.moveX = RulerView.this.getWhichScaleMoveX(RulerView.this.maxScale);
                }
                RulerView.this.lastMoveX = RulerView.this.moveX;
                RulerView.this.invalidate();
            }
        });
        this.valueAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                RulerView.this.isUp = true;
                RulerView.this.invalidate();
            }
        });
        this.valueAnimator.start();
    }

    private float getWhichScaleMoveX(float scale) {
        return (float)(this.width / 2) - (float)(this.scaleGap * this.scaleCount) * (scale - (float)this.minScale);
    }

    private void drawScaleAndNum(Canvas canvas) {
        canvas.translate(0.0f, (float)((this.showScaleResult ? this.resultNumRect.height() : 0) + this.rulerToResultGap));
        if (this.firstScale != -1.0f) {
            this.lastMoveX = this.moveX = this.getWhichScaleMoveX(this.firstScale);
            this.firstScale = -1.0f;
        }
        if (this.computeScale != -1.0f) {
            this.lastMoveX = this.moveX;
            if (this.valueAnimator != null && !this.valueAnimator.isRunning()) {
                this.valueAnimator = ValueAnimator.ofFloat((float[])new float[]{this.getWhichScaleMoveX(this.currentScale), this.getWhichScaleMoveX(this.computeScale)});
                this.valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                    public void onAnimationUpdate(ValueAnimator animation) {
                        RulerView.this.moveX = ((Float)animation.getAnimatedValue()).floatValue();
                        RulerView.this.lastMoveX = RulerView.this.moveX;
                        RulerView.this.invalidate();
                    }
                });
                this.valueAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                    public void onAnimationEnd(Animator animation) {
                        super.onAnimationEnd(animation);
                        RulerView.this.computeScale = -1.0f;
                    }
                });
                this.valueAnimator.setDuration(Math.abs((long)((this.getWhichScaleMoveX(this.computeScale) - this.getWhichScaleMoveX(this.currentScale)) / 100.0f)));
                this.valueAnimator.start();
            }
        }
        int num1 = -((int)(this.moveX / (float)this.scaleGap));
        float num2 = this.moveX % (float)this.scaleGap;
        canvas.save();
        this.rulerRight = 0;
        if (this.isUp) {
            float moveX2;
            num2 = (this.moveX - (float)(this.width / 2 % this.scaleGap)) % (float)this.scaleGap;
            if (num2 <= 0.0f) {
                num2 = (float)this.scaleGap - Math.abs(num2);
            }
            this.leftScroll = (int)Math.abs(num2);
            this.rightScroll = (int)((float)this.scaleGap - Math.abs(num2));
            float f = moveX2 = num2 <= (float)(this.scaleGap / 2) ? this.moveX - (float)this.leftScroll : this.moveX + (float)this.rightScroll;
            if (this.valueAnimator != null && !this.valueAnimator.isRunning()) {
                this.valueAnimator = ValueAnimator.ofFloat((float[])new float[]{this.moveX, moveX2});
                this.valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                    public void onAnimationUpdate(ValueAnimator animation) {
                        RulerView.this.moveX = ((Float)animation.getAnimatedValue()).floatValue();
                        RulerView.this.lastMoveX = RulerView.this.moveX;
                        RulerView.this.invalidate();
                    }
                });
                this.valueAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                    public void onAnimationEnd(Animator animation) {
                        super.onAnimationEnd(animation);
                        if (RulerView.this.onChooseResultListener != null) {
                            RulerView.this.onChooseResultListener.onEndResult(RulerView.this.resultText);
                        }
                    }
                });
                this.valueAnimator.setDuration(300L);
                this.valueAnimator.start();
                this.isUp = false;
            }
            num1 = (int)(-(this.moveX / (float)this.scaleGap));
            num2 = this.moveX % (float)this.scaleGap;
        }
        canvas.translate(num2, 0.0f);
        this.currentScale = ((BigDecimal)new WeakReference<BigDecimal>(new BigDecimal((((float)(this.width / 2) - this.moveX) / (float)(this.scaleGap * this.scaleCount) + (float)this.minScale) * (float)this.scaleLimit)).get()).setScale(1, 4).floatValue();
        this.resultText = String.valueOf(this.currentScale);
        if (this.onChooseResultListener != null) {
            this.onChooseResultListener.onScrollResult(this.resultText);
        }
        while (this.rulerRight < this.width) {
            if (num1 % this.scaleCount == 0) {
                if (!(this.moveX >= 0.0f && (float)this.rulerRight < this.moveX - (float)this.scaleGap || (float)(this.width / 2 - this.rulerRight) <= this.getWhichScaleMoveX(this.maxScale + 1) - this.moveX)) {
                    canvas.drawLine(0.0f, 0.0f, 0.0f, (float)this.midScaleHeight, this.midScalePaint);
                    this.scaleNumPaint.getTextBounds(num1 / this.scaleGap + this.minScale + "", 0, (num1 / this.scaleGap + this.minScale + "").length(), this.scaleNumRect);
                    canvas.drawText((num1 / this.scaleCount + this.minScale) * this.scaleLimit + "", (float)(-this.scaleNumRect.width() / 2), (float)(this.lagScaleHeight + (this.rulerHeight - this.lagScaleHeight) / 2 + this.scaleNumRect.height()), (Paint)this.scaleNumPaint);
                }
            } else if (!(this.moveX >= 0.0f && (float)this.rulerRight < this.moveX || (float)(this.width / 2 - this.rulerRight) < this.getWhichScaleMoveX(this.maxScale) - this.moveX)) {
                canvas.drawLine(0.0f, 0.0f, 0.0f, (float)this.smallScaleHeight, this.smallScalePaint);
            }
            ++num1;
            this.rulerRight += this.scaleGap;
            canvas.translate((float)this.scaleGap, 0.0f);
        }
        canvas.restore();
        canvas.drawLine((float)(this.width / 2), 0.0f, (float)(this.width / 2), (float)this.lagScaleHeight, this.lagScalePaint);
    }

    private void drawResultText(Canvas canvas, String resultText) {
        if (!this.showScaleResult) {
            return;
        }
        canvas.translate(0.0f, (float)(-this.resultNumRect.height() - this.rulerToResultGap / 2));
        this.resultNumPaint.getTextBounds(resultText, 0, resultText.length(), this.resultNumRect);
        canvas.drawText(resultText, (float)(this.width / 2 - this.resultNumRect.width() / 2), (float)this.resultNumRect.height(), (Paint)this.resultNumPaint);
        this.resultNumRight = this.width / 2 + this.resultNumRect.width() / 2 + 10;
        canvas.drawText(this.unit, (float)this.resultNumRight, (float)(this.kgRect.height() + 2), (Paint)this.unitPaint);
    }

    private void drawBg(Canvas canvas) {
        this.bgRect.set(0.0f, 0.0f, (float)this.width, (float)this.height);
        if (this.isBgRoundRect) {
            canvas.drawRoundRect(this.bgRect, (float)this.roundRadius, (float)this.roundRadius, this.bgPaint);
        } else {
            canvas.drawRect(this.bgRect, this.bgPaint);
        }
    }

    private void computeScrollTo(float scale) {
        if ((scale /= (float)this.scaleLimit) < (float)this.minScale || scale > (float)this.maxScale) {
            return;
        }
        this.computeScale = scale;
        this.invalidate();
    }

    public void setTypeface(Typeface typeface) {
        if (this.resultNumPaint != null) {
            this.resultNumPaint.setTypeface(typeface);
        }
        if (this.unitPaint != null) {
            this.unitPaint.setTypeface(typeface);
        }
        if (this.scaleNumPaint != null) {
            this.scaleNumPaint.setTypeface(typeface);
        }
    }

    public void setRulerHeight(int rulerHeight) {
        this.rulerHeight = rulerHeight;
        this.invalidate();
    }

    public void setRulerToResultGap(int rulerToResultGap) {
        this.rulerToResultGap = rulerToResultGap;
        this.invalidate();
    }

    public void setScaleCount(int scaleCount) {
        this.scaleCount = scaleCount;
        this.invalidate();
    }

    public void setScaleGap(int scaleGap) {
        this.scaleGap = scaleGap;
        this.invalidate();
    }

    public void setMinScale(int minScale) {
        this.minScale = minScale;
        this.invalidate();
    }

    public void setFirstScale(float firstScale) {
        this.firstScale = firstScale;
        this.invalidate();
    }

    public void setMaxScale(int maxScale) {
        this.maxScale = maxScale;
        this.invalidate();
    }

    public void setBgColor(int bgColor) {
        this.bgColor = bgColor;
        this.invalidate();
    }

    public void setSmallScaleColor(int smallScaleColor) {
        this.smallScaleColor = smallScaleColor;
        this.invalidate();
    }

    public void setMidScaleColor(int midScaleColor) {
        this.midScaleColor = midScaleColor;
        this.invalidate();
    }

    public void setLargeScaleColor(int largeScaleColor) {
        this.largeScaleColor = largeScaleColor;
    }

    public void setScaleNumColor(int scaleNumColor) {
        this.scaleNumColor = scaleNumColor;
        this.invalidate();
    }

    public void setResultNumColor(int resultNumColor) {
        this.resultNumColor = resultNumColor;
        this.invalidate();
    }

    public void setUnit(String unit) {
        this.unit = unit;
        this.invalidate();
    }

    public void setUnitColor(int unitColor) {
        this.unitColor = unitColor;
        this.invalidate();
    }

    public void setSmallScaleStroke(int smallScaleStroke) {
        this.smallScaleStroke = smallScaleStroke;
        this.invalidate();
    }

    public void setMidScaleStroke(int midScaleStroke) {
        this.midScaleStroke = midScaleStroke;
        this.invalidate();
    }

    public void setLargeScaleStroke(int largeScaleStroke) {
        this.largeScaleStroke = largeScaleStroke;
        this.invalidate();
    }

    public void setResultNumTextSize(int resultNumTextSize) {
        this.resultNumTextSize = resultNumTextSize;
        this.invalidate();
    }

    public void setScaleNumTextSize(int scaleNumTextSize) {
        this.scaleNumTextSize = scaleNumTextSize;
        this.invalidate();
    }

    public void setUnitTextSize(int unitTextSize) {
        this.unitTextSize = unitTextSize;
        this.invalidate();
    }

    public void setShowScaleResult(boolean showScaleResult) {
        this.showScaleResult = showScaleResult;
        this.invalidate();
    }

    public void setIsBgRoundRect(boolean bgRoundRect) {
        this.isBgRoundRect = bgRoundRect;
        this.invalidate();
    }

    public void setScaleLimit(int scaleLimit) {
        this.scaleLimit = scaleLimit;
        this.invalidate();
    }

    public void setCurrentValue(float value) {
        this.computeScrollTo(value);
    }

    public float getCurrentValue() {
        return this.currentScale;
    }

    public String getSelectValue() {
        return this.resultText;
    }

    public RulerView setOnChooseResultListener(OnChooseResultListener onChooseResultListener) {
        this.onChooseResultListener = onChooseResultListener;
        return this;
    }

    public static interface OnChooseResultListener {
        public void onEndResult(String var1);

        public void onScrollResult(String var1);
    }
}

