/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.imageview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.v7.widget.AppCompatImageView;
import android.util.AttributeSet;
import com.xuexiang.xui.R;
import com.xuexiang.xui.utils.ResUtils;
import com.xuexiang.xui.utils.Utils;

public class IconImageView
extends AppCompatImageView {
    private Bitmap mIconBitmap;
    private float mIconScale = 0.3f;
    private Paint mIconPaint;
    private boolean mIsShow = true;

    public IconImageView(Context context) {
        super(context);
        this.initAttrs(context, null);
    }

    public IconImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initAttrs(context, attrs);
    }

    public IconImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initAttrs(context, attrs);
    }

    private void initAttrs(Context context, AttributeSet attrs) {
        if (attrs != null) {
            TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.IconImageView);
            Drawable icon = ResUtils.getDrawableAttrRes(this.getContext(), typedArray, R.styleable.IconImageView_iiv_icon);
            if (icon != null) {
                this.mIconBitmap = Utils.getBitmapFromDrawable(icon);
            }
            this.mIconScale = typedArray.getFloat(R.styleable.IconImageView_iiv_icon_scale, this.mIconScale);
            this.mIsShow = typedArray.getBoolean(R.styleable.IconImageView_iiv_is_show, this.mIsShow);
            typedArray.recycle();
        }
        this.initPaint();
    }

    private void initPaint() {
        this.mIconPaint = new Paint();
        this.mIconPaint.setColor(Color.parseColor((String)"#299EE3"));
        this.mIconPaint.setAntiAlias(true);
        this.mIconPaint.setFilterBitmap(true);
        this.mIconPaint.setStyle(Paint.Style.STROKE);
        this.mIconPaint.setStrokeCap(Paint.Cap.ROUND);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mIconBitmap != null && this.mIsShow) {
            canvas.drawBitmap(this.mIconBitmap, null, this.getIconBitmapRectF(this.mIconBitmap), this.mIconPaint);
        }
    }

    private RectF getIconBitmapRectF(Bitmap bitmap) {
        float height;
        float width = bitmap.getWidth();
        if (width >= (height = (float)bitmap.getHeight())) {
            height = (float)this.getWidth() / width * height;
            width = this.getWidth();
        } else {
            width = (float)this.getHeight() / height * width;
            height = this.getHeight();
        }
        float left = ((float)this.getWidth() - width * this.mIconScale) / 2.0f;
        float top = ((float)this.getHeight() - height * this.mIconScale) / 2.0f;
        float right = (float)this.getWidth() - left;
        float bottom = (float)this.getHeight() - top;
        return new RectF(left, top, right, bottom);
    }

    public IconImageView setIsShowIcon(boolean isShowIcon) {
        this.mIsShow = isShowIcon;
        this.invalidate();
        return this;
    }

    public IconImageView setIconBitmap(@NonNull Bitmap iconBitmap) {
        this.mIconBitmap = iconBitmap;
        this.invalidate();
        return this;
    }

    public IconImageView setIconDrawable(@NonNull Drawable iconDrawable) {
        this.mIconBitmap = Utils.getBitmapFromDrawable(iconDrawable);
        this.invalidate();
        return this;
    }

    public IconImageView setIconScale(float iconScale) {
        this.mIconScale = iconScale;
        this.invalidate();
        return this;
    }

    public void recycle() {
        if (this.mIconBitmap != null) {
            this.mIconBitmap.recycle();
            this.mIconBitmap = null;
        }
        this.mIconPaint = null;
    }
}

