/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.flowlayout;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import java.util.ArrayList;
import java.util.List;

public class FlowLayout
extends ViewGroup {
    private List<List<View>> mAllViews = new ArrayList<List<View>>();
    private List<Integer> mLineHeight = new ArrayList<Integer>();

    public FlowLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public FlowLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public FlowLayout(Context context) {
        super(context);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int sizeWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int modeWidth = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int sizeHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int modeHeight = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int width = 0;
        int height = 0;
        int lineWidth = 0;
        int lineHeight = 0;
        int cCount = this.getChildCount();
        for (int i = 0; i < cCount; ++i) {
            View child = this.getChildAt(i);
            this.measureChild(child, widthMeasureSpec, heightMeasureSpec);
            ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)child.getLayoutParams();
            int childWidth = child.getMeasuredWidth() + lp.leftMargin + lp.rightMargin;
            int childHeight = child.getMeasuredHeight() + lp.topMargin + lp.bottomMargin;
            if (lineWidth + childWidth > sizeWidth - this.getPaddingLeft() - this.getPaddingRight()) {
                width = Math.max(width, lineWidth);
                lineWidth = childWidth;
                height += lineHeight;
                lineHeight = childHeight;
            } else {
                lineWidth += childWidth;
                lineHeight = Math.max(lineHeight, childHeight);
            }
            if (i != cCount - 1) continue;
            width = Math.max(lineWidth, width);
            height += lineHeight;
        }
        this.setMeasuredDimension(modeWidth == 0x40000000 ? sizeWidth : width + this.getPaddingLeft() + this.getPaddingRight(), modeHeight == 0x40000000 ? sizeHeight : height + this.getPaddingTop() + this.getPaddingBottom());
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        this.mAllViews.clear();
        this.mLineHeight.clear();
        int width = this.getWidth();
        int lineWidth = 0;
        int lineHeight = 0;
        List<Object> lineViews = new ArrayList();
        int cCount = this.getChildCount();
        for (int i = 0; i < cCount; ++i) {
            View child = this.getChildAt(i);
            ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)child.getLayoutParams();
            int childWidth = child.getMeasuredWidth();
            int childHeight = child.getMeasuredHeight();
            if (childWidth + lineWidth + lp.leftMargin + lp.rightMargin > width - this.getPaddingLeft() - this.getPaddingRight()) {
                this.mLineHeight.add(lineHeight);
                this.mAllViews.add(lineViews);
                lineWidth = 0;
                lineHeight = childHeight + lp.topMargin + lp.bottomMargin;
                lineViews = new ArrayList();
            }
            lineWidth += childWidth + lp.leftMargin + lp.rightMargin;
            lineHeight = Math.max(lineHeight, childHeight + lp.topMargin + lp.bottomMargin);
            lineViews.add(child);
        }
        this.mLineHeight.add(lineHeight);
        this.mAllViews.add(lineViews);
        int left = this.getPaddingLeft();
        int top = this.getPaddingTop();
        int lineNum = this.mAllViews.size();
        for (int i = 0; i < lineNum; ++i) {
            lineViews = this.mAllViews.get(i);
            lineHeight = this.mLineHeight.get(i);
            for (int j = 0; j < lineViews.size(); ++j) {
                View child = (View)lineViews.get(j);
                if (child.getVisibility() == 8) continue;
                ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)child.getLayoutParams();
                int lc = left + lp.leftMargin;
                int tc = top + lp.topMargin;
                int rc = lc + child.getMeasuredWidth();
                int bc = tc + child.getMeasuredHeight();
                child.layout(lc, tc, rc, bc);
                left += child.getMeasuredWidth() + lp.leftMargin + lp.rightMargin;
            }
            left = this.getPaddingLeft();
            top += lineHeight;
        }
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new ViewGroup.MarginLayoutParams(this.getContext(), attrs);
    }
}

