/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.edittext;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v7.widget.AppCompatEditText;
import android.text.Editable;
import android.text.TextWatcher;
import android.text.method.PasswordTransformationMethod;
import android.text.method.TransformationMethod;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import com.xuexiang.xui.R;
import com.xuexiang.xui.utils.ResUtils;
import com.xuexiang.xui.widget.edittext.AsteriskPasswordTransformationMethod;

public class PasswordEditText
extends AppCompatEditText {
    private static final int ALPHA_ICON_ENABLED = 137;
    private static final int ALPHA_ICON_DISABLED = 96;
    private Drawable showPwDrawable;
    private Drawable hidePwDrawable;
    private boolean passwordVisible;
    private boolean isRTL;
    private boolean showingIcon;
    private boolean setErrorCalled;
    private boolean hoverShowsPw;
    private boolean useNonMonospaceFont;
    private boolean enableIconAlpha;
    private boolean handlingHoverEvent;
    private PasswordTransformationMethod mTransformationMethod;

    public PasswordEditText(Context context) {
        this(context, null);
    }

    public PasswordEditText(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.PasswordEditTextStyle);
    }

    public PasswordEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initAttrs(attrs, defStyleAttr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initAttrs(AttributeSet attrs, int defStyleAttr) {
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.PasswordEditText, defStyleAttr, 0);
        try {
            this.showPwDrawable = ResUtils.getDrawableAttrRes(this.getContext(), typedArray, R.styleable.PasswordEditText_pet_iconShow);
            if (this.showPwDrawable == null) {
                this.showPwDrawable = ResUtils.getVectorDrawable(this.getContext(), R.drawable.pet_icon_visibility_24dp);
            }
            this.hidePwDrawable = ResUtils.getDrawableAttrRes(this.getContext(), typedArray, R.styleable.PasswordEditText_pet_iconHide);
            if (this.hidePwDrawable == null) {
                this.hidePwDrawable = ResUtils.getVectorDrawable(this.getContext(), R.drawable.pet_icon_visibility_off_24dp);
            }
            this.hoverShowsPw = typedArray.getBoolean(R.styleable.PasswordEditText_pet_hoverShowsPw, false);
            this.useNonMonospaceFont = typedArray.getBoolean(R.styleable.PasswordEditText_pet_nonMonospaceFont, false);
            this.enableIconAlpha = typedArray.getBoolean(R.styleable.PasswordEditText_pet_enableIconAlpha, true);
            boolean isAsteriskStyle = typedArray.getBoolean(R.styleable.PasswordEditText_pet_isAsteriskStyle, false);
            this.mTransformationMethod = isAsteriskStyle ? AsteriskPasswordTransformationMethod.getInstance() : PasswordTransformationMethod.getInstance();
        }
        finally {
            typedArray.recycle();
        }
        if (this.enableIconAlpha) {
            this.hidePwDrawable.setAlpha(137);
            this.showPwDrawable.setAlpha(96);
        }
        if (this.useNonMonospaceFont) {
            this.setTypeface(Typeface.DEFAULT);
        }
        this.isRTL = this.isRTLLanguage();
        this.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence seq, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                if (s.length() > 0) {
                    if (PasswordEditText.this.setErrorCalled) {
                        PasswordEditText.this.setCompoundDrawables(null, null, null, null);
                        PasswordEditText.this.setErrorCalled = false;
                        PasswordEditText.this.showPasswordVisibilityIndicator(true);
                    }
                    if (!PasswordEditText.this.showingIcon) {
                        PasswordEditText.this.showPasswordVisibilityIndicator(true);
                    }
                } else {
                    PasswordEditText.this.passwordVisible = false;
                    PasswordEditText.this.handlePasswordInputVisibility();
                    PasswordEditText.this.showPasswordVisibilityIndicator(false);
                }
            }
        });
        this.handlePasswordInputVisibility();
    }

    public PasswordEditText setPasswordTransformationMethod(PasswordTransformationMethod transformationMethod) {
        this.mTransformationMethod = transformationMethod;
        return this;
    }

    public PasswordEditText setIsAsteriskStyle(boolean isAsteriskStyle) {
        this.mTransformationMethod = isAsteriskStyle ? AsteriskPasswordTransformationMethod.getInstance() : PasswordTransformationMethod.getInstance();
        return this;
    }

    private boolean isRTLLanguage() {
        if (Build.VERSION.SDK_INT < 17) {
            return false;
        }
        Configuration config = this.getResources().getConfiguration();
        return config.getLayoutDirection() == 1;
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        return new SavedState(superState, this.showingIcon, this.passwordVisible);
    }

    public void onRestoreInstanceState(Parcelable state) {
        SavedState savedState = (SavedState)state;
        super.onRestoreInstanceState(savedState.getSuperState());
        this.showingIcon = savedState.isShowingIcon();
        this.passwordVisible = savedState.isPasswordVisible();
        this.handlePasswordInputVisibility();
        this.showPasswordVisibilityIndicator(this.showingIcon);
    }

    public void setError(CharSequence error) {
        super.setError(error);
        this.setErrorCalled = true;
    }

    public void setError(CharSequence error, Drawable icon) {
        super.setError(error, icon);
        this.setErrorCalled = true;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.showingIcon) {
            return super.onTouchEvent(event);
        }
        boolean touchable = this.isRTL ? event.getX() > (float)this.getPaddingLeft() && event.getX() < (float)(this.getPaddingLeft() + this.showPwDrawable.getIntrinsicWidth()) : event.getX() > (float)(this.getWidth() - this.getPaddingRight() - this.showPwDrawable.getIntrinsicWidth()) && event.getX() < (float)(this.getWidth() - this.getPaddingRight());
        switch (event.getAction()) {
            case 0: {
                if (!this.hoverShowsPw || !touchable) break;
                this.togglePasswordIconVisibility();
                event.setAction(3);
                this.handlingHoverEvent = true;
                break;
            }
            case 1: {
                if (!this.handlingHoverEvent && !touchable) break;
                this.togglePasswordIconVisibility();
                event.setAction(3);
                this.handlingHoverEvent = false;
            }
        }
        return super.onTouchEvent(event);
    }

    private void showPasswordVisibilityIndicator(boolean shouldShowIcon) {
        if (shouldShowIcon) {
            Drawable drawable2 = this.passwordVisible ? this.showPwDrawable : this.hidePwDrawable;
            this.showingIcon = true;
            this.setCompoundDrawablesWithIntrinsicBounds((Drawable)(this.isRTL ? drawable2 : null), null, this.isRTL ? null : drawable2, null);
        } else {
            this.setCompoundDrawables(null, null, null, null);
            this.showingIcon = false;
        }
    }

    private void togglePasswordIconVisibility() {
        this.passwordVisible = !this.passwordVisible;
        this.handlePasswordInputVisibility();
        this.showPasswordVisibilityIndicator(true);
    }

    private void handlePasswordInputVisibility() {
        int selectionStart = this.getSelectionStart();
        int selectionEnd = this.getSelectionEnd();
        if (this.passwordVisible) {
            this.setTransformationMethod(null);
        } else {
            this.setTransformationMethod((TransformationMethod)this.mTransformationMethod);
        }
        this.setSelection(selectionStart, selectionEnd);
    }

    protected static class SavedState
    extends View.BaseSavedState {
        private final boolean mShowingIcon;
        private final boolean mPasswordVisible;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        private SavedState(Parcelable superState, boolean sI, boolean pV) {
            super(superState);
            this.mShowingIcon = sI;
            this.mPasswordVisible = pV;
        }

        private SavedState(Parcel in) {
            super(in);
            this.mShowingIcon = in.readByte() != 0;
            this.mPasswordVisible = in.readByte() != 0;
        }

        public boolean isShowingIcon() {
            return this.mShowingIcon;
        }

        public boolean isPasswordVisible() {
            return this.mPasswordVisible;
        }

        public void writeToParcel(Parcel destination, int flags) {
            super.writeToParcel(destination, flags);
            destination.writeByte((byte)(this.mShowingIcon ? 1 : 0));
            destination.writeByte((byte)(this.mPasswordVisible ? 1 : 0));
        }
    }
}

