/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.dialog.materialdialog;

import android.content.res.Resources;
import android.graphics.Point;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.annotation.StyleRes;
import android.support.annotation.UiThread;
import android.support.v7.widget.RecyclerView;
import android.text.method.LinkMovementMethod;
import android.text.method.MovementMethod;
import android.text.method.PasswordTransformationMethod;
import android.text.method.TransformationMethod;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.xuexiang.xui.R;
import com.xuexiang.xui.utils.ResUtils;
import com.xuexiang.xui.utils.ThemeUtils;
import com.xuexiang.xui.widget.XUIKeyboardScrollView;
import com.xuexiang.xui.widget.dialog.materialdialog.DefaultRvAdapter;
import com.xuexiang.xui.widget.dialog.materialdialog.DialogAction;
import com.xuexiang.xui.widget.dialog.materialdialog.MaterialDialog;
import com.xuexiang.xui.widget.dialog.materialdialog.Theme;
import com.xuexiang.xui.widget.dialog.materialdialog.internal.MDAdapter;
import com.xuexiang.xui.widget.dialog.materialdialog.internal.MDButton;
import com.xuexiang.xui.widget.dialog.materialdialog.internal.MDRootLayout;
import com.xuexiang.xui.widget.dialog.materialdialog.internal.MDTintHelper;
import com.xuexiang.xui.widget.progress.materialprogressbar.HorizontalProgressDrawable;
import com.xuexiang.xui.widget.progress.materialprogressbar.IndeterminateCircularProgressDrawable;
import com.xuexiang.xui.widget.progress.materialprogressbar.IndeterminateHorizontalProgressDrawable;
import com.xuexiang.xui.widget.progress.materialprogressbar.TintableDrawable;
import java.util.ArrayList;
import java.util.Arrays;

class DialogInit {
    DialogInit() {
    }

    @StyleRes
    static int getTheme(@NonNull MaterialDialog.Builder builder) {
        if (builder.customTheme != -1) {
            return builder.customTheme;
        }
        boolean darkTheme = ThemeUtils.resolveBoolean(builder.context, R.attr.md_dark_theme, builder.theme == Theme.DARK);
        builder.theme = darkTheme ? Theme.DARK : Theme.LIGHT;
        return darkTheme ? R.style.MD_Dark : R.style.MD_Light;
    }

    @LayoutRes
    static int getInflateLayout(MaterialDialog.Builder builder) {
        if (builder.customView != null) {
            return R.layout.md_dialog_custom;
        }
        if (builder.items != null || builder.adapter != null) {
            if (builder.checkBoxPrompt != null) {
                return R.layout.md_dialog_list_check;
            }
            return R.layout.md_dialog_list;
        }
        if (builder.progress > -2) {
            return R.layout.md_dialog_progress;
        }
        if (builder.indeterminateProgress) {
            if (builder.indeterminateIsHorizontalProgress) {
                return R.layout.md_dialog_progress_indeterminate_horizontal;
            }
            return R.layout.md_dialog_progress_indeterminate;
        }
        if (builder.inputCallback != null) {
            if (builder.checkBoxPrompt != null) {
                return R.layout.md_dialog_input_check;
            }
            return R.layout.md_dialog_input;
        }
        if (builder.checkBoxPrompt != null) {
            return R.layout.md_dialog_basic_check;
        }
        return R.layout.md_dialog_basic;
    }

    @UiThread
    public static void init(MaterialDialog dialog) {
        boolean textAllCaps;
        MaterialDialog.Builder builder = dialog.builder;
        dialog.setCancelable(builder.cancelable);
        dialog.setCanceledOnTouchOutside(builder.canceledOnTouchOutside);
        if (builder.backgroundColor == 0) {
            builder.backgroundColor = ThemeUtils.resolveColor(builder.context, R.attr.md_background_color, ThemeUtils.resolveColor(dialog.getContext(), R.attr.colorBackgroundFloating));
        }
        if (builder.backgroundColor != 0) {
            GradientDrawable drawable2 = new GradientDrawable();
            drawable2.setCornerRadius(builder.context.getResources().getDimension(R.dimen.md_bg_corner_radius));
            drawable2.setColor(builder.backgroundColor);
            dialog.getWindow().setBackgroundDrawable((Drawable)drawable2);
        }
        if (!builder.positiveColorSet) {
            builder.positiveColor = ThemeUtils.resolveActionTextColorStateList(builder.context, R.attr.md_positive_color, builder.positiveColor);
        }
        if (!builder.neutralColorSet) {
            builder.neutralColor = ThemeUtils.resolveActionTextColorStateList(builder.context, R.attr.md_neutral_color, builder.neutralColor);
        }
        if (!builder.negativeColorSet) {
            builder.negativeColor = ThemeUtils.resolveActionTextColorStateList(builder.context, R.attr.md_negative_color, builder.negativeColor);
        }
        if (!builder.widgetColorSet) {
            builder.widgetColor = ThemeUtils.resolveColor(builder.context, R.attr.md_widget_color, builder.widgetColor);
        }
        if (!builder.titleColorSet) {
            int titleColorFallback = ThemeUtils.resolveColor(dialog.getContext(), 16842806);
            builder.titleColor = ThemeUtils.resolveColor(builder.context, R.attr.md_title_color, titleColorFallback);
        }
        if (!builder.contentColorSet) {
            int contentColorFallback = ThemeUtils.resolveColor(dialog.getContext(), 16842808);
            builder.contentColor = ThemeUtils.resolveColor(builder.context, R.attr.md_content_color, contentColorFallback);
        }
        if (!builder.itemColorSet) {
            builder.itemColor = ThemeUtils.resolveColor(builder.context, R.attr.md_item_color, builder.contentColor);
        }
        dialog.title = (TextView)dialog.view.findViewById(R.id.md_title);
        dialog.icon = (ImageView)dialog.view.findViewById(R.id.md_icon);
        dialog.titleFrame = dialog.view.findViewById(R.id.md_titleFrame);
        dialog.content = (TextView)dialog.view.findViewById(R.id.md_content);
        dialog.recyclerView = (RecyclerView)dialog.view.findViewById(R.id.md_contentRecyclerView);
        dialog.checkBoxPrompt = (CheckBox)dialog.view.findViewById(R.id.md_promptCheckbox);
        dialog.positiveButton = (MDButton)dialog.view.findViewById(R.id.md_buttonDefaultPositive);
        dialog.neutralButton = (MDButton)dialog.view.findViewById(R.id.md_buttonDefaultNeutral);
        dialog.negativeButton = (MDButton)dialog.view.findViewById(R.id.md_buttonDefaultNegative);
        if (builder.inputCallback != null && builder.positiveText == null) {
            builder.positiveText = builder.context.getText(17039370);
        }
        dialog.positiveButton.setVisibility(builder.positiveText != null ? 0 : 8);
        dialog.neutralButton.setVisibility(builder.neutralText != null ? 0 : 8);
        dialog.negativeButton.setVisibility(builder.negativeText != null ? 0 : 8);
        dialog.positiveButton.setFocusable(true);
        dialog.neutralButton.setFocusable(true);
        dialog.negativeButton.setFocusable(true);
        if (builder.positiveFocus) {
            dialog.positiveButton.requestFocus();
        }
        if (builder.neutralFocus) {
            dialog.neutralButton.requestFocus();
        }
        if (builder.negativeFocus) {
            dialog.negativeButton.requestFocus();
        }
        if (builder.icon != null) {
            dialog.icon.setVisibility(0);
            dialog.icon.setImageDrawable(builder.icon);
        } else {
            Drawable d = ThemeUtils.resolveDrawable(builder.context, R.attr.md_icon);
            if (d != null) {
                dialog.icon.setVisibility(0);
                dialog.icon.setImageDrawable(d);
            } else {
                dialog.icon.setVisibility(8);
            }
        }
        int maxIconSize = builder.maxIconSize;
        if (maxIconSize == -1) {
            maxIconSize = ThemeUtils.resolveDimension(builder.context, R.attr.md_icon_max_size);
        }
        if (builder.limitIconToDefaultSize || ThemeUtils.resolveBoolean(builder.context, R.attr.md_icon_limit_icon_to_default_size)) {
            maxIconSize = builder.context.getResources().getDimensionPixelSize(R.dimen.default_md_icon_max_size);
        }
        if (maxIconSize > -1) {
            dialog.icon.setAdjustViewBounds(true);
            dialog.icon.setMaxHeight(maxIconSize);
            dialog.icon.setMaxWidth(maxIconSize);
            dialog.icon.requestLayout();
        }
        if (!builder.dividerColorSet) {
            int dividerFallback = ThemeUtils.resolveColor(dialog.getContext(), R.attr.md_divider);
            builder.dividerColor = ThemeUtils.resolveColor(builder.context, R.attr.md_divider_color, dividerFallback);
        }
        dialog.view.setDividerColor(builder.dividerColor);
        if (dialog.title != null) {
            dialog.setTypeface(dialog.title, builder.mediumFont);
            dialog.title.setTextColor(builder.titleColor);
            dialog.title.setGravity(builder.titleGravity.getGravityInt());
            if (Build.VERSION.SDK_INT >= 17) {
                dialog.title.setTextAlignment(builder.titleGravity.getTextAlignment());
            }
            if (builder.title == null) {
                dialog.titleFrame.setVisibility(8);
            } else {
                dialog.title.setText(builder.title);
                dialog.titleFrame.setVisibility(0);
            }
        }
        if (dialog.content != null) {
            dialog.content.setMovementMethod((MovementMethod)new LinkMovementMethod());
            dialog.setTypeface(dialog.content, builder.regularFont);
            dialog.content.setLineSpacing(0.0f, builder.contentLineSpacingMultiplier);
            if (builder.linkColor == null) {
                dialog.content.setLinkTextColor(ThemeUtils.resolveColor(dialog.getContext(), 16842806));
            } else {
                dialog.content.setLinkTextColor(builder.linkColor);
            }
            dialog.content.setTextColor(builder.contentColor);
            dialog.content.setGravity(builder.contentGravity.getGravityInt());
            if (Build.VERSION.SDK_INT >= 17) {
                dialog.content.setTextAlignment(builder.contentGravity.getTextAlignment());
            }
            if (builder.content != null) {
                dialog.content.setText(builder.content);
                dialog.content.setVisibility(0);
            } else {
                dialog.content.setVisibility(8);
            }
        }
        if (dialog.checkBoxPrompt != null) {
            dialog.checkBoxPrompt.setText(builder.checkBoxPrompt);
            dialog.checkBoxPrompt.setChecked(builder.checkBoxPromptInitiallyChecked);
            dialog.checkBoxPrompt.setOnCheckedChangeListener(builder.checkBoxPromptListener);
            dialog.setTypeface((TextView)dialog.checkBoxPrompt, builder.regularFont);
            dialog.checkBoxPrompt.setTextColor(builder.contentColor);
            MDTintHelper.setTint(dialog.checkBoxPrompt, builder.widgetColor);
        }
        dialog.view.setButtonGravity(builder.buttonsGravity);
        dialog.view.setButtonStackedGravity(builder.btnStackedGravity);
        dialog.view.setStackingBehavior(builder.stackingBehavior);
        if (Build.VERSION.SDK_INT >= 14) {
            textAllCaps = ThemeUtils.resolveBoolean(builder.context, 16843660, true);
            if (textAllCaps) {
                textAllCaps = ThemeUtils.resolveBoolean(builder.context, R.attr.textAllCaps, true);
            }
        } else {
            textAllCaps = ThemeUtils.resolveBoolean(builder.context, R.attr.textAllCaps, true);
        }
        MDButton positiveTextView = dialog.positiveButton;
        dialog.setTypeface(positiveTextView, builder.mediumFont);
        positiveTextView.setAllCapsCompat(textAllCaps);
        positiveTextView.setText(builder.positiveText);
        positiveTextView.setTextColor(builder.positiveColor);
        dialog.positiveButton.setStackedSelector(dialog.getButtonSelector(DialogAction.POSITIVE, true));
        dialog.positiveButton.setDefaultSelector(dialog.getButtonSelector(DialogAction.POSITIVE, false));
        dialog.positiveButton.setTag((Object)DialogAction.POSITIVE);
        dialog.positiveButton.setOnClickListener(dialog);
        dialog.positiveButton.setVisibility(0);
        MDButton negativeTextView = dialog.negativeButton;
        dialog.setTypeface(negativeTextView, builder.mediumFont);
        negativeTextView.setAllCapsCompat(textAllCaps);
        negativeTextView.setText(builder.negativeText);
        negativeTextView.setTextColor(builder.negativeColor);
        dialog.negativeButton.setStackedSelector(dialog.getButtonSelector(DialogAction.NEGATIVE, true));
        dialog.negativeButton.setDefaultSelector(dialog.getButtonSelector(DialogAction.NEGATIVE, false));
        dialog.negativeButton.setTag((Object)DialogAction.NEGATIVE);
        dialog.negativeButton.setOnClickListener(dialog);
        dialog.negativeButton.setVisibility(0);
        MDButton neutralTextView = dialog.neutralButton;
        dialog.setTypeface(neutralTextView, builder.mediumFont);
        neutralTextView.setAllCapsCompat(textAllCaps);
        neutralTextView.setText(builder.neutralText);
        neutralTextView.setTextColor(builder.neutralColor);
        dialog.neutralButton.setStackedSelector(dialog.getButtonSelector(DialogAction.NEUTRAL, true));
        dialog.neutralButton.setDefaultSelector(dialog.getButtonSelector(DialogAction.NEUTRAL, false));
        dialog.neutralButton.setTag((Object)DialogAction.NEUTRAL);
        dialog.neutralButton.setOnClickListener(dialog);
        dialog.neutralButton.setVisibility(0);
        if (builder.listCallbackMultiChoice != null) {
            dialog.selectedIndicesList = new ArrayList<Integer>();
        }
        if (dialog.recyclerView != null) {
            if (builder.adapter == null) {
                if (builder.listCallbackSingleChoice != null) {
                    dialog.listType = MaterialDialog.ListType.SINGLE;
                } else if (builder.listCallbackMultiChoice != null) {
                    dialog.listType = MaterialDialog.ListType.MULTI;
                    if (builder.selectedIndices != null) {
                        dialog.selectedIndicesList = new ArrayList<Integer>(Arrays.asList(builder.selectedIndices));
                        builder.selectedIndices = null;
                    }
                } else {
                    dialog.listType = MaterialDialog.ListType.REGULAR;
                }
                builder.adapter = new DefaultRvAdapter(dialog, MaterialDialog.ListType.getLayoutForType(dialog.listType));
            } else if (builder.adapter instanceof MDAdapter) {
                ((MDAdapter)builder.adapter).setDialog(dialog);
            }
        }
        DialogInit.setupProgressDialog(dialog);
        DialogInit.setupInputDialog(dialog);
        if (builder.customView != null) {
            FrameLayout frame;
            ((MDRootLayout)dialog.view.findViewById(R.id.md_root)).noTitleNoPadding();
            dialog.customViewFrame = frame = (FrameLayout)dialog.view.findViewById(R.id.md_customViewFrame);
            Object innerView = builder.customView;
            if (innerView.getParent() != null) {
                ((ViewGroup)innerView.getParent()).removeView(innerView);
            }
            if (builder.wrapCustomViewInScroll) {
                Resources r = dialog.getContext().getResources();
                int framePadding = ThemeUtils.resolveDimension(dialog.getContext(), R.attr.md_dialog_frame_margin, R.dimen.default_md_dialog_frame_margin);
                XUIKeyboardScrollView sv = new XUIKeyboardScrollView(dialog.getContext());
                int paddingTop = r.getDimensionPixelSize(R.dimen.md_content_padding_top);
                int paddingBottom = r.getDimensionPixelSize(R.dimen.md_content_padding_bottom);
                sv.setClipToPadding(false);
                if (innerView instanceof EditText) {
                    sv.setPadding(framePadding, paddingTop, framePadding, paddingBottom);
                } else {
                    sv.setPadding(0, paddingTop, 0, paddingBottom);
                    innerView.setPadding(framePadding, 0, framePadding, 0);
                }
                sv.addView((View)innerView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -2));
                innerView = sv;
            }
            frame.addView(innerView, new ViewGroup.LayoutParams(-1, -2));
        }
        if (builder.showListener != null) {
            dialog.setOnShowListener(builder.showListener);
        }
        if (builder.cancelListener != null) {
            dialog.setOnCancelListener(builder.cancelListener);
        }
        if (builder.dismissListener != null) {
            dialog.setOnDismissListener(builder.dismissListener);
        }
        if (builder.keyListener != null) {
            dialog.setOnKeyListener(builder.keyListener);
        }
        dialog.setOnShowListenerInternal();
        dialog.invalidateList();
        dialog.setViewInternal((View)dialog.view);
        dialog.checkIfListInitScroll();
        WindowManager wm = dialog.getWindow().getWindowManager();
        Display display = wm.getDefaultDisplay();
        Point size = new Point();
        display.getSize(size);
        int windowWidth = size.x;
        int windowHeight = size.y;
        int windowVerticalPadding = ThemeUtils.resolveDimension(builder.context, R.attr.md_dialog_vertical_margin, ResUtils.getDimensionPixelSize(R.dimen.default_md_dialog_vertical_margin_phone));
        int windowHorizontalPadding = ThemeUtils.resolveDimension(builder.context, R.attr.md_dialog_horizontal_margin, ResUtils.getDimensionPixelSize(R.dimen.default_md_dialog_horizontal_margin_phone));
        int maxWidth = ThemeUtils.resolveDimension(builder.context, R.attr.md_dialog_max_width);
        int calculatedWidth = windowWidth - windowHorizontalPadding * 2;
        dialog.view.setMaxHeight(windowHeight - windowVerticalPadding * 2);
        WindowManager.LayoutParams lp = new WindowManager.LayoutParams();
        lp.copyFrom(dialog.getWindow().getAttributes());
        lp.width = Math.min(maxWidth, calculatedWidth);
        dialog.getWindow().setAttributes(lp);
    }

    private static void fixCanvasScalingWhenHardwareAccelerated(ProgressBar pb) {
        if (Build.VERSION.SDK_INT < 18 && pb.isHardwareAccelerated() && pb.getLayerType() != 1) {
            pb.setLayerType(1, null);
        }
    }

    private static void setupProgressDialog(MaterialDialog dialog) {
        MaterialDialog.Builder builder = dialog.builder;
        if (builder.indeterminateProgress || builder.progress > -2) {
            dialog.progressBar = (ProgressBar)dialog.view.findViewById(16908301);
            if (dialog.progressBar == null) {
                return;
            }
            if (Build.VERSION.SDK_INT >= 14) {
                TintableDrawable d;
                if (builder.indeterminateProgress) {
                    if (builder.indeterminateIsHorizontalProgress) {
                        d = new IndeterminateHorizontalProgressDrawable(builder.getContext());
                        ((IndeterminateHorizontalProgressDrawable)d).setTint(builder.widgetColor);
                        dialog.progressBar.setProgressDrawable((Drawable)d);
                        dialog.progressBar.setIndeterminateDrawable((Drawable)d);
                    } else {
                        d = new IndeterminateCircularProgressDrawable(builder.getContext());
                        ((IndeterminateCircularProgressDrawable)d).setTint(builder.widgetColor);
                        dialog.progressBar.setProgressDrawable((Drawable)d);
                        dialog.progressBar.setIndeterminateDrawable((Drawable)d);
                    }
                } else {
                    d = new HorizontalProgressDrawable(builder.getContext());
                    ((HorizontalProgressDrawable)d).setTint(builder.widgetColor);
                    dialog.progressBar.setProgressDrawable((Drawable)d);
                    dialog.progressBar.setIndeterminateDrawable((Drawable)d);
                }
            } else {
                MDTintHelper.setTint(dialog.progressBar, builder.widgetColor);
            }
            if (!builder.indeterminateProgress || builder.indeterminateIsHorizontalProgress) {
                dialog.progressBar.setIndeterminate(builder.indeterminateProgress && builder.indeterminateIsHorizontalProgress);
                dialog.progressBar.setProgress(0);
                dialog.progressBar.setMax(builder.progressMax);
                dialog.progressLabel = (TextView)dialog.view.findViewById(R.id.md_label);
                if (dialog.progressLabel != null) {
                    dialog.setTypeface(dialog.progressLabel, builder.mediumFont);
                    dialog.progressLabel.setText((CharSequence)builder.progressPercentFormat.format(0L));
                }
                dialog.progressMinMax = (TextView)dialog.view.findViewById(R.id.md_minMax);
                if (dialog.progressMinMax != null) {
                    dialog.setTypeface(dialog.progressMinMax, builder.regularFont);
                    if (builder.showMinMax) {
                        dialog.progressMinMax.setVisibility(0);
                        dialog.progressMinMax.setText((CharSequence)String.format(builder.progressNumberFormat, 0, builder.progressMax));
                        ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)dialog.progressBar.getLayoutParams();
                        lp.leftMargin = 0;
                        lp.rightMargin = 0;
                    } else {
                        dialog.progressMinMax.setVisibility(8);
                    }
                } else {
                    builder.showMinMax = false;
                }
            }
        }
        if (dialog.progressBar != null) {
            DialogInit.fixCanvasScalingWhenHardwareAccelerated(dialog.progressBar);
        }
    }

    private static void setupInputDialog(MaterialDialog dialog) {
        MaterialDialog.Builder builder = dialog.builder;
        dialog.input = (EditText)dialog.view.findViewById(16908297);
        if (dialog.input == null) {
            return;
        }
        dialog.setTypeface((TextView)dialog.input, builder.regularFont);
        if (builder.inputPrefill != null) {
            dialog.input.setText(builder.inputPrefill);
        }
        dialog.setInternalInputCallback();
        dialog.input.setHint(builder.inputHint);
        dialog.input.setSingleLine();
        dialog.input.setTextColor(builder.contentColor);
        dialog.input.setHintTextColor(ThemeUtils.adjustAlpha(builder.contentColor, 0.3f));
        MDTintHelper.setTint(dialog.input, dialog.builder.widgetColor);
        if (builder.inputType != -1) {
            dialog.input.setInputType(builder.inputType);
            if (builder.inputType != 144 && (builder.inputType & 0x80) == 128) {
                dialog.input.setTransformationMethod((TransformationMethod)PasswordTransformationMethod.getInstance());
            }
        }
        dialog.inputMinMax = (TextView)dialog.view.findViewById(R.id.md_minMax);
        if (builder.inputMinLength > 0 || builder.inputMaxLength > -1) {
            dialog.invalidateInputMinMaxIndicator(dialog.input.getText().toString().length(), !builder.inputAllowEmpty);
        } else {
            dialog.inputMinMax.setVisibility(8);
            dialog.inputMinMax = null;
        }
    }
}

