/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.dialog.bottomsheet;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.support.v7.content.res.AppCompatResources;
import android.support.v7.widget.AppCompatImageView;
import android.util.Log;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.view.WindowManager;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.TranslateAnimation;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.xuexiang.xui.R;
import com.xuexiang.xui.logs.UILog;
import com.xuexiang.xui.utils.ThemeUtils;
import com.xuexiang.xui.utils.Utils;
import com.xuexiang.xui.widget.dialog.bottomsheet.BottomSheetItemView;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;

public class BottomSheet
extends Dialog {
    private static final int mAnimationDuration = 200;
    private View mContentView;
    private boolean mIsAnimating = false;
    private OnBottomSheetShowListener mOnBottomSheetShowListener;

    public BottomSheet(Context context) {
        super(context, R.style.BottomSheet);
    }

    public void setOnBottomSheetShowListener(OnBottomSheetShowListener onBottomSheetShowListener) {
        this.mOnBottomSheetShowListener = onBottomSheetShowListener;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.getWindow().getDecorView().setPadding(0, 0, 0, 0);
        WindowManager.LayoutParams params = this.getWindow().getAttributes();
        params.height = -2;
        params.gravity = 81;
        int screenWidth = Utils.getScreenWidth(this.getContext());
        int screenHeight = Utils.getScreenHeight(this.getContext());
        params.width = screenWidth < screenHeight ? screenWidth : screenHeight;
        this.getWindow().setAttributes(params);
        this.setCanceledOnTouchOutside(true);
    }

    public void setContentView(int layoutResID) {
        this.mContentView = LayoutInflater.from((Context)this.getContext()).inflate(layoutResID, null);
        super.setContentView(this.mContentView);
    }

    public void setContentView(@NonNull View view, ViewGroup.LayoutParams params) {
        this.mContentView = view;
        super.setContentView(view, params);
    }

    public View getContentView() {
        return this.mContentView;
    }

    public void setContentView(@NonNull View view) {
        this.mContentView = view;
        super.setContentView(view);
    }

    private void animateUp() {
        if (this.mContentView == null) {
            return;
        }
        TranslateAnimation translate = new TranslateAnimation(1, 0.0f, 1, 0.0f, 1, 1.0f, 1, 0.0f);
        AlphaAnimation alpha = new AlphaAnimation(0.0f, 1.0f);
        AnimationSet set = new AnimationSet(true);
        set.addAnimation((Animation)translate);
        set.addAnimation((Animation)alpha);
        set.setInterpolator((Interpolator)new DecelerateInterpolator());
        set.setDuration(200L);
        set.setFillAfter(true);
        this.mContentView.startAnimation((Animation)set);
    }

    private void animateDown() {
        if (this.mContentView == null) {
            return;
        }
        TranslateAnimation translate = new TranslateAnimation(1, 0.0f, 1, 0.0f, 1, 0.0f, 1, 1.0f);
        AlphaAnimation alpha = new AlphaAnimation(1.0f, 0.0f);
        AnimationSet set = new AnimationSet(true);
        set.addAnimation((Animation)translate);
        set.addAnimation((Animation)alpha);
        set.setInterpolator((Interpolator)new DecelerateInterpolator());
        set.setDuration(200L);
        set.setFillAfter(true);
        set.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
                BottomSheet.this.mIsAnimating = true;
            }

            public void onAnimationEnd(Animation animation) {
                BottomSheet.this.mIsAnimating = false;
                BottomSheet.this.mContentView.post(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            BottomSheet.super.dismiss();
                        }
                        catch (Exception e) {
                            UILog.w("dismiss error\n" + Log.getStackTraceString((Throwable)e));
                        }
                    }
                });
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        this.mContentView.startAnimation((Animation)set);
    }

    public void show() {
        super.show();
        this.animateUp();
        if (this.mOnBottomSheetShowListener != null) {
            this.mOnBottomSheetShowListener.onShow();
        }
    }

    public void dismiss() {
        if (this.mIsAnimating) {
            return;
        }
        this.animateDown();
    }

    public static class BottomGridSheetBuilder {
        public static final int FIRST_LINE = 0;
        public static final int SECOND_LINE = 1;
        private Context mContext;
        private BottomSheet mDialog;
        private SparseArray<View> mFirstLineViews;
        private SparseArray<View> mSecondLineViews;
        private int mMiniItemWidth = -1;
        private OnSheetItemClickListener mOnSheetItemClickListener;
        private Typeface mItemTextTypeFace = null;
        private ViewGroup mBottomButtonContainer;
        private TextView mBottomButton;
        private Typeface mBottomButtonTypeFace = null;
        private boolean mIsShowButton = true;
        private CharSequence mButtonText = null;
        private View.OnClickListener mButtonClickListener = null;

        public BottomGridSheetBuilder(Context context) {
            this.mContext = context;
            this.mFirstLineViews = new SparseArray();
            this.mSecondLineViews = new SparseArray();
        }

        public BottomGridSheetBuilder addItem(int imageRes, CharSequence textAndTag, int style2) {
            return this.addItem(imageRes, textAndTag, textAndTag, style2, 0);
        }

        public BottomGridSheetBuilder addItem(int imageRes, CharSequence text, Object tag, int style2) {
            return this.addItem(imageRes, text, tag, style2, 0);
        }

        public BottomGridSheetBuilder setIsShowButton(boolean isShowButton) {
            this.mIsShowButton = isShowButton;
            return this;
        }

        public BottomGridSheetBuilder setButtonText(CharSequence buttonText) {
            this.mButtonText = buttonText;
            return this;
        }

        public BottomGridSheetBuilder setButtonClickListener(View.OnClickListener buttonClickListener) {
            this.mButtonClickListener = buttonClickListener;
            return this;
        }

        public BottomGridSheetBuilder setItemTextTypeFace(Typeface itemTextTypeFace) {
            this.mItemTextTypeFace = itemTextTypeFace;
            return this;
        }

        public BottomGridSheetBuilder setBottomButtonTypeFace(Typeface bottomButtonTypeFace) {
            this.mBottomButtonTypeFace = bottomButtonTypeFace;
            return this;
        }

        public BottomGridSheetBuilder addItem(int imageRes, CharSequence text, Object tag, int style2, int subscriptRes) {
            BottomSheetItemView itemView = this.createItemView(AppCompatResources.getDrawable((Context)this.mContext, (int)imageRes), text, tag, subscriptRes);
            return this.addItem((View)itemView, style2);
        }

        public BottomGridSheetBuilder addItem(View view, int style2) {
            switch (style2) {
                case 0: {
                    this.mFirstLineViews.append(this.mFirstLineViews.size(), (Object)view);
                    break;
                }
                case 1: {
                    this.mSecondLineViews.append(this.mSecondLineViews.size(), (Object)view);
                }
            }
            return this;
        }

        public BottomSheetItemView createItemView(Drawable drawable2, CharSequence text, Object tag, int subscriptRes) {
            LayoutInflater inflater = LayoutInflater.from((Context)this.mContext);
            BottomSheetItemView itemView = (BottomSheetItemView)inflater.inflate(this.getItemViewLayoutId(), null, false);
            TextView titleTV = (TextView)itemView.findViewById(R.id.grid_item_title);
            if (this.mItemTextTypeFace != null) {
                titleTV.setTypeface(this.mItemTextTypeFace);
            }
            titleTV.setText(text);
            itemView.setTag(tag);
            itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (BottomGridSheetBuilder.this.mOnSheetItemClickListener != null) {
                        BottomGridSheetBuilder.this.mOnSheetItemClickListener.onClick(BottomGridSheetBuilder.this.mDialog, (BottomSheetItemView)v);
                    }
                }
            });
            AppCompatImageView imageView = (AppCompatImageView)itemView.findViewById(R.id.grid_item_image);
            imageView.setImageDrawable(drawable2);
            if (subscriptRes != 0) {
                ViewStub stub = (ViewStub)itemView.findViewById(R.id.grid_item_subscript);
                View inflated = stub.inflate();
                ((ImageView)inflated).setImageResource(subscriptRes);
            }
            return itemView;
        }

        public void setItemVisibility(Object tag, int visibility) {
            View view;
            int i;
            View foundView = null;
            for (i = 0; i < this.mFirstLineViews.size(); ++i) {
                view = (View)this.mFirstLineViews.get(i);
                if (view == null || !view.getTag().equals(tag)) continue;
                foundView = view;
            }
            for (i = 0; i < this.mSecondLineViews.size(); ++i) {
                view = (View)this.mSecondLineViews.get(i);
                if (view == null || !view.getTag().equals(tag)) continue;
                foundView = view;
            }
            if (foundView != null) {
                foundView.setVisibility(visibility);
            }
        }

        public BottomGridSheetBuilder setOnSheetItemClickListener(OnSheetItemClickListener onSheetItemClickListener) {
            this.mOnSheetItemClickListener = onSheetItemClickListener;
            return this;
        }

        public BottomSheet build() {
            this.mDialog = new BottomSheet(this.mContext);
            View contentView = this.buildViews();
            this.mDialog.setContentView(contentView, new ViewGroup.LayoutParams(-1, -2));
            return this.mDialog;
        }

        private View buildViews() {
            boolean hasSecondLine;
            int screenHeight;
            LinearLayout baseLinearLayout = (LinearLayout)View.inflate((Context)this.mContext, (int)this.getContentViewLayoutId(), null);
            LinearLayout firstLine = (LinearLayout)baseLinearLayout.findViewById(R.id.bottom_sheet_first_linear_layout);
            LinearLayout secondLine = (LinearLayout)baseLinearLayout.findViewById(R.id.bottom_sheet_second_linear_layout);
            this.mBottomButtonContainer = (ViewGroup)baseLinearLayout.findViewById(R.id.bottom_sheet_button_container);
            this.mBottomButton = (TextView)baseLinearLayout.findViewById(R.id.bottom_sheet_close_button);
            int maxItemCountEachLine = Math.max(this.mFirstLineViews.size(), this.mSecondLineViews.size());
            int screenWidth = Utils.getScreenWidth(this.mContext);
            int width = screenWidth < (screenHeight = Utils.getScreenHeight(this.mContext)) ? screenWidth : screenHeight;
            int itemWidth = this.calculateItemWidth(width, maxItemCountEachLine, firstLine.getPaddingLeft(), firstLine.getPaddingRight());
            this.addViewsInSection(this.mFirstLineViews, firstLine, itemWidth);
            this.addViewsInSection(this.mSecondLineViews, secondLine, itemWidth);
            boolean hasFirstLine = this.mFirstLineViews.size() > 0;
            boolean bl = hasSecondLine = this.mSecondLineViews.size() > 0;
            if (!hasFirstLine) {
                firstLine.setVisibility(8);
            }
            if (!hasSecondLine) {
                if (hasFirstLine) {
                    firstLine.setPadding(firstLine.getPaddingLeft(), firstLine.getPaddingTop(), firstLine.getPaddingRight(), 0);
                }
                secondLine.setVisibility(8);
            }
            if (this.mBottomButtonContainer != null) {
                if (this.mIsShowButton) {
                    this.mBottomButtonContainer.setVisibility(0);
                    baseLinearLayout.setPadding(baseLinearLayout.getPaddingLeft(), baseLinearLayout.getPaddingTop(), baseLinearLayout.getPaddingRight(), 0);
                } else {
                    this.mBottomButtonContainer.setVisibility(8);
                }
                if (this.mBottomButtonTypeFace != null) {
                    this.mBottomButton.setTypeface(this.mBottomButtonTypeFace);
                }
                if (this.mButtonText != null) {
                    this.mBottomButton.setText(this.mButtonText);
                }
                if (this.mButtonClickListener != null) {
                    this.mBottomButton.setOnClickListener(this.mButtonClickListener);
                } else {
                    this.mBottomButton.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View v) {
                            BottomGridSheetBuilder.this.mDialog.dismiss();
                        }
                    });
                }
            }
            return baseLinearLayout;
        }

        protected int getContentViewLayoutId() {
            return R.layout.xui_bottom_sheet_grid;
        }

        protected int getItemViewLayoutId() {
            return R.layout.xui_bottom_sheet_grid_item;
        }

        private int calculateItemWidth(int width, int maxItemCountInEachLine, int paddingLeft, int paddingRight) {
            int count;
            if (this.mMiniItemWidth == -1) {
                this.mMiniItemWidth = ThemeUtils.resolveDimension(this.mContext, R.attr.xui_bottom_sheet_grid_item_mini_width);
            }
            int parentSpacing = width - paddingLeft - paddingRight;
            int itemWidth = this.mMiniItemWidth;
            if (maxItemCountInEachLine >= 3 && parentSpacing - maxItemCountInEachLine * itemWidth > 0 && parentSpacing - maxItemCountInEachLine * itemWidth < itemWidth) {
                count = parentSpacing / itemWidth;
                itemWidth = parentSpacing / count;
            }
            if (itemWidth * maxItemCountInEachLine > parentSpacing) {
                count = (width - paddingLeft) / itemWidth;
                itemWidth = (int)((float)(width - paddingLeft) / ((float)count + 0.5f));
            }
            return itemWidth;
        }

        private void addViewsInSection(SparseArray<View> items, LinearLayout parent, int itemWidth) {
            for (int i = 0; i < items.size(); ++i) {
                View itemView = (View)items.get(i);
                this.setItemWidth(itemView, itemWidth);
                parent.addView(itemView);
            }
        }

        private void setItemWidth(View itemView, int itemWidth) {
            LinearLayout.LayoutParams itemLp;
            if (itemView.getLayoutParams() != null) {
                itemLp = (LinearLayout.LayoutParams)itemView.getLayoutParams();
                itemLp.width = itemWidth;
            } else {
                itemLp = new LinearLayout.LayoutParams(itemWidth, -2);
                itemView.setLayoutParams((ViewGroup.LayoutParams)itemLp);
            }
            itemLp.gravity = 48;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface Style {
        }

        public static interface OnSheetItemClickListener {
            public void onClick(BottomSheet var1, BottomSheetItemView var2);
        }
    }

    public static class BottomListSheetBuilder {
        private Context mContext;
        private BottomSheet mDialog;
        private List<BottomSheetListItemData> mItems;
        private BaseAdapter mAdapter;
        private List<View> mHeaderViews;
        private ListView mContainerView;
        private boolean mNeedRightMark;
        private int mCheckedIndex;
        private String mTitle;
        private boolean mIsCenter;
        private TextView mTitleTv;
        private OnSheetItemClickListener mOnSheetItemClickListener;
        private DialogInterface.OnDismissListener mOnBottomDialogDismissListener;

        public BottomListSheetBuilder(Context context) {
            this(context, false);
        }

        public BottomListSheetBuilder(Context context, boolean needRightMark) {
            this.mContext = context;
            this.mItems = new ArrayList<BottomSheetListItemData>();
            this.mHeaderViews = new ArrayList<View>();
            this.mNeedRightMark = needRightMark;
            this.mIsCenter = false;
        }

        public BottomListSheetBuilder setCheckedIndex(int checkedIndex) {
            this.mCheckedIndex = checkedIndex;
            return this;
        }

        public BottomListSheetBuilder addItem(String textAndTag) {
            this.mItems.add(new BottomSheetListItemData(textAndTag, textAndTag));
            return this;
        }

        public BottomListSheetBuilder addItem(Drawable image, String textAndTag) {
            this.mItems.add(new BottomSheetListItemData(image, textAndTag, textAndTag));
            return this;
        }

        public BottomListSheetBuilder addItem(String text, String tag) {
            this.mItems.add(new BottomSheetListItemData(text, tag));
            return this;
        }

        public BottomListSheetBuilder addItem(int imageRes, String text, String tag) {
            Drawable drawable2 = imageRes != 0 ? ContextCompat.getDrawable((Context)this.mContext, (int)imageRes) : null;
            this.mItems.add(new BottomSheetListItemData(drawable2, text, tag));
            return this;
        }

        public BottomListSheetBuilder addItem(int imageRes, String text, String tag, boolean hasRedPoint) {
            Drawable drawable2 = imageRes != 0 ? ContextCompat.getDrawable((Context)this.mContext, (int)imageRes) : null;
            this.mItems.add(new BottomSheetListItemData(drawable2, text, tag, hasRedPoint));
            return this;
        }

        public BottomListSheetBuilder addItem(int imageRes, String text, String tag, boolean hasRedPoint, boolean disabled) {
            Drawable drawable2 = imageRes != 0 ? ContextCompat.getDrawable((Context)this.mContext, (int)imageRes) : null;
            this.mItems.add(new BottomSheetListItemData(drawable2, text, tag, hasRedPoint, disabled));
            return this;
        }

        public BottomListSheetBuilder setOnSheetItemClickListener(OnSheetItemClickListener onSheetItemClickListener) {
            this.mOnSheetItemClickListener = onSheetItemClickListener;
            return this;
        }

        public BottomListSheetBuilder setOnBottomDialogDismissListener(DialogInterface.OnDismissListener listener) {
            this.mOnBottomDialogDismissListener = listener;
            return this;
        }

        public BottomListSheetBuilder addHeaderView(View view) {
            if (view != null) {
                this.mHeaderViews.add(view);
            }
            return this;
        }

        public BottomListSheetBuilder setTitle(String title) {
            this.mTitle = title;
            return this;
        }

        public BottomListSheetBuilder setTitle(int resId) {
            this.mTitle = this.mContext.getResources().getString(resId);
            return this;
        }

        public BottomListSheetBuilder setIsCenter(boolean isCenter) {
            this.mIsCenter = isCenter;
            return this;
        }

        public BottomSheet build() {
            this.mDialog = new BottomSheet(this.mContext);
            View contentView = this.buildViews();
            this.mDialog.setContentView(contentView, new ViewGroup.LayoutParams(-1, -2));
            if (this.mOnBottomDialogDismissListener != null) {
                this.mDialog.setOnDismissListener(this.mOnBottomDialogDismissListener);
            }
            return this.mDialog;
        }

        private View buildViews() {
            View wrapperView = View.inflate((Context)this.mContext, (int)this.getContentViewLayoutId(), null);
            this.mTitleTv = (TextView)wrapperView.findViewById(R.id.title);
            this.mContainerView = (ListView)wrapperView.findViewById(R.id.listview);
            if (this.mTitle != null && this.mTitle.length() != 0) {
                this.mTitleTv.setVisibility(0);
                this.mTitleTv.setText((CharSequence)this.mTitle);
            } else {
                this.mTitleTv.setVisibility(8);
            }
            if (this.mIsCenter) {
                this.mTitleTv.setGravity(17);
            }
            if (this.mHeaderViews.size() > 0) {
                for (View headerView : this.mHeaderViews) {
                    this.mContainerView.addHeaderView(headerView);
                }
            }
            if (this.needToScroll()) {
                this.mContainerView.getLayoutParams().height = this.getListMaxHeight();
                this.mDialog.setOnBottomSheetShowListener(new OnBottomSheetShowListener(){

                    @Override
                    public void onShow() {
                        BottomListSheetBuilder.this.mContainerView.setSelection(BottomListSheetBuilder.this.mCheckedIndex);
                    }
                });
            }
            this.mAdapter = new ListAdapter(this.mIsCenter);
            this.mContainerView.setAdapter((android.widget.ListAdapter)this.mAdapter);
            return wrapperView;
        }

        private boolean needToScroll() {
            int itemHeight = ThemeUtils.resolveDimension(this.mContext, R.attr.xui_bottom_sheet_list_item_height);
            int totalHeight = this.mItems.size() * itemHeight;
            if (this.mHeaderViews.size() > 0) {
                for (View view : this.mHeaderViews) {
                    if (view.getMeasuredHeight() == 0) {
                        view.measure(0, 0);
                    }
                    totalHeight += view.getMeasuredHeight();
                }
            }
            if (this.mTitleTv != null && !Utils.isNullOrEmpty(this.mTitle)) {
                totalHeight += ThemeUtils.resolveDimension(this.mContext, R.attr.xui_bottom_sheet_title_height);
            }
            return totalHeight > this.getListMaxHeight();
        }

        protected int getListMaxHeight() {
            return (int)((double)Utils.getScreenHeight(this.mContext) * 0.5);
        }

        public void notifyDataSetChanged() {
            if (this.mAdapter != null) {
                this.mAdapter.notifyDataSetChanged();
            }
            if (this.needToScroll()) {
                this.mContainerView.getLayoutParams().height = this.getListMaxHeight();
                this.mContainerView.setSelection(this.mCheckedIndex);
            }
        }

        protected int getContentViewLayoutId() {
            return R.layout.xui_bottom_sheet_list;
        }

        private class ListAdapter
        extends BaseAdapter {
            private boolean mIsCenter;

            public ListAdapter(boolean isCenter) {
                this.mIsCenter = isCenter;
            }

            public int getCount() {
                return BottomListSheetBuilder.this.mItems.size();
            }

            public BottomSheetListItemData getItem(int position) {
                return (BottomSheetListItemData)BottomListSheetBuilder.this.mItems.get(position);
            }

            public long getItemId(int position) {
                return 0L;
            }

            public View getView(final int position, View convertView, ViewGroup parent) {
                ViewHolder holder;
                final BottomSheetListItemData data = this.getItem(position);
                if (convertView == null) {
                    LayoutInflater inflater = LayoutInflater.from((Context)BottomListSheetBuilder.this.mContext);
                    convertView = inflater.inflate(R.layout.xui_bottom_sheet_list_item, parent, false);
                    holder = new ViewHolder();
                    holder.imageView = (ImageView)convertView.findViewById(R.id.bottom_dialog_list_item_img);
                    holder.textView = (TextView)convertView.findViewById(R.id.bottom_dialog_list_item_title);
                    if (this.mIsCenter) {
                        holder.textView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
                        holder.textView.setGravity(17);
                    }
                    holder.markView = convertView.findViewById(R.id.bottom_dialog_list_item_mark_view_stub);
                    holder.redPoint = convertView.findViewById(R.id.bottom_dialog_list_item_point);
                    convertView.setTag((Object)holder);
                } else {
                    holder = (ViewHolder)convertView.getTag();
                }
                if (data.image != null) {
                    holder.imageView.setVisibility(0);
                    holder.imageView.setImageDrawable(data.image);
                } else {
                    holder.imageView.setVisibility(8);
                }
                holder.textView.setText((CharSequence)data.text);
                if (data.hasRedPoint) {
                    holder.redPoint.setVisibility(0);
                } else {
                    holder.redPoint.setVisibility(8);
                }
                if (data.isDisabled) {
                    holder.textView.setEnabled(false);
                    convertView.setEnabled(false);
                } else {
                    holder.textView.setEnabled(true);
                    convertView.setEnabled(true);
                }
                if (BottomListSheetBuilder.this.mNeedRightMark) {
                    if (holder.markView instanceof ViewStub) {
                        holder.markView = ((ViewStub)holder.markView).inflate();
                    }
                    if (BottomListSheetBuilder.this.mCheckedIndex == position) {
                        holder.markView.setVisibility(0);
                    } else {
                        holder.markView.setVisibility(8);
                    }
                } else {
                    holder.markView.setVisibility(8);
                }
                convertView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (data.hasRedPoint) {
                            data.hasRedPoint = false;
                            holder.redPoint.setVisibility(8);
                        }
                        if (BottomListSheetBuilder.this.mNeedRightMark) {
                            BottomListSheetBuilder.this.setCheckedIndex(position);
                            ListAdapter.this.notifyDataSetChanged();
                        }
                        if (BottomListSheetBuilder.this.mOnSheetItemClickListener != null) {
                            BottomListSheetBuilder.this.mOnSheetItemClickListener.onClick(BottomListSheetBuilder.this.mDialog, v, position, data.tag);
                        }
                    }
                });
                return convertView;
            }
        }

        private static class ViewHolder {
            ImageView imageView;
            TextView textView;
            View markView;
            View redPoint;

            private ViewHolder() {
            }
        }

        private static class BottomSheetListItemData {
            Drawable image = null;
            String text;
            String tag = "";
            boolean hasRedPoint = false;
            boolean isDisabled = false;

            public BottomSheetListItemData(String text, String tag) {
                this.text = text;
                this.tag = tag;
            }

            public BottomSheetListItemData(Drawable image, String text, String tag) {
                this.image = image;
                this.text = text;
                this.tag = tag;
            }

            public BottomSheetListItemData(Drawable image, String text, String tag, boolean hasRedPoint) {
                this.image = image;
                this.text = text;
                this.tag = tag;
                this.hasRedPoint = hasRedPoint;
            }

            public BottomSheetListItemData(Drawable image, String text, String tag, boolean hasRedPoint, boolean isDisabled) {
                this.image = image;
                this.text = text;
                this.tag = tag;
                this.hasRedPoint = hasRedPoint;
                this.isDisabled = isDisabled;
            }
        }

        public static interface OnSheetItemClickListener {
            public void onClick(BottomSheet var1, View var2, int var3, String var4);
        }
    }

    public static interface OnBottomSheetShowListener {
        public void onShow();
    }
}

