/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.dialog;

import android.content.Context;
import android.content.DialogInterface;
import android.graphics.drawable.Drawable;
import android.support.annotation.StyleRes;
import android.widget.TextView;
import com.xuexiang.xui.R;
import com.xuexiang.xui.widget.dialog.BaseDialog;
import com.xuexiang.xui.widget.progress.loading.ARCLoadingView;
import com.xuexiang.xui.widget.progress.loading.IMessageLoader;
import com.xuexiang.xui.widget.progress.loading.LoadingCancelListener;

public class LoadingDialog
extends BaseDialog
implements IMessageLoader {
    private ARCLoadingView mLoadingView;
    private TextView mTvTipMessage;
    private LoadingCancelListener mLoadingCancelListener;

    public LoadingDialog(Context context) {
        super(context, R.layout.xui_dialog_loading);
        this.initView(this.getString(R.string.xui_tip_loading_message));
    }

    public LoadingDialog(Context context, String tipMessage) {
        super(context, R.layout.xui_dialog_loading);
        this.initView(tipMessage);
    }

    public LoadingDialog(Context context, @StyleRes int themeResId) {
        super(context, themeResId, R.layout.xui_dialog_loading);
        this.initView(this.getString(R.string.xui_tip_loading_message));
    }

    public LoadingDialog(Context context, @StyleRes int themeResId, String tipMessage) {
        super(context, themeResId, R.layout.xui_dialog_loading);
        this.initView(tipMessage);
    }

    private void initView(String tipMessage) {
        this.mLoadingView = (ARCLoadingView)((Object)this.findViewById(R.id.arc_loading_view));
        this.mTvTipMessage = (TextView)this.findViewById(R.id.tv_tip_message);
        this.updateMessage(tipMessage);
        this.setCancelable(false);
        this.setCanceledOnTouchOutside(false);
    }

    @Override
    public void updateMessage(String tipMessage) {
        if (this.mTvTipMessage != null) {
            this.mTvTipMessage.setText((CharSequence)tipMessage);
        }
    }

    @Override
    public void updateMessage(int tipMessageId) {
        this.updateMessage(this.getString(tipMessageId));
    }

    public LoadingDialog setLoadingIcon(Drawable icon) {
        if (this.mLoadingView != null) {
            this.mLoadingView.setLoadingIcon(icon);
        }
        return this;
    }

    public LoadingDialog setLoadingIcon(int iconResId) {
        return this.setLoadingIcon(this.getDrawable(iconResId));
    }

    public LoadingDialog setIconScale(float iconScale) {
        if (this.mLoadingView != null) {
            this.mLoadingView.setIconScale(iconScale);
        }
        return this;
    }

    public LoadingDialog setLoadingSpeed(int speed) {
        if (this.mLoadingView != null) {
            this.mLoadingView.setSpeedOfDegree(speed);
        }
        return this;
    }

    @Override
    public void show() {
        super.show();
        if (this.mLoadingView != null) {
            this.mLoadingView.start();
        }
    }

    @Override
    public void dismiss() {
        if (this.mLoadingView != null) {
            this.mLoadingView.stop();
        }
        super.dismiss();
    }

    @Override
    public void recycle() {
        if (this.mLoadingView != null) {
            this.mLoadingView.recycle();
        }
    }

    @Override
    public boolean isLoading() {
        return this.isShowing();
    }

    @Override
    public void setCancelable(boolean flag) {
        super.setCancelable(flag);
        if (flag) {
            this.setOnCancelListener(new DialogInterface.OnCancelListener(){

                public void onCancel(DialogInterface dialogInterface) {
                    if (LoadingDialog.this.mLoadingCancelListener != null) {
                        LoadingDialog.this.mLoadingCancelListener.onCancelLoading();
                    }
                }
            });
        }
    }

    @Override
    public void setLoadingCancelListener(LoadingCancelListener listener) {
        this.mLoadingCancelListener = listener;
    }
}

