/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.button.shadowbutton;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.support.v7.widget.AppCompatImageView;
import android.util.AttributeSet;
import android.view.MotionEvent;
import com.xuexiang.xui.R;

public class ShadowImageView
extends AppCompatImageView {
    private int mWidth;
    private int mHeight;
    private int mPaintAlpha = 48;
    private int mPressedColor;
    private Paint mPaint;
    private int mShapeType;
    private int mRadius;

    public ShadowImageView(Context context) {
        super(context);
        this.init(context, null);
    }

    public ShadowImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public ShadowImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        if (this.isInEditMode()) {
            return;
        }
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.ShadowButton);
        this.mPressedColor = typedArray.getColor(R.styleable.ShadowButton_sb_color_pressed, this.getResources().getColor(R.color.default_shadow_button_color_pressed));
        this.mPaintAlpha = typedArray.getInteger(R.styleable.ShadowButton_sb_alpha_pressed, this.mPaintAlpha);
        this.mShapeType = typedArray.getInt(R.styleable.ShadowButton_sb_shape_type, 1);
        this.mRadius = typedArray.getDimensionPixelSize(R.styleable.ShadowButton_sb_radius, this.getResources().getDimensionPixelSize(R.dimen.default_shadow_button_radius));
        typedArray.recycle();
        this.mPaint = new Paint();
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setColor(this.mPressedColor);
        this.setWillNotDraw(false);
        this.mPaint.setAlpha(0);
        this.mPaint.setAntiAlias(true);
        this.setDrawingCacheEnabled(true);
        this.setClickable(true);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mWidth = w;
        this.mHeight = h;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mPaint == null) {
            return;
        }
        if (this.mShapeType == 0) {
            canvas.drawCircle((float)(this.mWidth / 2), (float)(this.mHeight / 2), (float)this.mWidth / 2.1038f, this.mPaint);
        } else {
            RectF rectF = new RectF();
            rectF.set(0.0f, 0.0f, (float)this.mWidth, (float)this.mHeight);
            canvas.drawRoundRect(rectF, (float)this.mRadius, (float)this.mRadius, this.mPaint);
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                this.mPaint.setAlpha(this.mPaintAlpha);
                this.invalidate();
                break;
            }
            case 1: 
            case 3: {
                this.mPaint.setAlpha(0);
                this.invalidate();
                break;
            }
        }
        return super.onTouchEvent(event);
    }

    public int getPressedColor() {
        return this.mPressedColor;
    }

    public void setPressedColor(int pressedColor) {
        this.mPaint.setColor(this.mPressedColor);
        this.invalidate();
    }
}

