/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.banner.recycler.layout;

import android.content.Context;
import android.graphics.PointF;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v7.widget.LinearSmoothScroller;
import android.support.v7.widget.OrientationHelper;
import android.support.v7.widget.RecyclerView;
import android.view.View;

public class OverFlyingLayoutManager
extends RecyclerView.LayoutManager
implements RecyclerView.SmoothScroller.ScrollVectorProvider {
    private float minScale = 0.75f;
    private float angle = 8.0f;
    private int itemSpace = 385;
    private boolean mInfinite = true;
    public static final int DETERMINE_BY_MAX_AND_MIN = -1;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    protected int mDecoratedMeasurement;
    protected int mDecoratedMeasurementInOther;
    int mOrientation;
    protected int mSpaceMain;
    protected int mSpaceInOther;
    protected float mOffset;
    protected OrientationHelper mOrientationHelper;
    private boolean mReverseLayout = false;
    private boolean mSmoothScrollbarEnabled = true;
    private int mPendingScrollPosition = -1;
    private SavedState mPendingSavedState = null;
    protected float mInterval;
    OnPageChangeListener onPageChangeListener;
    private boolean mRecycleChildrenOnDetach;
    private boolean mEnableBringCenterToFront;
    private boolean mIntegerDy = false;
    private int mLeftItems;
    private int mRightItems;
    private int mMaxVisibleItemCount = -1;

    public float getMinScale() {
        return this.minScale;
    }

    public void setMinScale(float minScale) {
        this.minScale = minScale;
    }

    public float getAngle() {
        return this.angle;
    }

    public void setAngle(float angle) {
        this.angle = angle;
    }

    public int getItemSpace() {
        return this.itemSpace;
    }

    public void setItemSpace(int itemSpace) {
        this.itemSpace = itemSpace;
    }

    protected float setInterval() {
        return this.mDecoratedMeasurement - this.itemSpace;
    }

    protected void setItemViewProperty(View itemView, float targetOffset) {
        float scale = this.calculateScale(targetOffset + (float)this.mSpaceMain);
        itemView.setScaleX(scale);
        itemView.setScaleY(scale);
        if (Build.VERSION.SDK_INT >= 21) {
            itemView.setElevation(0.0f);
        }
        float rotation = this.calRotation(targetOffset);
        if (this.getOrientation() == 0) {
            itemView.setRotationY(rotation);
        } else {
            itemView.setRotationX(-rotation);
        }
    }

    private float calRotation(float targetOffset) {
        return -this.angle / this.mInterval * targetOffset;
    }

    private float calculateScale(float x) {
        float deltaX = Math.abs(x - (float)(this.mOrientationHelper.getTotalSpace() - this.mDecoratedMeasurement) / 2.0f);
        return (this.minScale - 1.0f) * deltaX / ((float)this.mOrientationHelper.getTotalSpace() / 2.0f) + 1.0f;
    }

    protected float setViewElevation(View itemView, float targetOffset) {
        return itemView.getScaleX() * 5.0f;
    }

    public OverFlyingLayoutManager(Context context) {
        this(0, false);
    }

    public OverFlyingLayoutManager(int orientation, boolean reverseLayout) {
        this.setOrientation(orientation);
        this.setReverseLayout(reverseLayout);
        this.setAutoMeasureEnabled(true);
        this.setEnableBringCenterToFront(true);
        this.setIntegerDy(true);
    }

    public OverFlyingLayoutManager(float minScale, int itemSpace, int orientation) {
        this(orientation, false);
        this.minScale = minScale;
        this.itemSpace = itemSpace;
        this.mOrientation = orientation;
    }

    public RecyclerView.LayoutParams generateDefaultLayoutParams() {
        return new RecyclerView.LayoutParams(-2, -2);
    }

    public boolean getRecycleChildrenOnDetach() {
        return this.mRecycleChildrenOnDetach;
    }

    public void setRecycleChildrenOnDetach(boolean recycleChildrenOnDetach) {
        this.mRecycleChildrenOnDetach = recycleChildrenOnDetach;
    }

    public void onDetachedFromWindow(RecyclerView view, RecyclerView.Recycler recycler) {
        super.onDetachedFromWindow(view, recycler);
        if (this.mRecycleChildrenOnDetach) {
            this.removeAndRecycleAllViews(recycler);
            recycler.clear();
        }
    }

    public Parcelable onSaveInstanceState() {
        if (this.mPendingSavedState != null) {
            return new SavedState(this.mPendingSavedState);
        }
        SavedState savedState = new SavedState();
        savedState.position = this.mPendingScrollPosition;
        savedState.offset = this.mOffset;
        savedState.isReverseLayout = this.mReverseLayout;
        return savedState;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (state instanceof SavedState) {
            this.mPendingSavedState = new SavedState((SavedState)state);
            this.requestLayout();
        }
    }

    public boolean canScrollHorizontally() {
        return this.mOrientation == 0;
    }

    public boolean canScrollVertically() {
        return this.mOrientation == 1;
    }

    public int getOrientation() {
        return this.mOrientation;
    }

    public void setOrientation(int orientation) {
        if (orientation != 0 && orientation != 1) {
            throw new IllegalArgumentException("invalid orientation:" + orientation);
        }
        this.assertNotInLayoutOrScroll(null);
        if (orientation == this.mOrientation) {
            return;
        }
        this.mOrientation = orientation;
        this.mOrientationHelper = null;
        this.removeAllViews();
    }

    public int getMaxVisibleItemCount() {
        return this.mMaxVisibleItemCount;
    }

    public void setMaxVisibleItemCount(int mMaxVisibleItemCount) {
        this.assertNotInLayoutOrScroll(null);
        if (this.mMaxVisibleItemCount == mMaxVisibleItemCount) {
            return;
        }
        this.mMaxVisibleItemCount = mMaxVisibleItemCount;
        this.removeAllViews();
    }

    public boolean isIntegerDy() {
        return this.mIntegerDy;
    }

    public void setIntegerDy(boolean mIntegerDy) {
        this.mIntegerDy = mIntegerDy;
    }

    private void resolveShouldLayoutReverse() {
        if (this.mOrientation == 0 && this.getLayoutDirection() == 1) {
            this.mReverseLayout = !this.mReverseLayout;
        }
    }

    public boolean getReverseLayout() {
        return this.mReverseLayout;
    }

    public void setReverseLayout(boolean reverseLayout) {
        this.assertNotInLayoutOrScroll(null);
        if (reverseLayout == this.mReverseLayout) {
            return;
        }
        this.mReverseLayout = reverseLayout;
        this.removeAllViews();
    }

    public void smoothScrollToPosition(RecyclerView recyclerView, RecyclerView.State state, int position) {
        LinearSmoothScroller linearSmoothScroller = new LinearSmoothScroller(recyclerView.getContext());
        linearSmoothScroller.setTargetPosition(position);
        this.startSmoothScroll((RecyclerView.SmoothScroller)linearSmoothScroller);
    }

    public PointF computeScrollVectorForPosition(int targetPosition) {
        float direction;
        if (this.getChildCount() == 0) {
            return null;
        }
        int firstChildPos = this.getPosition(this.getChildAt(0));
        float f = direction = targetPosition < firstChildPos == !this.mReverseLayout ? -1.0f / this.getDistanceRatio() : 1.0f / this.getDistanceRatio();
        if (this.mOrientation == 0) {
            return new PointF(direction, 0.0f);
        }
        return new PointF(0.0f, direction);
    }

    public void onLayoutChildren(RecyclerView.Recycler recycler, RecyclerView.State state) {
        if (state.getItemCount() == 0) {
            this.removeAndRecycleAllViews(recycler);
            this.mOffset = 0.0f;
            return;
        }
        this.ensureLayoutState();
        this.resolveShouldLayoutReverse();
        View scrap = recycler.getViewForPosition(0);
        this.measureChildWithMargins(scrap, 0, 0);
        this.mDecoratedMeasurement = this.mOrientationHelper.getDecoratedMeasurement(scrap);
        this.mDecoratedMeasurementInOther = this.mOrientationHelper.getDecoratedMeasurementInOther(scrap);
        this.mSpaceMain = (this.mOrientationHelper.getTotalSpace() - this.mDecoratedMeasurement) / 2;
        this.mSpaceInOther = (this.getTotalSpaceInOther() - this.mDecoratedMeasurementInOther) / 2;
        this.mInterval = this.setInterval();
        this.setUp();
        this.mLeftItems = (int)Math.abs(this.minRemoveOffset() / this.mInterval) + 1;
        this.mRightItems = (int)Math.abs(this.maxRemoveOffset() / this.mInterval) + 1;
        if (this.mPendingSavedState != null) {
            this.mReverseLayout = this.mPendingSavedState.isReverseLayout;
            this.mPendingScrollPosition = this.mPendingSavedState.position;
            this.mOffset = this.mPendingSavedState.offset;
        }
        if (this.mPendingScrollPosition != -1) {
            this.mOffset = this.mReverseLayout ? (float)this.mPendingScrollPosition * -this.mInterval : (float)this.mPendingScrollPosition * this.mInterval;
        }
        this.detachAndScrapAttachedViews(recycler);
        this.layoutItems(recycler);
    }

    public int getTotalSpaceInOther() {
        if (this.mOrientation == 0) {
            return this.getHeight() - this.getPaddingTop() - this.getPaddingBottom();
        }
        return this.getWidth() - this.getPaddingLeft() - this.getPaddingRight();
    }

    public void onLayoutCompleted(RecyclerView.State state) {
        super.onLayoutCompleted(state);
        this.mPendingSavedState = null;
        this.mPendingScrollPosition = -1;
    }

    void ensureLayoutState() {
        if (this.mOrientationHelper == null) {
            this.mOrientationHelper = OrientationHelper.createOrientationHelper((RecyclerView.LayoutManager)this, (int)this.mOrientation);
        }
    }

    protected void setUp() {
    }

    private float getProperty(int position) {
        return this.mReverseLayout ? (float)position * -this.mInterval : (float)position * this.mInterval;
    }

    public void onAdapterChanged(RecyclerView.Adapter oldAdapter, RecyclerView.Adapter newAdapter) {
        this.removeAllViews();
        this.mOffset = 0.0f;
    }

    public void scrollToPosition(int position) {
        this.mPendingScrollPosition = position;
        this.mOffset = this.mReverseLayout ? (float)position * -this.mInterval : (float)position * this.mInterval;
        this.requestLayout();
    }

    public int computeHorizontalScrollOffset(RecyclerView.State state) {
        return this.computeScrollOffset();
    }

    public int computeVerticalScrollOffset(RecyclerView.State state) {
        return this.computeScrollOffset();
    }

    public int computeHorizontalScrollExtent(RecyclerView.State state) {
        return this.computeScrollExtent();
    }

    public int computeVerticalScrollExtent(RecyclerView.State state) {
        return this.computeScrollExtent();
    }

    public int computeHorizontalScrollRange(RecyclerView.State state) {
        return this.computeScrollRange();
    }

    public int computeVerticalScrollRange(RecyclerView.State state) {
        return this.computeScrollRange();
    }

    private int computeScrollOffset() {
        if (this.getChildCount() == 0) {
            return 0;
        }
        if (!this.mSmoothScrollbarEnabled) {
            return !this.mReverseLayout ? this.getCurrentPosition() : this.getItemCount() - this.getCurrentPosition() - 1;
        }
        float realOffset = this.getOffsetOfRightAdapterPosition();
        return !this.mReverseLayout ? (int)realOffset : (int)((float)(this.getItemCount() - 1) * this.mInterval + realOffset);
    }

    private int computeScrollExtent() {
        if (this.getChildCount() == 0) {
            return 0;
        }
        if (!this.mSmoothScrollbarEnabled) {
            return 1;
        }
        return (int)this.mInterval;
    }

    private int computeScrollRange() {
        if (this.getChildCount() == 0) {
            return 0;
        }
        if (!this.mSmoothScrollbarEnabled) {
            return this.getItemCount();
        }
        return (int)((float)this.getItemCount() * this.mInterval);
    }

    public int scrollHorizontallyBy(int dx, RecyclerView.Recycler recycler, RecyclerView.State state) {
        if (this.mOrientation == 1) {
            return 0;
        }
        return this.scrollBy(dx, recycler, state);
    }

    public int scrollVerticallyBy(int dy, RecyclerView.Recycler recycler, RecyclerView.State state) {
        if (this.mOrientation == 0) {
            return 0;
        }
        return this.scrollBy(dy, recycler, state);
    }

    private int scrollBy(int dy, RecyclerView.Recycler recycler, RecyclerView.State state) {
        if (this.getChildCount() == 0 || dy == 0) {
            return 0;
        }
        this.ensureLayoutState();
        int willScroll = dy;
        float realDx = (float)dy / this.getDistanceRatio();
        if (Math.abs(realDx) < 1.0E-8f) {
            return 0;
        }
        float targetOffset = this.mOffset + realDx;
        if (!this.mInfinite && targetOffset < this.getMinOffset()) {
            willScroll = (int)((float)willScroll - (targetOffset - this.getMinOffset()) * this.getDistanceRatio());
        } else if (!this.mInfinite && targetOffset > this.getMaxOffset()) {
            willScroll = (int)((this.getMaxOffset() - this.mOffset) * this.getDistanceRatio());
        }
        realDx = this.mIntegerDy ? (float)((int)((float)willScroll / this.getDistanceRatio())) : (float)willScroll / this.getDistanceRatio();
        this.mOffset += realDx;
        for (int i = 0; i < this.getChildCount(); ++i) {
            View scrap = this.getChildAt(i);
            float delta = this.propertyChangeWhenScroll(scrap) - realDx;
            this.layoutScrap(scrap, delta);
        }
        this.layoutItems(recycler);
        return willScroll;
    }

    private void layoutItems(RecyclerView.Recycler recycler) {
        this.detachAndScrapAttachedViews(recycler);
        int currentPos = this.mReverseLayout ? -this.getCurrentPositionOffset() : this.getCurrentPositionOffset();
        int start = currentPos - this.mLeftItems;
        int end = currentPos + this.mRightItems;
        if (this.useMaxVisibleCount()) {
            int offset;
            boolean isEven;
            boolean bl = isEven = this.mMaxVisibleItemCount % 2 == 0;
            if (isEven) {
                offset = this.mMaxVisibleItemCount / 2;
                start = currentPos - offset + 1;
                end = currentPos + offset + 1;
            } else {
                offset = (this.mMaxVisibleItemCount - 1) / 2;
                start = currentPos - offset;
                end = currentPos + offset + 1;
            }
        }
        int itemCount = this.getItemCount();
        if (!this.mInfinite) {
            if (start < 0) {
                start = 0;
                if (this.useMaxVisibleCount()) {
                    end = this.mMaxVisibleItemCount;
                }
            }
            if (end > itemCount) {
                end = itemCount;
            }
        }
        float lastOrderWeight = Float.MIN_VALUE;
        for (int i = start; i < end; ++i) {
            float orderWeight;
            if (!this.useMaxVisibleCount() && this.removeCondition(this.getProperty(i) - this.mOffset)) continue;
            int adapterPosition = i;
            if (i >= itemCount) {
                adapterPosition %= itemCount;
            } else if (i < 0) {
                int delta = -adapterPosition % itemCount;
                if (delta == 0) {
                    delta = itemCount;
                }
                adapterPosition = itemCount - delta;
            }
            View scrap = recycler.getViewForPosition(adapterPosition);
            this.measureChildWithMargins(scrap, 0, 0);
            this.resetViewProperty(scrap);
            float targetOffset = this.getProperty(i) - this.mOffset;
            this.layoutScrap(scrap, targetOffset);
            float f = orderWeight = this.mEnableBringCenterToFront ? this.setViewElevation(scrap, targetOffset) : (float)adapterPosition;
            if (orderWeight > lastOrderWeight) {
                this.addView(scrap);
            } else {
                this.addView(scrap, 0);
            }
            lastOrderWeight = orderWeight;
        }
    }

    private boolean useMaxVisibleCount() {
        return this.mMaxVisibleItemCount != -1;
    }

    private boolean removeCondition(float targetOffset) {
        return targetOffset > this.maxRemoveOffset() || targetOffset < this.minRemoveOffset();
    }

    private void resetViewProperty(View v) {
        v.setRotation(0.0f);
        v.setRotationY(0.0f);
        v.setRotationX(0.0f);
        v.setScaleX(1.0f);
        v.setScaleY(1.0f);
        v.setAlpha(1.0f);
    }

    private float getMaxOffset() {
        return !this.mReverseLayout ? (float)(this.getItemCount() - 1) * this.mInterval : 0.0f;
    }

    private float getMinOffset() {
        return !this.mReverseLayout ? 0.0f : (float)(-(this.getItemCount() - 1)) * this.mInterval;
    }

    private void layoutScrap(View scrap, float targetOffset) {
        int left = this.calItemLeft(scrap, targetOffset);
        int top = this.calItemTop(scrap, targetOffset);
        if (this.mOrientation == 1) {
            this.layoutDecorated(scrap, this.mSpaceInOther + left, this.mSpaceMain + top, this.mSpaceInOther + left + this.mDecoratedMeasurementInOther, this.mSpaceMain + top + this.mDecoratedMeasurement);
        } else {
            this.layoutDecorated(scrap, this.mSpaceMain + left, this.mSpaceInOther + top, this.mSpaceMain + left + this.mDecoratedMeasurement, this.mSpaceInOther + top + this.mDecoratedMeasurementInOther);
        }
        this.setItemViewProperty(scrap, targetOffset);
    }

    protected int calItemLeft(View itemView, float targetOffset) {
        return this.mOrientation == 1 ? 0 : (int)targetOffset;
    }

    protected int calItemTop(View itemView, float targetOffset) {
        return this.mOrientation == 1 ? (int)targetOffset : 0;
    }

    protected float maxRemoveOffset() {
        return this.mOrientationHelper.getTotalSpace() - this.mSpaceMain;
    }

    protected float minRemoveOffset() {
        return -this.mDecoratedMeasurement - this.mOrientationHelper.getStartAfterPadding() - this.mSpaceMain;
    }

    protected float propertyChangeWhenScroll(View itemView) {
        if (this.mOrientation == 1) {
            return itemView.getTop() - this.mSpaceMain;
        }
        return itemView.getLeft() - this.mSpaceMain;
    }

    protected float getDistanceRatio() {
        return 1.0f;
    }

    public int getCurrentPosition() {
        int position = this.getCurrentPositionOffset();
        if (!this.mInfinite) {
            return Math.abs(position);
        }
        position = !this.mReverseLayout ? (position >= 0 ? position % this.getItemCount() : this.getItemCount() + position % this.getItemCount()) : (position > 0 ? this.getItemCount() - position % this.getItemCount() : -position % this.getItemCount());
        return position;
    }

    private int getCurrentPositionOffset() {
        return Math.round(this.mOffset / this.mInterval);
    }

    private float getOffsetOfRightAdapterPosition() {
        if (this.mReverseLayout) {
            return this.mInfinite ? (this.mOffset <= 0.0f ? this.mOffset % (this.mInterval * (float)this.getItemCount()) : (float)this.getItemCount() * -this.mInterval + this.mOffset % (this.mInterval * (float)this.getItemCount())) : this.mOffset;
        }
        return this.mInfinite ? (this.mOffset >= 0.0f ? this.mOffset % (this.mInterval * (float)this.getItemCount()) : (float)this.getItemCount() * this.mInterval + this.mOffset % (this.mInterval * (float)this.getItemCount())) : this.mOffset;
    }

    public int getOffsetToCenter() {
        if (this.mInfinite) {
            return (int)(((float)this.getCurrentPositionOffset() * this.mInterval - this.mOffset) * this.getDistanceRatio());
        }
        return (int)(((float)this.getCurrentPosition() * (!this.mReverseLayout ? this.mInterval : -this.mInterval) - this.mOffset) * this.getDistanceRatio());
    }

    public void setOnPageChangeListener(OnPageChangeListener onPageChangeListener) {
        this.onPageChangeListener = onPageChangeListener;
    }

    public void setInfinite(boolean enable) {
        this.assertNotInLayoutOrScroll(null);
        if (enable == this.mInfinite) {
            return;
        }
        this.mInfinite = enable;
        this.requestLayout();
    }

    public boolean getInfinite() {
        return this.mInfinite;
    }

    public void setSmoothScrollbarEnabled(boolean enabled) {
        this.mSmoothScrollbarEnabled = enabled;
    }

    public void setEnableBringCenterToFront(boolean bringCenterToTop) {
        this.assertNotInLayoutOrScroll(null);
        if (this.mEnableBringCenterToFront == bringCenterToTop) {
            return;
        }
        this.mEnableBringCenterToFront = bringCenterToTop;
        this.requestLayout();
    }

    public boolean getEnableBringCenterToFront() {
        return this.mEnableBringCenterToFront;
    }

    public boolean getSmoothScrollbarEnabled() {
        return this.mSmoothScrollbarEnabled;
    }

    public static interface OnPageChangeListener {
        public void onPageSelected(int var1);

        public void onPageScrollStateChanged(int var1);
    }

    private static class SavedState
    implements Parcelable {
        int position;
        float offset;
        boolean isReverseLayout;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState() {
        }

        SavedState(Parcel in) {
            this.position = in.readInt();
            this.offset = in.readFloat();
            this.isReverseLayout = in.readInt() == 1;
        }

        public SavedState(SavedState other) {
            this.position = other.position;
            this.offset = other.offset;
            this.isReverseLayout = other.isReverseLayout;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.position);
            dest.writeFloat(this.offset);
            dest.writeInt(this.isReverseLayout ? 1 : 0);
        }
    }
}

