/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.banner.recycler;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.LayerDrawable;
import android.os.Handler;
import android.os.Message;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.xuexiang.xui.R;
import com.xuexiang.xui.utils.ResUtils;
import com.xuexiang.xui.widget.banner.recycler.layout.BannerLayoutManager;
import com.xuexiang.xui.widget.banner.recycler.layout.CenterSnapHelper;

public class BannerLayout
extends FrameLayout {
    private static final int WHAT_AUTO_PLAY = 1000;
    private RecyclerView mIndicatorContainer;
    private IndicatorAdapter mIndicatorAdapter;
    private int mIndicatorMargin;
    private Drawable mSelectedDrawable;
    private Drawable mUnselectedDrawable;
    private RecyclerView mRecyclerView;
    private BannerLayoutManager mLayoutManager;
    private boolean mHasInit;
    private int mBannerSize = 1;
    private int mCurrentIndex;
    private boolean mIsPlaying = false;
    private boolean mIsAutoPlaying = true;
    private int mAutoPlayDuration;
    private boolean mShowIndicator;
    private int mItemSpace;
    private float mCenterScale;
    private float mMoveSpeed;
    private OnIndicatorIndexChangedListener mOnIndicatorIndexChangedListener;
    protected Handler mHandler = new Handler(new Handler.Callback(){

        public boolean handleMessage(Message msg) {
            if (msg.what == 1000 && BannerLayout.this.mCurrentIndex == BannerLayout.this.mLayoutManager.getCurrentPosition()) {
                ++BannerLayout.this.mCurrentIndex;
                BannerLayout.this.mRecyclerView.smoothScrollToPosition(BannerLayout.this.mCurrentIndex);
                BannerLayout.this.mHandler.sendEmptyMessageDelayed(1000, (long)BannerLayout.this.mAutoPlayDuration);
                BannerLayout.this.refreshIndicator();
            }
            return false;
        }
    });

    public BannerLayout(Context context) {
        this(context, null);
    }

    public BannerLayout(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.BannerLayoutStyle);
    }

    public BannerLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView(context, attrs, defStyleAttr);
    }

    protected void initView(Context context, AttributeSet attrs, int defStyleAttr) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.BannerLayout, defStyleAttr, 0);
        this.mShowIndicator = typedArray.getBoolean(R.styleable.BannerLayout_bl_showIndicator, true);
        this.mAutoPlayDuration = typedArray.getInt(R.styleable.BannerLayout_bl_interval, 4000);
        this.mIsAutoPlaying = typedArray.getBoolean(R.styleable.BannerLayout_bl_autoPlaying, true);
        this.mItemSpace = typedArray.getDimensionPixelSize(R.styleable.BannerLayout_bl_itemSpace, ResUtils.getDimensionPixelSize(R.dimen.default_recycler_banner_itemSpace));
        this.mCenterScale = typedArray.getFloat(R.styleable.BannerLayout_bl_centerScale, 1.2f);
        this.mMoveSpeed = typedArray.getFloat(R.styleable.BannerLayout_bl_moveSpeed, 1.0f);
        this.mSelectedDrawable = ResUtils.getDrawableAttrRes(this.getContext(), typedArray, R.styleable.BannerLayout_bl_indicatorSelectedSrc);
        this.mUnselectedDrawable = ResUtils.getDrawableAttrRes(this.getContext(), typedArray, R.styleable.BannerLayout_bl_indicatorUnselectedSrc);
        int indicatorSize = typedArray.getDimensionPixelSize(R.styleable.BannerLayout_bl_indicatorSize, ResUtils.getDimensionPixelSize(R.dimen.default_recycler_banner_indicatorSize));
        int indicatorSelectedColor = typedArray.getColor(R.styleable.BannerLayout_bl_indicatorSelectedColor, ResUtils.getColor(R.color.xui_config_color_red));
        int indicatorUnselectedColor = typedArray.getColor(R.styleable.BannerLayout_bl_indicatorUnselectedColor, ResUtils.getColor(R.color.xui_config_color_gray_2));
        if (this.mSelectedDrawable == null) {
            GradientDrawable selectedGradientDrawable = new GradientDrawable();
            selectedGradientDrawable.setShape(1);
            selectedGradientDrawable.setColor(indicatorSelectedColor);
            selectedGradientDrawable.setSize(indicatorSize, indicatorSize);
            selectedGradientDrawable.setCornerRadius((float)(indicatorSize >> 1));
            this.mSelectedDrawable = new LayerDrawable(new Drawable[]{selectedGradientDrawable});
        }
        if (this.mUnselectedDrawable == null) {
            GradientDrawable unSelectedGradientDrawable = new GradientDrawable();
            unSelectedGradientDrawable.setShape(1);
            unSelectedGradientDrawable.setColor(indicatorUnselectedColor);
            unSelectedGradientDrawable.setSize(indicatorSize, indicatorSize);
            unSelectedGradientDrawable.setCornerRadius((float)(indicatorSize >> 1));
            this.mUnselectedDrawable = new LayerDrawable(new Drawable[]{unSelectedGradientDrawable});
        }
        this.mIndicatorMargin = typedArray.getDimensionPixelSize(R.styleable.BannerLayout_bl_indicatorSpace, ResUtils.getDimensionPixelSize(R.dimen.default_recycler_banner_indicatorSpace));
        int marginLeft = typedArray.getDimensionPixelSize(R.styleable.BannerLayout_bl_indicatorMarginLeft, ResUtils.getDimensionPixelSize(R.dimen.default_recycler_banner_indicatorMarginLeft));
        int marginRight = typedArray.getDimensionPixelSize(R.styleable.BannerLayout_bl_indicatorMarginRight, ResUtils.getDimensionPixelSize(R.dimen.default_recycler_banner_indicatorMarginRight));
        int marginBottom = typedArray.getDimensionPixelSize(R.styleable.BannerLayout_bl_indicatorMarginBottom, ResUtils.getDimensionPixelSize(R.dimen.default_recycler_banner_indicatorMarginBottom));
        int g = typedArray.getInt(R.styleable.BannerLayout_bl_indicatorGravity, 0);
        int gravity = g == 0 ? 0x800003 : (g == 2 ? 0x800005 : 17);
        int orientation = typedArray.getInt(R.styleable.BannerLayout_bl_orientation, 0);
        typedArray.recycle();
        this.mRecyclerView = new RecyclerView(context);
        FrameLayout.LayoutParams vpLayoutParams = new FrameLayout.LayoutParams(-1, -1);
        this.addView((View)this.mRecyclerView, (ViewGroup.LayoutParams)vpLayoutParams);
        this.mLayoutManager = new BannerLayoutManager(this.getContext(), orientation);
        this.mLayoutManager.setItemSpace(this.mItemSpace);
        this.mLayoutManager.setCenterScale(this.mCenterScale);
        this.mLayoutManager.setMoveSpeed(this.mMoveSpeed);
        this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)this.mLayoutManager);
        new CenterSnapHelper().attachToRecyclerView(this.mRecyclerView);
        this.mIndicatorContainer = new RecyclerView(context);
        LinearLayoutManager indicatorLayoutManager = new LinearLayoutManager(context, orientation, false);
        this.mIndicatorContainer.setLayoutManager((RecyclerView.LayoutManager)indicatorLayoutManager);
        this.mIndicatorAdapter = new IndicatorAdapter();
        this.mIndicatorContainer.setAdapter((RecyclerView.Adapter)this.mIndicatorAdapter);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-2, -2);
        params.gravity = 0x50 | gravity;
        params.setMargins(marginLeft, 0, marginRight, marginBottom);
        this.addView((View)this.mIndicatorContainer, (ViewGroup.LayoutParams)params);
        if (!this.mShowIndicator) {
            this.mIndicatorContainer.setVisibility(8);
        }
    }

    public BannerLayout setAutoPlaying(boolean isAutoPlaying) {
        this.mIsAutoPlaying = isAutoPlaying;
        this.setPlaying(this.mIsAutoPlaying);
        return this;
    }

    public boolean isPlaying() {
        return this.mIsPlaying;
    }

    public BannerLayout setShowIndicator(boolean showIndicator) {
        this.mShowIndicator = showIndicator;
        this.mIndicatorContainer.setVisibility(showIndicator ? 0 : 8);
        return this;
    }

    public BannerLayout setCenterScale(float centerScale) {
        this.mCenterScale = centerScale;
        this.mLayoutManager.setCenterScale(centerScale);
        return this;
    }

    public BannerLayout setMoveSpeed(float moveSpeed) {
        this.mMoveSpeed = moveSpeed;
        this.mLayoutManager.setMoveSpeed(moveSpeed);
        return this;
    }

    public BannerLayout setItemSpace(int itemSpace) {
        this.mItemSpace = itemSpace;
        this.mLayoutManager.setItemSpace(itemSpace);
        return this;
    }

    public BannerLayout setAutoPlayDuration(int autoPlayDuration) {
        this.mAutoPlayDuration = autoPlayDuration;
        return this;
    }

    public BannerLayout setOrientation(int orientation) {
        this.mLayoutManager.setOrientation(orientation);
        return this;
    }

    protected synchronized void setPlaying(boolean playing) {
        if (this.mIsAutoPlaying && this.mHasInit) {
            if (!this.mIsPlaying && playing) {
                this.mHandler.sendEmptyMessageDelayed(1000, (long)this.mAutoPlayDuration);
                this.mIsPlaying = true;
            } else if (this.mIsPlaying && !playing) {
                this.mHandler.removeMessages(1000);
                this.mIsPlaying = false;
            }
        }
    }

    public void setAdapter(RecyclerView.Adapter adapter) {
        this.mHasInit = false;
        this.mRecyclerView.setAdapter(adapter);
        this.mBannerSize = adapter.getItemCount();
        this.mLayoutManager.setInfinite(this.mBannerSize >= 3);
        this.setPlaying(true);
        this.mRecyclerView.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                if (dx != 0) {
                    BannerLayout.this.setPlaying(false);
                }
            }

            public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
                int first = BannerLayout.this.mLayoutManager.getCurrentPosition();
                if (BannerLayout.this.mCurrentIndex != first) {
                    BannerLayout.this.mCurrentIndex = first;
                }
                if (newState == 0) {
                    BannerLayout.this.setPlaying(true);
                }
                BannerLayout.this.refreshIndicator();
            }
        });
        this.mHasInit = true;
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        switch (ev.getAction()) {
            case 0: {
                this.setPlaying(false);
                break;
            }
            case 1: 
            case 3: {
                this.setPlaying(true);
            }
        }
        return super.dispatchTouchEvent(ev);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.setPlaying(true);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.setPlaying(false);
    }

    protected void onWindowVisibilityChanged(int visibility) {
        super.onWindowVisibilityChanged(visibility);
        if (visibility == 0) {
            this.setPlaying(true);
        } else {
            this.setPlaying(false);
        }
    }

    protected synchronized void refreshIndicator() {
        if (this.mBannerSize > 1) {
            int position = this.mCurrentIndex % this.mBannerSize;
            if (this.mShowIndicator) {
                this.mIndicatorAdapter.setPosition(position);
                this.mIndicatorAdapter.notifyDataSetChanged();
            }
            if (this.mOnIndicatorIndexChangedListener != null) {
                this.mOnIndicatorIndexChangedListener.onIndexChanged(position);
            }
        }
    }

    public BannerLayout setOnIndicatorIndexChangedListener(OnIndicatorIndexChangedListener onIndicatorIndexChangedListener) {
        this.mOnIndicatorIndexChangedListener = onIndicatorIndexChangedListener;
        return this;
    }

    public static interface OnIndicatorIndexChangedListener {
        public void onIndexChanged(int var1);
    }

    public static interface OnBannerItemClickListener {
        public void onItemClick(int var1);
    }

    protected class IndicatorAdapter
    extends RecyclerView.Adapter {
        int currentPosition = 0;

        protected IndicatorAdapter() {
        }

        public void setPosition(int currentPosition) {
            this.currentPosition = currentPosition;
        }

        public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
            ImageView bannerPoint = new ImageView(BannerLayout.this.getContext());
            RecyclerView.LayoutParams lp = new RecyclerView.LayoutParams(-2, -2);
            lp.setMargins(BannerLayout.this.mIndicatorMargin, BannerLayout.this.mIndicatorMargin, BannerLayout.this.mIndicatorMargin, BannerLayout.this.mIndicatorMargin);
            bannerPoint.setLayoutParams((ViewGroup.LayoutParams)lp);
            return new RecyclerView.ViewHolder((View)bannerPoint){};
        }

        public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
            ImageView bannerPoint = (ImageView)holder.itemView;
            bannerPoint.setImageDrawable(this.currentPosition == position ? BannerLayout.this.mSelectedDrawable : BannerLayout.this.mUnselectedDrawable);
        }

        public int getItemCount() {
            return BannerLayout.this.mBannerSize;
        }
    }
}

