/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ScrollView;
import com.xuexiang.xui.R;
import com.xuexiang.xui.utils.DensityUtils;
import com.xuexiang.xui.utils.KeyboardUtils;

public class XUIKeyboardScrollView
extends ScrollView
implements KeyboardUtils.SoftKeyboardToggleListener {
    private static final int DEFAULT_SCROLL_HEIGHT = 40;
    private boolean mAutoScroll;
    private int mScrollHeight;
    private int mScrollDelay;
    private boolean mScrollHide;

    public XUIKeyboardScrollView(Context context) {
        super(context);
        this.mScrollHide = true;
    }

    public XUIKeyboardScrollView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initAttrs(context, attrs);
    }

    public XUIKeyboardScrollView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initAttrs(context, attrs);
    }

    private void initAttrs(Context context, AttributeSet attrs) {
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.XUIKeyboardScrollView);
        if (ta != null) {
            this.mAutoScroll = ta.getBoolean(R.styleable.XUIKeyboardScrollView_ksv_auto_scroll, false);
            this.mScrollHeight = ta.getDimensionPixelSize(R.styleable.XUIKeyboardScrollView_ksv_scroll_height, DensityUtils.dp2px(this.getContext(), 40.0f));
            this.mScrollDelay = ta.getInt(R.styleable.XUIKeyboardScrollView_ksv_scroll_delay, 100);
            this.mScrollHide = ta.getBoolean(R.styleable.XUIKeyboardScrollView_ksv_scroll_hide, true);
            ta.recycle();
        }
        if (this.mAutoScroll) {
            KeyboardUtils.addKeyboardToggleListener((ViewGroup)this, (KeyboardUtils.SoftKeyboardToggleListener)this);
        }
    }

    @Override
    public void onToggleSoftKeyboard(boolean isVisible) {
        if (isVisible) {
            this.postDelayed(new Runnable(){

                @Override
                public void run() {
                    XUIKeyboardScrollView.this.smoothScrollTo(0, XUIKeyboardScrollView.this.getScrollY() + XUIKeyboardScrollView.this.mScrollHeight);
                }
            }, this.mScrollDelay);
        } else {
            this.postDelayed(new Runnable(){

                @Override
                public void run() {
                    XUIKeyboardScrollView.this.smoothScrollTo(0, 0);
                }
            }, this.mScrollDelay);
        }
    }

    protected void onDetachedFromWindow() {
        if (this.mAutoScroll) {
            KeyboardUtils.removeKeyboardToggleListener(this);
        }
        super.onDetachedFromWindow();
    }

    protected void onScrollChanged(int l, int t, int oldl, int oldt) {
        super.onScrollChanged(l, t, oldl, oldt);
        if (this.mScrollHide) {
            KeyboardUtils.hideSoftInput((View)this);
        }
    }

    public XUIKeyboardScrollView setIsScrollHideKeyboard(boolean isScrollHideKeyboard) {
        this.mScrollHide = isScrollHideKeyboard;
        return this;
    }
}

