/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.utils;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.support.design.widget.BaseTransientBottomBar;
import android.support.design.widget.CoordinatorLayout;
import android.support.design.widget.Snackbar;
import android.support.design.widget.SnackbarContentLayout;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.Space;
import android.widget.TextView;
import com.xuexiang.xui.R;
import com.xuexiang.xui.logs.UILog;
import com.xuexiang.xui.utils.DensityUtils;
import com.xuexiang.xui.utils.Utils;
import java.lang.ref.WeakReference;

public class SnackbarUtils {
    private static final String TAG = "SnackbarUtils";
    private static int sColorInfo = -14049565;
    private static int sColorConfirm = -11751346;
    private static int sColorWarning = -81915;
    private static int sColorDanger = -769226;
    private static WeakReference<Snackbar> mSnackbarWeakRef;

    private SnackbarUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    private SnackbarUtils(@Nullable WeakReference<Snackbar> snackbarWeakReference) {
        mSnackbarWeakRef = snackbarWeakReference;
    }

    public static void setColorInfo(int colorInfo) {
        sColorInfo = colorInfo;
    }

    public static void setColorConfirm(int colorConfirm) {
        sColorConfirm = colorConfirm;
    }

    public static void setColorWarning(int colorWarning) {
        sColorWarning = colorWarning;
    }

    public static void setColorDanger(int colorDanger) {
        sColorDanger = colorDanger;
    }

    public Snackbar getSnackbar() {
        if (mSnackbarWeakRef != null && mSnackbarWeakRef.get() != null) {
            return (Snackbar)mSnackbarWeakRef.get();
        }
        return null;
    }

    public static SnackbarUtils Short(View view, String message) {
        return new SnackbarUtils(new WeakReference<Snackbar>(Snackbar.make((View)view, (CharSequence)message, (int)-1))).backColor(-13487566);
    }

    public static SnackbarUtils Long(View view, String message) {
        return new SnackbarUtils(new WeakReference<Snackbar>(Snackbar.make((View)view, (CharSequence)message, (int)0))).backColor(-13487566);
    }

    public static SnackbarUtils Indefinite(View view, String message) {
        return new SnackbarUtils(new WeakReference<Snackbar>(Snackbar.make((View)view, (CharSequence)message, (int)-2))).backColor(-13487566);
    }

    public static SnackbarUtils Custom(View view, String message, int duration) {
        return new SnackbarUtils(new WeakReference<BaseTransientBottomBar>(Snackbar.make((View)view, (CharSequence)message, (int)-1).setDuration(duration))).backColor(-13487566);
    }

    public SnackbarUtils info() {
        if (this.getSnackbar() != null) {
            this.getSnackbar().getView().setBackgroundColor(sColorInfo);
        }
        return this;
    }

    public SnackbarUtils confirm() {
        if (this.getSnackbar() != null) {
            this.getSnackbar().getView().setBackgroundColor(sColorConfirm);
        }
        return this;
    }

    public SnackbarUtils warning() {
        if (this.getSnackbar() != null) {
            this.getSnackbar().getView().setBackgroundColor(sColorWarning);
        }
        return this;
    }

    public SnackbarUtils danger() {
        if (this.getSnackbar() != null) {
            this.getSnackbar().getView().setBackgroundColor(sColorDanger);
        }
        return this;
    }

    public SnackbarUtils backColor(@ColorInt int backgroundColor) {
        if (this.getSnackbar() != null) {
            this.getSnackbar().getView().setBackgroundColor(backgroundColor);
        }
        return this;
    }

    public SnackbarUtils messageColor(@ColorInt int messageColor) {
        if (this.getSnackbar() != null) {
            ((TextView)this.getSnackbar().getView().findViewById(R.id.snackbar_text)).setTextColor(messageColor);
        }
        return this;
    }

    public SnackbarUtils actionColor(@ColorInt int actionTextColor) {
        if (this.getSnackbar() != null) {
            ((Button)this.getSnackbar().getView().findViewById(R.id.snackbar_action)).setTextColor(actionTextColor);
        }
        return this;
    }

    public SnackbarUtils colors(@ColorInt int backgroundColor, @ColorInt int messageColor, @ColorInt int actionTextColor) {
        if (this.getSnackbar() != null) {
            this.getSnackbar().getView().setBackgroundColor(backgroundColor);
            ((TextView)this.getSnackbar().getView().findViewById(R.id.snackbar_text)).setTextColor(messageColor);
            ((Button)this.getSnackbar().getView().findViewById(R.id.snackbar_action)).setTextColor(actionTextColor);
        }
        return this;
    }

    public SnackbarUtils alpha(float alpha) {
        if (this.getSnackbar() != null) {
            alpha = alpha >= 1.0f ? 1.0f : (alpha <= 0.0f ? 0.0f : alpha);
            this.getSnackbar().getView().setAlpha(alpha);
        }
        return this;
    }

    public SnackbarUtils gravityFrameLayout(int gravity) {
        if (this.getSnackbar() != null) {
            FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(this.getSnackbar().getView().getLayoutParams().width, this.getSnackbar().getView().getLayoutParams().height);
            params.gravity = gravity;
            this.getSnackbar().getView().setLayoutParams((ViewGroup.LayoutParams)params);
        }
        return this;
    }

    public SnackbarUtils gravityCoordinatorLayout(int gravity) {
        if (this.getSnackbar() != null) {
            CoordinatorLayout.LayoutParams params = new CoordinatorLayout.LayoutParams(this.getSnackbar().getView().getLayoutParams().width, this.getSnackbar().getView().getLayoutParams().height);
            params.gravity = gravity;
            this.getSnackbar().getView().setLayoutParams((ViewGroup.LayoutParams)params);
        }
        return this;
    }

    public SnackbarUtils setAction(@StringRes int resId, View.OnClickListener listener) {
        if (this.getSnackbar() != null) {
            return this.setAction(this.getSnackbar().getView().getResources().getText(resId), listener);
        }
        return this;
    }

    public SnackbarUtils setAction(CharSequence text, View.OnClickListener listener) {
        if (this.getSnackbar() != null) {
            this.getSnackbar().setAction(text, listener);
        }
        return this;
    }

    public SnackbarUtils setCallback(Snackbar.Callback setCallback) {
        if (this.getSnackbar() != null) {
            this.getSnackbar().setCallback(setCallback);
        }
        return this;
    }

    public SnackbarUtils leftAndRightDrawable(@Nullable @DrawableRes Integer leftDrawable, @Nullable @DrawableRes Integer rightDrawable) {
        if (this.getSnackbar() != null) {
            Drawable drawableLeft = null;
            Drawable drawableRight = null;
            if (leftDrawable != null) {
                try {
                    drawableLeft = this.getSnackbar().getView().getResources().getDrawable(leftDrawable.intValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (rightDrawable != null) {
                try {
                    drawableRight = this.getSnackbar().getView().getResources().getDrawable(rightDrawable.intValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return this.leftAndRightDrawable(drawableLeft, drawableRight);
        }
        return this;
    }

    public SnackbarUtils leftAndRightDrawable(@Nullable Drawable leftDrawable, @Nullable Drawable rightDrawable) {
        if (this.getSnackbar() != null) {
            TextView message = (TextView)this.getSnackbar().getView().findViewById(R.id.snackbar_text);
            LinearLayout.LayoutParams paramsMessage = (LinearLayout.LayoutParams)message.getLayoutParams();
            paramsMessage = new LinearLayout.LayoutParams(paramsMessage.width, paramsMessage.height, 0.0f);
            message.setLayoutParams((ViewGroup.LayoutParams)paramsMessage);
            message.setCompoundDrawablePadding(message.getPaddingLeft());
            int textSize = (int)message.getTextSize();
            UILog.dTag(TAG, "textSize:" + textSize);
            if (leftDrawable != null) {
                leftDrawable.setBounds(0, 0, textSize, textSize);
            }
            if (rightDrawable != null) {
                rightDrawable.setBounds(0, 0, textSize, textSize);
            }
            message.setCompoundDrawables(leftDrawable, null, rightDrawable, null);
            LinearLayout.LayoutParams paramsSpace = new LinearLayout.LayoutParams(-2, -2, 1.0f);
            ((Snackbar.SnackbarLayout)this.getSnackbar().getView()).addView((View)new Space(this.getSnackbar().getView().getContext()), 1, (ViewGroup.LayoutParams)paramsSpace);
        }
        return this;
    }

    @TargetApi(value=17)
    public SnackbarUtils messageCenter() {
        if (Build.VERSION.SDK_INT >= 17 && this.getSnackbar() != null) {
            TextView message = (TextView)this.getSnackbar().getView().findViewById(R.id.snackbar_text);
            message.setTextAlignment(1);
            message.setGravity(17);
        }
        return this;
    }

    @TargetApi(value=17)
    public SnackbarUtils messageRight() {
        if (Build.VERSION.SDK_INT >= 17 && this.getSnackbar() != null) {
            TextView message = (TextView)this.getSnackbar().getView().findViewById(R.id.snackbar_text);
            message.setTextAlignment(1);
            message.setGravity(21);
        }
        return this;
    }

    public SnackbarUtils addView(int layoutId, int index) {
        if (this.getSnackbar() != null) {
            View addView = LayoutInflater.from((Context)this.getSnackbar().getView().getContext()).inflate(layoutId, null);
            return this.addView(addView, index);
        }
        return this;
    }

    public SnackbarUtils addView(View addView, int index) {
        if (this.getSnackbar() != null) {
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-2, -2);
            params.gravity = 16;
            addView.setLayoutParams((ViewGroup.LayoutParams)params);
            SnackbarContentLayout contentLayout = (SnackbarContentLayout)((Snackbar.SnackbarLayout)this.getSnackbar().getView()).getChildAt(0);
            contentLayout.addView(addView, index);
        }
        return this;
    }

    public SnackbarUtils margins(int margin) {
        if (this.getSnackbar() != null) {
            return this.margins(margin, margin, margin, margin);
        }
        return this;
    }

    public SnackbarUtils margins(int left, int top, int right, int bottom) {
        if (this.getSnackbar() != null) {
            ViewGroup.LayoutParams params = this.getSnackbar().getView().getLayoutParams();
            ((ViewGroup.MarginLayoutParams)params).setMargins(left, top, right, bottom);
            this.getSnackbar().getView().setLayoutParams(params);
        }
        return this;
    }

    private GradientDrawable getRadiusDrawable(Drawable backgroundOri) {
        GradientDrawable background = null;
        if (backgroundOri instanceof GradientDrawable) {
            background = (GradientDrawable)backgroundOri;
        } else if (backgroundOri instanceof ColorDrawable) {
            int backgroundColor = ((ColorDrawable)backgroundOri).getColor();
            background = new GradientDrawable();
            background.setColor(backgroundColor);
        }
        return background;
    }

    public SnackbarUtils radius(float radius) {
        GradientDrawable background;
        if (this.getSnackbar() != null && (background = this.getRadiusDrawable(this.getSnackbar().getView().getBackground())) != null) {
            radius = radius <= 0.0f ? 12.0f : radius;
            background.setCornerRadius(radius);
            this.getSnackbar().getView().setBackgroundDrawable((Drawable)background);
        }
        return this;
    }

    public SnackbarUtils radius(int radius, int strokeWidth, @ColorInt int strokeColor) {
        GradientDrawable background;
        if (this.getSnackbar() != null && (background = this.getRadiusDrawable(this.getSnackbar().getView().getBackground())) != null) {
            int n = radius = radius <= 0 ? 12 : radius;
            strokeWidth = strokeWidth <= 0 ? 1 : (strokeWidth >= this.getSnackbar().getView().findViewById(R.id.snackbar_text).getPaddingTop() ? 2 : strokeWidth);
            background.setCornerRadius((float)radius);
            background.setStroke(strokeWidth, strokeColor);
            this.getSnackbar().getView().setBackgroundDrawable((Drawable)background);
        }
        return this;
    }

    private int calculateSnackBarHeight() {
        int SnackbarHeight = DensityUtils.dp2px(this.getSnackbar().getView().getContext(), 28.0f) + DensityUtils.sp2px(this.getSnackbar().getView().getContext(), 14.0f);
        UILog.dTag(TAG, "\u76f4\u63a5\u83b7\u53d6MessageView\u9ad8\u5ea6:" + this.getSnackbar().getView().findViewById(R.id.snackbar_text).getHeight());
        return SnackbarHeight;
    }

    public SnackbarUtils above(View targetView, int contentViewTop, int marginLeft, int marginRight) {
        if (this.getSnackbar() != null) {
            marginLeft = marginLeft <= 0 ? 0 : marginLeft;
            marginRight = marginRight <= 0 ? 0 : marginRight;
            int[] locations = new int[2];
            targetView.getLocationOnScreen(locations);
            UILog.dTag(TAG, "\u8ddd\u79bb\u5c4f\u5e55\u5de6\u4fa7:" + locations[0] + "==\u8ddd\u79bb\u5c4f\u5e55\u9876\u90e8:" + locations[1]);
            int snackbarHeight = this.calculateSnackBarHeight();
            UILog.dTag(TAG, "Snackbar\u9ad8\u5ea6:" + snackbarHeight);
            if (locations[1] >= contentViewTop + snackbarHeight) {
                this.gravityFrameLayout(80);
                ViewGroup.LayoutParams params = this.getSnackbar().getView().getLayoutParams();
                ((ViewGroup.MarginLayoutParams)params).setMargins(marginLeft, 0, marginRight, this.getSnackbar().getView().getResources().getDisplayMetrics().heightPixels - locations[1]);
                this.getSnackbar().getView().setLayoutParams(params);
            }
        }
        return this;
    }

    public SnackbarUtils aboveCoordinatorLayout(View targetView, int contentViewTop, int marginLeft, int marginRight) {
        if (this.getSnackbar() != null) {
            marginLeft = marginLeft <= 0 ? 0 : marginLeft;
            marginRight = marginRight <= 0 ? 0 : marginRight;
            int[] locations = new int[2];
            targetView.getLocationOnScreen(locations);
            UILog.dTag(TAG, "\u8ddd\u79bb\u5c4f\u5e55\u5de6\u4fa7:" + locations[0] + "==\u8ddd\u79bb\u5c4f\u5e55\u9876\u90e8:" + locations[1]);
            int snackbarHeight = this.calculateSnackBarHeight();
            UILog.dTag(TAG, "Snackbar\u9ad8\u5ea6:" + snackbarHeight);
            if (locations[1] >= contentViewTop + snackbarHeight) {
                this.gravityCoordinatorLayout(80);
                ViewGroup.LayoutParams params = this.getSnackbar().getView().getLayoutParams();
                ((ViewGroup.MarginLayoutParams)params).setMargins(marginLeft, 0, marginRight, this.getSnackbar().getView().getResources().getDisplayMetrics().heightPixels - locations[1]);
                this.getSnackbar().getView().setLayoutParams(params);
            }
        }
        return this;
    }

    public SnackbarUtils bellow(View targetView, int contentViewTop, int marginLeft, int marginRight) {
        if (this.getSnackbar() != null) {
            marginLeft = marginLeft <= 0 ? 0 : marginLeft;
            marginRight = marginRight <= 0 ? 0 : marginRight;
            int[] locations = new int[2];
            targetView.getLocationOnScreen(locations);
            int snackbarHeight = this.calculateSnackBarHeight();
            int screenHeight = Utils.getScreenHeight(this.getSnackbar().getView().getContext());
            if (Build.VERSION.SDK_INT >= 21) {
                if (locations[1] + targetView.getHeight() >= contentViewTop && locations[1] + targetView.getHeight() + snackbarHeight + 2 <= screenHeight) {
                    this.gravityFrameLayout(80);
                    ViewGroup.LayoutParams params = this.getSnackbar().getView().getLayoutParams();
                    ((ViewGroup.MarginLayoutParams)params).setMargins(marginLeft, 0, marginRight, screenHeight - (locations[1] + targetView.getHeight() + snackbarHeight + 2));
                    this.getSnackbar().getView().setLayoutParams(params);
                }
            } else if (locations[1] + targetView.getHeight() >= contentViewTop && locations[1] + targetView.getHeight() + snackbarHeight <= screenHeight) {
                this.gravityFrameLayout(80);
                ViewGroup.LayoutParams params = this.getSnackbar().getView().getLayoutParams();
                ((ViewGroup.MarginLayoutParams)params).setMargins(marginLeft, 0, marginRight, screenHeight - (locations[1] + targetView.getHeight() + snackbarHeight));
                this.getSnackbar().getView().setLayoutParams(params);
            }
        }
        return this;
    }

    public SnackbarUtils bellowCoordinatorLayout(View targetView, int contentViewTop, int marginLeft, int marginRight) {
        if (this.getSnackbar() != null) {
            marginLeft = marginLeft <= 0 ? 0 : marginLeft;
            marginRight = marginRight <= 0 ? 0 : marginRight;
            int[] locations = new int[2];
            targetView.getLocationOnScreen(locations);
            int snackbarHeight = this.calculateSnackBarHeight();
            int screenHeight = Utils.getScreenHeight(this.getSnackbar().getView().getContext());
            if (Build.VERSION.SDK_INT >= 21) {
                if (locations[1] + targetView.getHeight() >= contentViewTop && locations[1] + targetView.getHeight() + snackbarHeight + 2 <= screenHeight) {
                    this.gravityCoordinatorLayout(80);
                    ViewGroup.LayoutParams params = this.getSnackbar().getView().getLayoutParams();
                    ((ViewGroup.MarginLayoutParams)params).setMargins(marginLeft, 0, marginRight, screenHeight - (locations[1] + targetView.getHeight() + snackbarHeight + 2));
                    this.getSnackbar().getView().setLayoutParams(params);
                }
            } else if (locations[1] + targetView.getHeight() >= contentViewTop && locations[1] + targetView.getHeight() + snackbarHeight <= screenHeight) {
                this.gravityCoordinatorLayout(80);
                ViewGroup.LayoutParams params = this.getSnackbar().getView().getLayoutParams();
                ((ViewGroup.MarginLayoutParams)params).setMargins(marginLeft, 0, marginRight, screenHeight - (locations[1] + targetView.getHeight() + snackbarHeight));
                this.getSnackbar().getView().setLayoutParams(params);
            }
        }
        return this;
    }

    public void show() {
        if (this.getSnackbar() != null) {
            this.getSnackbar().show();
        } else {
            UILog.dTag(TAG, "\u5df2\u7ecf\u88ab\u56de\u6536");
        }
    }
}

