/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.adapter.recyclerview;

import android.content.Context;
import android.support.annotation.ColorRes;
import android.support.annotation.DrawableRes;
import android.support.annotation.IdRes;
import android.support.annotation.StringRes;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.RecyclerView;
import android.text.TextWatcher;
import android.util.SparseArray;
import android.view.View;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.EditText;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.TextView;
import com.xuexiang.xui.widget.imageview.ImageLoader;

public class RecyclerViewHolder
extends RecyclerView.ViewHolder {
    private SparseArray<View> mViews = new SparseArray();

    public RecyclerViewHolder(View itemView) {
        super(itemView);
    }

    public <T extends View> T findViewById(int viewId) {
        View view = (View)this.mViews.get(viewId);
        if (view == null) {
            view = this.itemView.findViewById(viewId);
            this.mViews.put(viewId, (Object)view);
        }
        return (T)view;
    }

    public View getView(int viewId) {
        return this.findViewById(viewId);
    }

    public TextView getTextView(int viewId) {
        return (TextView)this.getView(viewId);
    }

    public Button getButton(int viewId) {
        return (Button)this.getView(viewId);
    }

    public ImageView getImageView(int viewId) {
        return (ImageView)this.getView(viewId);
    }

    public ImageButton getImageButton(int viewId) {
        return (ImageButton)this.getView(viewId);
    }

    public EditText getEditText(int viewId) {
        return (EditText)this.getView(viewId);
    }

    public View findView(@IdRes int id) {
        return id == 0 ? this.itemView : this.findViewById(id);
    }

    public RecyclerViewHolder text(int id, CharSequence sequence) {
        View view = this.findView(id);
        if (view instanceof TextView) {
            ((TextView)view).setText(sequence);
        }
        return this;
    }

    public RecyclerViewHolder text(@IdRes int id, @StringRes int stringRes) {
        View view = this.findView(id);
        if (view instanceof TextView) {
            ((TextView)view).setText(stringRes);
        }
        return this;
    }

    public RecyclerViewHolder textColorId(@IdRes int id, @ColorRes int colorId) {
        View view = this.findView(id);
        if (view instanceof TextView) {
            ((TextView)view).setTextColor(ContextCompat.getColor((Context)view.getContext(), (int)colorId));
        }
        return this;
    }

    public RecyclerViewHolder image(@IdRes int id, @DrawableRes int imageId) {
        View view = this.findView(id);
        if (view instanceof ImageView) {
            ((ImageView)view).setImageResource(imageId);
        }
        return this;
    }

    public RecyclerViewHolder image(@IdRes int id, Object uri) {
        View view = this.findView(id);
        if (view instanceof ImageView) {
            ImageLoader.get().loadImage((ImageView)view, uri);
        }
        return this;
    }

    public <T> RecyclerViewHolder viewClick(@IdRes int id, final OnViewItemClickListener<T> listener, final T item, final int position) {
        View view = this.findView(id);
        if (listener != null) {
            view.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    listener.onViewItemClick(v, item, position);
                }
            });
        }
        return this;
    }

    public RecyclerViewHolder click(@IdRes int id, View.OnClickListener listener) {
        View view = this.findView(id);
        if (listener != null) {
            view.setOnClickListener(listener);
        }
        return this;
    }

    public RecyclerViewHolder visible(@IdRes int id, int visibility) {
        View view = this.findView(id);
        view.setVisibility(visibility);
        return this;
    }

    public RecyclerViewHolder enable(@IdRes int id, boolean enable) {
        View view = this.findView(id);
        view.setEnabled(enable);
        if (view instanceof EditText) {
            view.setFocusable(enable);
            view.setFocusableInTouchMode(enable);
        }
        return this;
    }

    public RecyclerViewHolder checked(@IdRes int id, boolean checked) {
        View view = this.findView(id);
        if (view instanceof CompoundButton) {
            ((CheckBox)view).setChecked(checked);
        }
        return this;
    }

    public RecyclerViewHolder checkedListener(@IdRes int id, CompoundButton.OnCheckedChangeListener listener) {
        View view = this.findView(id);
        if (view instanceof CompoundButton) {
            ((CheckBox)view).setOnCheckedChangeListener(listener);
        }
        return this;
    }

    public RecyclerViewHolder textListener(@IdRes int id, TextWatcher watcher) {
        View view = this.findView(id);
        if (view instanceof TextView) {
            ((TextView)view).addTextChangedListener(watcher);
        }
        return this;
    }

    public RecyclerViewHolder backgroundResId(int viewId, @DrawableRes int resId) {
        View view = this.findView(viewId);
        view.setBackgroundResource(resId);
        return this;
    }

    public void clearViews() {
        if (this.mViews != null) {
            this.mViews.clear();
        }
    }

    public static interface OnViewItemClickListener<T> {
        public void onViewItemClick(View var1, T var2, int var3);
    }

    public static interface OnItemLongClickListener<T> {
        public void onItemLongClick(View var1, T var2, int var3);
    }

    public static interface OnItemClickListener<T> {
        public void onItemClick(View var1, T var2, int var3);
    }
}

