/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xtask.thread.utils;

import com.xuexiang.xtask.thread.priority.IPriority;
import com.xuexiang.xtask.thread.priority.IPriorityStrategy;
import com.xuexiang.xtask.thread.priority.impl.DefaultPriorityStrategy;
import java.util.concurrent.atomic.AtomicLong;

public final class PriorityUtils {
    private static final AtomicLong SEQ = new AtomicLong(0L);
    private static IPriorityStrategy sPriorityStrategy = new DefaultPriorityStrategy();

    private PriorityUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static long generateId() {
        return SEQ.getAndIncrement();
    }

    public static void setPriorityStrategy(IPriorityStrategy sPriorityStrategy) {
        PriorityUtils.sPriorityStrategy = sPriorityStrategy;
    }

    public static int compare(IPriority priority, IPriority other) {
        if (sPriorityStrategy == null) {
            sPriorityStrategy = new DefaultPriorityStrategy();
        }
        return sPriorityStrategy.compare(priority, other);
    }

    public static String formatStackTrace(StackTraceElement[] stackTrace) {
        StringBuilder sb = new StringBuilder();
        for (StackTraceElement element : stackTrace) {
            sb.append("    at ").append(element.toString());
            sb.append("\n");
        }
        return sb.toString();
    }
}

