/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xtask.thread.utils;

import android.os.Looper;
import java.util.Collection;
import java.util.concurrent.ExecutorService;

public final class ExecutorUtils {
    private ExecutorUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static void shutdown(ExecutorService executor) {
        if (executor != null && !executor.isShutdown()) {
            executor.shutdown();
        }
    }

    public static void shutdown(Collection<? extends ExecutorService> executors) {
        if (executors == null || executors.isEmpty()) {
            return;
        }
        for (ExecutorService executorService : executors) {
            ExecutorUtils.shutdown(executorService);
        }
    }

    public static boolean isMainThread() {
        return Looper.getMainLooper() == Looper.myLooper();
    }
}

