/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xtask.thread.priority.impl;

import com.xuexiang.xtask.thread.priority.IPriority;
import com.xuexiang.xtask.thread.priority.IPriorityFuture;
import com.xuexiang.xtask.thread.utils.PriorityUtils;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;

public class DefaultPriorityFuture<V>
extends FutureTask<V>
implements IPriorityFuture<V> {
    private IPriority mPriority;

    public DefaultPriorityFuture(Callable<V> callable) {
        super(callable);
        if (callable instanceof IPriority) {
            this.mPriority = (IPriority)((Object)callable);
        }
        this.setId(PriorityUtils.generateId());
    }

    public DefaultPriorityFuture(Runnable runnable, V result) {
        super(runnable, result);
        if (runnable instanceof IPriority) {
            this.mPriority = (IPriority)((Object)runnable);
        }
        this.setId(PriorityUtils.generateId());
    }

    @Override
    public void priority(int priority) {
        if (this.mPriority != null) {
            this.mPriority.priority(priority);
        }
    }

    @Override
    public long getId() {
        return this.mPriority != null ? this.mPriority.getId() : 0L;
    }

    @Override
    public void setId(long id) {
        if (this.mPriority != null) {
            this.mPriority.setId(id);
        }
    }

    @Override
    public int priority() {
        return this.mPriority != null ? this.mPriority.priority() : 0;
    }

    @Override
    public int compareTo(IPriority other) {
        return PriorityUtils.compare(this, other);
    }

    @Override
    public String toString() {
        return "DefaultPriorityFuture{, mPriority=" + this.mPriority + '}';
    }

    @Override
    public void cancel() {
        this.cancel(true);
    }
}

