/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xtask.thread.priority.impl;

import com.xuexiang.xtask.thread.priority.IPriority;
import com.xuexiang.xtask.thread.priority.IPriorityCallable;
import com.xuexiang.xtask.thread.utils.PriorityUtils;
import java.util.concurrent.Callable;

public class DefaultPriorityCallable<V>
implements IPriorityCallable<V> {
    private IPriority mPriority;
    private Callable<V> mCallable;

    public DefaultPriorityCallable(IPriority priority, Callable<V> callable) {
        this.mPriority = priority;
        this.mCallable = callable;
        this.setId(PriorityUtils.generateId());
    }

    @Override
    public void priority(int priority) {
        if (this.mPriority != null) {
            this.mPriority.priority(priority);
        }
    }

    @Override
    public long getId() {
        return this.mPriority != null ? this.mPriority.getId() : 0L;
    }

    @Override
    public void setId(long id) {
        if (this.mPriority != null) {
            this.mPriority.setId(id);
        }
    }

    @Override
    public int priority() {
        return this.mPriority != null ? this.mPriority.priority() : 0;
    }

    @Override
    public int compareTo(IPriority other) {
        return PriorityUtils.compare(this, other);
    }

    @Override
    public V call() throws Exception {
        if (this.mCallable != null) {
            return this.mCallable.call();
        }
        return null;
    }

    public String toString() {
        return "DefaultPriorityCallable{, mPriority=" + this.mPriority + ", mCallable=" + this.mCallable + '}';
    }
}

