/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xtask.thread.pool.cancel;

import android.os.Handler;
import androidx.annotation.NonNull;
import com.xuexiang.xtask.thread.pool.cancel.ICancelable;
import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicBoolean;

public class CancelHandlerRunnable
implements Runnable,
ICancelable {
    private WeakReference<Handler> mHandler;
    private Runnable mRunnable;
    private AtomicBoolean mIsCancelled = new AtomicBoolean(false);

    public static CancelHandlerRunnable get(@NonNull Handler handler, @NonNull Runnable runnable) {
        return new CancelHandlerRunnable(handler, runnable);
    }

    private CancelHandlerRunnable(@NonNull Handler handler, @NonNull Runnable runnable) {
        this.mHandler = new WeakReference<Handler>(handler);
        this.mRunnable = runnable;
    }

    public ICancelable startDelayed(long delayMillis) {
        Handler handler = (Handler)this.mHandler.get();
        if (handler != null) {
            handler.postDelayed((Runnable)this, delayMillis);
        }
        return this;
    }

    @Override
    public void cancel() {
        if (this.isCancelled()) {
            return;
        }
        Handler handler = (Handler)this.mHandler.get();
        if (handler == null) {
            return;
        }
        handler.removeCallbacks((Runnable)this);
        this.mIsCancelled.set(true);
    }

    @Override
    public boolean isCancelled() {
        return this.mIsCancelled.get();
    }

    @Override
    public void run() {
        if (this.mRunnable != null) {
            this.mRunnable.run();
        }
    }
}

