/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xtask.thread.pool;

import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import com.xuexiang.xtask.logger.TaskLogger;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class TaskThreadFactory
implements ThreadFactory {
    private static final String TAG = TaskLogger.getLogTag("TaskThreadFactory");
    private static final Map<Integer, AtomicInteger> POOL_NUMBER_MAP = new ConcurrentHashMap<Integer, AtomicInteger>();
    private final ThreadGroup mThreadGroup;
    private final AtomicInteger mThreadNumber = new AtomicInteger(1);
    private final String mNamePrefix;
    private final int mPriority;

    public static TaskThreadFactory getFactory(@NonNull String factoryName) {
        return new TaskThreadFactory(factoryName, 5);
    }

    public static TaskThreadFactory getFactory(@NonNull String factoryName, @IntRange(from=1L, to=10L) int priority) {
        return new TaskThreadFactory(factoryName, priority);
    }

    private TaskThreadFactory(@NonNull String factoryName, @IntRange(from=1L, to=10L) int priority) {
        SecurityManager securityManager = System.getSecurityManager();
        this.mThreadGroup = securityManager != null ? securityManager.getThreadGroup() : Thread.currentThread().getThreadGroup();
        this.mNamePrefix = factoryName + "-task-pool(" + priority + ") No." + this.getTaskPoolNumber(priority) + ", thread No.";
        this.mPriority = priority;
    }

    @Override
    public Thread newThread(Runnable r) {
        String threadName = this.mNamePrefix + this.mThreadNumber.getAndIncrement();
        TaskLogger.iTag(TAG, "Thread production, name is [" + threadName + "]");
        Thread thread = new Thread(this.mThreadGroup, r, threadName, 0L);
        if (thread.isDaemon()) {
            thread.setDaemon(false);
        }
        if (thread.getPriority() != this.mPriority) {
            thread.setPriority(this.mPriority);
        }
        thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread, Throwable ex) {
                TaskLogger.eTag(TAG, "Running task appeared exception! Thread [" + thread.getName() + "], because [" + ex.getMessage() + "]");
            }
        });
        return thread;
    }

    private int getTaskPoolNumber(int priority) {
        AtomicInteger poolNumber = POOL_NUMBER_MAP.get(priority);
        if (poolNumber == null) {
            poolNumber = new AtomicInteger(1);
            POOL_NUMBER_MAP.put(priority, poolNumber);
        }
        return poolNumber.getAndIncrement();
    }
}

