/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xtask.thread.pool;

import androidx.annotation.NonNull;
import com.xuexiang.xtask.thread.pool.TaskRecordPolicy;
import com.xuexiang.xtask.thread.pool.TaskThreadFactory;
import com.xuexiang.xtask.thread.pool.base.BaseThreadPoolExecutor;
import com.xuexiang.xtask.thread.pool.cancel.IFuture;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class DefaultThreadPoolExecutor
extends BaseThreadPoolExecutor {
    public static DefaultThreadPoolExecutor getDefault() {
        return new Builder().build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(int corePoolSize) {
        return new Builder(corePoolSize);
    }

    public static Builder newBuilder(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit) {
        return new Builder(corePoolSize, maximumPoolSize, keepAliveTime, unit);
    }

    private DefaultThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        return new DefaultFuture<T>(callable);
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
        return new DefaultFuture<T>(runnable, value);
    }

    public IFuture<?> submit(@NonNull Runnable task) {
        return (IFuture)super.submit(task);
    }

    public static final class Builder {
        private static final int DEFAULT_CORE_POOL_SIZE = Runtime.getRuntime().availableProcessors() + 1;
        private static final long DEFAULT_KEEP_ALIVE_TIME = 30L;
        private static final String DEFAULT_FACTORY_NAME = "Default";
        private static final int DEFAULT_BLOCKING_QUEUE_SIZE = 128;
        int corePoolSize;
        int maximumPoolSize;
        long keepAliveTime;
        TimeUnit unit;
        BlockingQueue<Runnable> workQueue;
        ThreadFactory threadFactory;
        RejectedExecutionHandler handler;

        public Builder() {
            this(DEFAULT_CORE_POOL_SIZE);
        }

        public Builder(int corePoolSize) {
            this(corePoolSize, corePoolSize, 30L, TimeUnit.SECONDS);
        }

        public Builder(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit) {
            this.corePoolSize = corePoolSize;
            this.maximumPoolSize = maximumPoolSize;
            this.keepAliveTime = keepAliveTime;
            this.unit = unit;
        }

        public Builder setCorePoolSize(int corePoolSize) {
            this.corePoolSize = corePoolSize;
            return this;
        }

        public Builder setMaximumPoolSize(int maximumPoolSize) {
            this.maximumPoolSize = maximumPoolSize;
            return this;
        }

        public Builder setKeepAliveTime(long keepAliveTime) {
            this.keepAliveTime = keepAliveTime;
            return this;
        }

        public Builder setUnit(TimeUnit unit) {
            this.unit = unit;
            return this;
        }

        public Builder setWorkQueue(BlockingQueue<Runnable> workQueue) {
            this.workQueue = workQueue;
            return this;
        }

        public Builder setThreadFactory(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
            return this;
        }

        public Builder setHandler(RejectedExecutionHandler handler) {
            this.handler = handler;
            return this;
        }

        public DefaultThreadPoolExecutor build() {
            if (this.workQueue == null) {
                this.workQueue = new LinkedBlockingQueue<Runnable>(128);
            }
            if (this.threadFactory == null) {
                this.threadFactory = TaskThreadFactory.getFactory(DEFAULT_FACTORY_NAME);
            }
            if (this.handler == null) {
                this.handler = new TaskRecordPolicy();
            }
            return new DefaultThreadPoolExecutor(this.corePoolSize, this.maximumPoolSize, this.keepAliveTime, this.unit, this.workQueue, this.threadFactory, this.handler);
        }
    }

    public static class DefaultFuture<V>
    extends FutureTask<V>
    implements IFuture<V> {
        DefaultFuture(Callable<V> callable) {
            super(callable);
        }

        DefaultFuture(Runnable runnable, V result) {
            super(runnable, result);
        }

        @Override
        public void cancel() {
            this.cancel(true);
        }
    }
}

