/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xtask.thread.executor.impl;

import androidx.annotation.NonNull;
import com.xuexiang.xtask.thread.executor.IScheduledExecutorCore;
import com.xuexiang.xtask.thread.pool.DefaultScheduledThreadPoolExecutor;
import com.xuexiang.xtask.thread.pool.cancel.ICancelable;
import com.xuexiang.xtask.thread.utils.ExecutorUtils;
import java.util.concurrent.TimeUnit;

public class ScheduledExecutorCore
implements IScheduledExecutorCore {
    private DefaultScheduledThreadPoolExecutor mExecutor;

    @Override
    public ICancelable schedule(Runnable task, long delay, TimeUnit unit) {
        return this.getThreadPoolExecutor().schedule(task, delay, unit);
    }

    @Override
    public ICancelable scheduleAtFixedRate(Runnable task, long initialDelay, long period, TimeUnit unit) {
        return this.getThreadPoolExecutor().scheduleAtFixedRate(task, initialDelay, period, unit);
    }

    @Override
    public ICancelable scheduleWithFixedDelay(Runnable task, long initialDelay, long period, TimeUnit unit) {
        return this.getThreadPoolExecutor().scheduleWithFixedDelay(task, initialDelay, period, unit);
    }

    @Override
    public void shutdown() {
        ExecutorUtils.shutdown(this.mExecutor);
        this.mExecutor = null;
    }

    @NonNull
    private DefaultScheduledThreadPoolExecutor getThreadPoolExecutor() {
        if (this.mExecutor == null) {
            this.mExecutor = DefaultScheduledThreadPoolExecutor.getDefault();
        }
        return this.mExecutor;
    }
}

