/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xtask.logger;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.xuexiang.xtask.logger.ILogger;
import com.xuexiang.xtask.logger.LogcatLogger;

public final class TaskLogger {
    public static final String TASK_LOG_TAG = "TaskLogger";
    private static final int MAX_LOG_PRIORITY = 10;
    private static final int MIN_LOG_PRIORITY = 0;
    private static ILogger sILogger = new LogcatLogger();
    private static String sTag = "TaskLogger";
    private static boolean sIsDebug = false;
    private static int sLogPriority = 10;
    private static boolean sIsLogThreadName = false;

    private TaskLogger() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static String getLogTag(@NonNull Class<?> clazz) {
        return sTag + "_" + clazz.getSimpleName();
    }

    public static String getLogTag(@NonNull String className) {
        return sTag + "_" + className;
    }

    public static void setLogger(@NonNull ILogger logger) {
        sILogger = logger;
    }

    public static void setTag(String tag) {
        sTag = tag;
    }

    public static void setDebug(boolean isDebug) {
        sIsDebug = isDebug;
    }

    public static void setPriority(int priority) {
        sLogPriority = priority;
    }

    public static void setIsLogThreadName(boolean isLogThreadName) {
        sIsLogThreadName = isLogThreadName;
    }

    public static boolean isLogThreadName() {
        return sIsLogThreadName;
    }

    public static void debug(boolean isDebug) {
        TaskLogger.debug(isDebug ? TASK_LOG_TAG : "");
    }

    public static void debug(String tag) {
        if (!TextUtils.isEmpty((CharSequence)tag)) {
            TaskLogger.setDebug(true);
            TaskLogger.setPriority(0);
            TaskLogger.setTag(tag);
        } else {
            TaskLogger.setDebug(false);
            TaskLogger.setPriority(10);
            TaskLogger.setTag("");
        }
    }

    public static void v(String msg) {
        if (TaskLogger.enableLog(2)) {
            sILogger.log(2, sTag, msg, null);
        }
    }

    public static void vTag(String tag, String msg) {
        if (TaskLogger.enableLog(2)) {
            sILogger.log(2, tag, msg, null);
        }
    }

    public static void d(String msg) {
        if (TaskLogger.enableLog(3)) {
            sILogger.log(3, sTag, msg, null);
        }
    }

    public static void dTag(String tag, String msg) {
        if (TaskLogger.enableLog(3)) {
            sILogger.log(3, tag, msg, null);
        }
    }

    public static void i(String msg) {
        if (TaskLogger.enableLog(4)) {
            sILogger.log(4, sTag, msg, null);
        }
    }

    public static void iTag(String tag, String msg) {
        if (TaskLogger.enableLog(4)) {
            sILogger.log(4, tag, msg, null);
        }
    }

    public static void w(String msg) {
        if (TaskLogger.enableLog(5)) {
            sILogger.log(5, sTag, msg, null);
        }
    }

    public static void wTag(String tag, String msg) {
        if (TaskLogger.enableLog(5)) {
            sILogger.log(5, tag, msg, null);
        }
    }

    public static void e(String msg) {
        if (TaskLogger.enableLog(6)) {
            sILogger.log(6, sTag, msg, null);
        }
    }

    public static void eTag(String tag, String msg) {
        if (TaskLogger.enableLog(6)) {
            sILogger.log(6, tag, msg, null);
        }
    }

    public static void e(Throwable t) {
        if (TaskLogger.enableLog(6)) {
            sILogger.log(6, sTag, null, t);
        }
    }

    public static void eTag(String tag, Throwable t) {
        if (TaskLogger.enableLog(6)) {
            sILogger.log(6, tag, null, t);
        }
    }

    public static void e(String msg, Throwable t) {
        if (TaskLogger.enableLog(6)) {
            sILogger.log(6, sTag, msg, t);
        }
    }

    public static void eTag(String tag, String msg, Throwable t) {
        if (TaskLogger.enableLog(6)) {
            sILogger.log(6, tag, msg, t);
        }
    }

    public static void wtf(String msg) {
        if (TaskLogger.enableLog(7)) {
            sILogger.log(7, sTag, msg, null);
        }
    }

    public static void wtfTag(String tag, String msg) {
        if (TaskLogger.enableLog(7)) {
            sILogger.log(7, tag, msg, null);
        }
    }

    public static void log(int priority, String tag, String msg) {
        if (TaskLogger.enableLog(priority)) {
            sILogger.log(priority, tag, msg, null);
        }
    }

    private static boolean enableLog(int logPriority) {
        return TaskLogger.isDebug() && logPriority >= sLogPriority;
    }

    public static boolean isDebug() {
        return sILogger != null && sIsDebug;
    }
}

