/*
 * Copyright (C) 2022 xuexiangjys(xuexiangjys@163.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package com.xuexiang.xtask.thread.executor;

import com.xuexiang.xtask.thread.pool.cancel.ICancelable;

/**
 * 拥有不同类别的执行者内核实现接口
 *
 * @author xuexiang
 * @since 1/27/22 12:50 AM
 */
public interface ICategoryExecutorCore extends IExecutorCore {

    /**
     * 执行任务到主线程
     *
     * @param task 任务
     * @return 是否执行成功
     */
    boolean postToMain(Runnable task);

    /**
     * 延迟执行任务到主线程
     *
     * @param task        任务
     * @param delayMillis 延迟时间
     * @return 取消接口
     */
    ICancelable postToMainDelay(Runnable task, long delayMillis);

    /**
     * 执行紧急异步任务【线程的优先级默认是10】
     *
     * @param task 任务
     * @return 取消接口
     */
    ICancelable emergentSubmit(Runnable task);

    /**
     * 执行普通异步任务【线程的优先级是5】
     *
     * @param task 任务
     * @return 取消接口
     */
    ICancelable submit(Runnable task);

    /**
     * 执行后台异步任务【线程的优先级是1】
     *
     * @param task 任务
     * @return 取消接口
     */
    ICancelable backgroundSubmit(Runnable task);

    /**
     * 执行io耗时的异步任务【线程的优先级是5】
     *
     * @param task 任务
     * @return 取消接口
     */
    ICancelable ioSubmit(Runnable task);

    /**
     * 执行分组异步任务【线程的优先级是5】
     *
     * @param groupName 任务组名
     * @param task      任务
     * @return 取消接口
     */
    ICancelable groupSubmit(String groupName, Runnable task);


}
