/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xqrcode.util;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import androidx.annotation.Nullable;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.Result;
import com.google.zxing.common.HybridBinarizer;
import com.xuexiang.xqrcode.camera.BitmapLuminanceSource;
import com.xuexiang.xqrcode.decoding.DecodeFormatManager;
import java.io.File;
import java.util.Hashtable;
import java.util.Vector;

public final class QRCodeAnalyzeUtils {
    private QRCodeAnalyzeUtils() {
        throw new UnsupportedOperationException("Do not need instantiate!");
    }

    public static void analyze(String QRCodePicPath, AnalyzeCallback analyzeCallback) {
        Bitmap bitmap = QRCodeAnalyzeUtils.getQRCodeBitmap(QRCodePicPath);
        Result rawResult = QRCodeAnalyzeUtils.analyze(bitmap);
        if (rawResult != null) {
            if (analyzeCallback != null) {
                analyzeCallback.onAnalyzeSuccess(bitmap, rawResult.getText());
            }
        } else if (analyzeCallback != null) {
            analyzeCallback.onAnalyzeFailed();
        }
    }

    public static void analyze(Bitmap QRCodeBitmap, AnalyzeCallback analyzeCallback) {
        Result rawResult = QRCodeAnalyzeUtils.analyze(QRCodeBitmap);
        if (rawResult != null) {
            if (analyzeCallback != null) {
                analyzeCallback.onAnalyzeSuccess(QRCodeBitmap, rawResult.getText());
            }
        } else if (analyzeCallback != null) {
            analyzeCallback.onAnalyzeFailed();
        }
    }

    public static String analyze(String qrCodePicPath) {
        Result rawResult = QRCodeAnalyzeUtils.analyzeQRCode(qrCodePicPath);
        if (rawResult != null) {
            return rawResult.getText();
        }
        return "";
    }

    public static Result analyzeQRCode(String qrCodePicPath) {
        Bitmap bitmap = QRCodeAnalyzeUtils.getQRCodeBitmap(qrCodePicPath);
        return QRCodeAnalyzeUtils.analyze(bitmap);
    }

    private static Bitmap getQRCodeBitmap(String qrCodePicPath) {
        return QRCodeAnalyzeUtils.getBitmap(qrCodePicPath, 400, 400);
    }

    @Nullable
    public static Result analyze(Bitmap bitmap) {
        MultiFormatReader multiFormatReader = new MultiFormatReader();
        Hashtable hints = new Hashtable(2);
        Vector<BarcodeFormat> decodeFormats = new Vector<BarcodeFormat>();
        if (decodeFormats.isEmpty()) {
            decodeFormats = new Vector();
            decodeFormats.addAll(DecodeFormatManager.ONE_D_FORMATS);
            decodeFormats.addAll(DecodeFormatManager.QR_CODE_FORMATS);
            decodeFormats.addAll(DecodeFormatManager.DATA_MATRIX_FORMATS);
        }
        hints.put(DecodeHintType.POSSIBLE_FORMATS, decodeFormats);
        multiFormatReader.setHints(hints);
        Result rawResult = null;
        try {
            rawResult = multiFormatReader.decodeWithState(new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)new BitmapLuminanceSource(bitmap))));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rawResult;
    }

    public static Bitmap getBitmap(String filePath, int maxWidth, int maxHeight) {
        if (!QRCodeAnalyzeUtils.isFileExists(filePath)) {
            return null;
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
        options.inSampleSize = QRCodeAnalyzeUtils.calculateInSampleSize(options, maxWidth, maxHeight);
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
    }

    private static int calculateInSampleSize(BitmapFactory.Options options, int maxWidth, int maxHeight) {
        int height = options.outHeight;
        int width = options.outWidth;
        int inSampleSize = 1;
        while ((width >>= 1) >= maxWidth && (height >>= 1) >= maxHeight) {
            inSampleSize <<= 1;
        }
        return inSampleSize;
    }

    private static File getFileByPath(String filePath) {
        return QRCodeAnalyzeUtils.isSpace(filePath) ? null : new File(filePath);
    }

    private static boolean isFileExists(String filePath) {
        return QRCodeAnalyzeUtils.isFileExists(QRCodeAnalyzeUtils.getFileByPath(filePath));
    }

    private static boolean isFileExists(File file) {
        return file != null && file.exists();
    }

    private static boolean isSpace(String s) {
        if (s == null) {
            return true;
        }
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static interface AnalyzeCallback {
        public void onAnalyzeSuccess(Bitmap var1, String var2);

        public void onAnalyzeFailed();
    }
}

