/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xqrcode.ui;

import android.app.Activity;
import android.content.res.AssetFileDescriptor;
import android.graphics.Bitmap;
import android.hardware.Camera;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.os.Bundle;
import android.os.Handler;
import android.os.Vibrator;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresPermission;
import androidx.fragment.app.Fragment;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.Result;
import com.xuexiang.xqrcode.R;
import com.xuexiang.xqrcode.camera.CameraManager;
import com.xuexiang.xqrcode.decoding.CaptureViewHandler;
import com.xuexiang.xqrcode.decoding.InactivityTimer;
import com.xuexiang.xqrcode.ui.ICaptureView;
import com.xuexiang.xqrcode.util.QRCodeAnalyzeUtils;
import com.xuexiang.xqrcode.view.ViewfinderView;
import java.io.IOException;
import java.util.Vector;

public class CaptureFragment
extends Fragment
implements ICaptureView,
SurfaceHolder.Callback {
    private CaptureViewHandler mHandler;
    private ViewfinderView mViewfinderView;
    private boolean mHasSurface;
    private Vector<BarcodeFormat> mDecodeFormats;
    private String mCharacterSet;
    private InactivityTimer mInactivityTimer;
    private MediaPlayer mMediaPlayer;
    private boolean mPlayBeep;
    private static final float BEEP_VOLUME = 0.1f;
    private boolean mVibrate;
    private SurfaceHolder mSurfaceHolder;
    @Nullable
    private CameraInitCallBack mCameraInitCallBack;
    private QRCodeAnalyzeUtils.AnalyzeCallback mAnalyzeCallback;
    private Camera mCamera;
    private boolean mIsRepeated;
    private long mScanInterval;
    private static final long VIBRATE_DURATION = 200L;
    private final MediaPlayer.OnCompletionListener mBeepListener = new MediaPlayer.OnCompletionListener(){

        public void onCompletion(MediaPlayer mediaPlayer) {
            mediaPlayer.seekTo(0);
        }
    };

    public static CaptureFragment newInstance(int layoutId) {
        return CaptureFragment.newInstance(layoutId, false, 0L);
    }

    public static CaptureFragment newInstance(int layoutId, boolean isRepeated, long scanInterval) {
        if (layoutId == -1) {
            return null;
        }
        CaptureFragment captureFragment = new CaptureFragment();
        Bundle bundle = new Bundle();
        bundle.putInt("key_layout_id", layoutId);
        bundle.putBoolean("key_is_repeated", isRepeated);
        bundle.putLong("key_scan_interval", scanInterval);
        captureFragment.setArguments(bundle);
        return captureFragment;
    }

    public static void onCreate(Activity activity) {
        if (activity != null) {
            activity.getWindow().addFlags(128);
            activity.getWindow().setFormat(-3);
        }
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        CaptureFragment.onCreate((Activity)this.getActivity());
        CameraManager.init(CaptureFragment.requireNonNull(this.getActivity()).getApplicationContext());
        this.mHasSurface = false;
        this.mInactivityTimer = new InactivityTimer((Activity)this.getActivity());
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        Bundle bundle = this.getArguments();
        View view = null;
        if (bundle != null) {
            int layoutId = bundle.getInt("key_layout_id");
            if (layoutId != -1) {
                view = inflater.inflate(layoutId, null);
            }
            this.mIsRepeated = bundle.getBoolean("key_is_repeated");
            this.mScanInterval = bundle.getLong("key_scan_interval");
        }
        if (view == null) {
            view = inflater.inflate(R.layout.xqrcode_fragment_capture, null);
        }
        this.mViewfinderView = (ViewfinderView)view.findViewById(R.id.viewfinder_view);
        SurfaceView surfaceView = (SurfaceView)view.findViewById(R.id.preview_view);
        this.mSurfaceHolder = surfaceView.getHolder();
        return view;
    }

    public void onResume() {
        super.onResume();
        if (this.mHasSurface) {
            this.initCamera(this.mSurfaceHolder);
        } else {
            this.mSurfaceHolder.addCallback((SurfaceHolder.Callback)this);
            this.mSurfaceHolder.setType(3);
        }
        this.mDecodeFormats = null;
        this.mCharacterSet = null;
        this.mPlayBeep = true;
        AudioManager audioService = (AudioManager)CaptureFragment.requireNonNull(this.getActivity()).getSystemService("audio");
        if (audioService != null && audioService.getRingerMode() != 2) {
            this.mPlayBeep = false;
        }
        this.initBeepSound();
        this.mVibrate = true;
    }

    public void onPause() {
        super.onPause();
        if (this.mHandler != null) {
            this.mHandler.quitSynchronously();
            this.mHandler = null;
        }
        CameraManager.get().closeDriver();
    }

    public void onDestroyView() {
        if (this.mInactivityTimer != null) {
            this.mInactivityTimer.shutdown();
        }
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.stop();
            this.mMediaPlayer.reset();
            this.mMediaPlayer.release();
            this.mMediaPlayer = null;
        }
        super.onDestroyView();
    }

    @Override
    public void handleDecode(Result result, Bitmap barcode) {
        this.mInactivityTimer.onActivity();
        this.playBeepSoundAndVibrate();
        if (result == null || TextUtils.isEmpty((CharSequence)result.getText())) {
            if (this.mAnalyzeCallback != null) {
                this.mAnalyzeCallback.onAnalyzeFailed();
            }
        } else if (this.mAnalyzeCallback != null) {
            this.mAnalyzeCallback.onAnalyzeSuccess(barcode, result.getText());
        }
        if (this.mIsRepeated && this.mHandler != null) {
            this.mHandler.sendEmptyMessageDelayed(R.id.restart_preview, this.mScanInterval);
        }
    }

    private void initCamera(SurfaceHolder surfaceHolder) {
        try {
            CameraManager.get().openDriver(surfaceHolder);
            this.mCamera = CameraManager.get().getCamera();
        }
        catch (Exception e) {
            if (this.mCameraInitCallBack != null) {
                this.mCameraInitCallBack.callBack(e);
            }
            return;
        }
        if (this.mCameraInitCallBack != null) {
            this.mCameraInitCallBack.callBack(null);
        }
        if (this.mHandler == null) {
            this.mHandler = new CaptureViewHandler(this, this.mDecodeFormats, this.mCharacterSet, this.mViewfinderView);
        }
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
    }

    public void surfaceCreated(SurfaceHolder holder) {
        if (!this.mHasSurface) {
            this.mHasSurface = true;
            this.initCamera(holder);
        }
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        this.mHasSurface = false;
        if (this.mCamera != null && CameraManager.get().isPreviewing()) {
            if (!CameraManager.get().isUseOneShotPreviewCallback()) {
                this.mCamera.setPreviewCallback(null);
            }
            this.mCamera.stopPreview();
            CameraManager.get().getPreviewCallback().setHandler(null, 0);
            CameraManager.get().getAutoFocusCallback().setHandler(null, 0);
            CameraManager.get().setPreviewing(false);
        }
    }

    @Override
    public Handler getCaptureHandler() {
        return this.mHandler;
    }

    @Override
    public void drawViewfinder() {
        this.mViewfinderView.drawViewfinder();
    }

    private void initBeepSound() {
        if (this.mPlayBeep && this.mMediaPlayer == null) {
            CaptureFragment.requireNonNull(this.getActivity()).setVolumeControlStream(3);
            this.mMediaPlayer = new MediaPlayer();
            this.mMediaPlayer.setAudioStreamType(3);
            this.mMediaPlayer.setOnCompletionListener(this.mBeepListener);
            AssetFileDescriptor file = this.getResources().openRawResourceFd(R.raw.beep);
            try {
                this.mMediaPlayer.setDataSource(file.getFileDescriptor(), file.getStartOffset(), file.getLength());
                file.close();
                this.mMediaPlayer.setVolume(0.1f, 0.1f);
                this.mMediaPlayer.prepare();
            }
            catch (IOException e) {
                this.mMediaPlayer = null;
            }
        }
    }

    private void playBeepSoundAndVibrate() {
        Vibrator vibrator;
        if (this.mPlayBeep && this.mMediaPlayer != null) {
            this.mMediaPlayer.start();
        }
        if (this.mVibrate && (vibrator = (Vibrator)CaptureFragment.requireNonNull(this.getActivity()).getSystemService("vibrator")) != null) {
            vibrator.vibrate(200L);
        }
    }

    public QRCodeAnalyzeUtils.AnalyzeCallback getAnalyzeCallback() {
        return this.mAnalyzeCallback;
    }

    @RequiresPermission(value="android.permission-group.CAMERA")
    public void setAnalyzeCallback(QRCodeAnalyzeUtils.AnalyzeCallback analyzeCallback) {
        this.mAnalyzeCallback = analyzeCallback;
    }

    public void setCameraInitCallBack(CameraInitCallBack callBack) {
        this.mCameraInitCallBack = callBack;
    }

    public static <T> T requireNonNull(T obj) {
        if (obj == null) {
            throw new NullPointerException();
        }
        return obj;
    }

    public static interface CameraInitCallBack {
        public void callBack(@Nullable Exception var1);
    }
}

