/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xqrcode.decoding;

import android.os.Handler;
import android.os.Looper;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.DecodeHintType;
import com.google.zxing.ResultPointCallback;
import com.xuexiang.xqrcode.decoding.DecodeFormatManager;
import com.xuexiang.xqrcode.decoding.DecodeHandler;
import com.xuexiang.xqrcode.ui.ICaptureView;
import java.util.Hashtable;
import java.util.Vector;
import java.util.concurrent.CountDownLatch;

final class DecodeThread
extends Thread {
    public static final String BARCODE_BITMAP = "barcode_bitmap";
    private final ICaptureView mCaptureView;
    private final Hashtable<DecodeHintType, Object> mHints;
    private Handler mHandler;
    private final CountDownLatch mHandlerInitLatch;

    DecodeThread(ICaptureView captureView, Vector<BarcodeFormat> decodeFormats, String characterSet, ResultPointCallback resultPointCallback) {
        this.mCaptureView = captureView;
        this.mHandlerInitLatch = new CountDownLatch(1);
        this.mHints = new Hashtable(3);
        if (decodeFormats == null || decodeFormats.isEmpty()) {
            decodeFormats = new Vector();
            decodeFormats.addAll(DecodeFormatManager.ONE_D_FORMATS);
            decodeFormats.addAll(DecodeFormatManager.QR_CODE_FORMATS);
            decodeFormats.addAll(DecodeFormatManager.DATA_MATRIX_FORMATS);
        }
        this.mHints.put(DecodeHintType.POSSIBLE_FORMATS, decodeFormats);
        if (characterSet != null) {
            this.mHints.put(DecodeHintType.CHARACTER_SET, characterSet);
        }
        this.mHints.put(DecodeHintType.NEED_RESULT_POINT_CALLBACK, resultPointCallback);
    }

    Handler getHandler() {
        try {
            this.mHandlerInitLatch.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return this.mHandler;
    }

    @Override
    public void run() {
        Looper.prepare();
        this.mHandler = new DecodeHandler(this.mCaptureView, this.mHints);
        this.mHandlerInitLatch.countDown();
        Looper.loop();
    }
}

