/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xqrcode.camera;

import android.hardware.Camera;
import android.os.Handler;
import android.os.Message;
import com.xuexiang.xqrcode.XQRCode;
import com.xuexiang.xqrcode.logs.QCLog;

public final class AutoFocusCallback
implements Camera.AutoFocusCallback {
    private static final String TAG = AutoFocusCallback.class.getSimpleName();
    public static final long AUTO_FOCUS_INTERVAL_MS = 1500L;
    private Handler autoFocusHandler;
    private int autoFocusMessage;

    public void setHandler(Handler autoFocusHandler, int autoFocusMessage) {
        this.autoFocusHandler = autoFocusHandler;
        this.autoFocusMessage = autoFocusMessage;
    }

    public void onAutoFocus(boolean success, Camera camera) {
        if (this.autoFocusHandler != null) {
            Message message = this.autoFocusHandler.obtainMessage(this.autoFocusMessage, (Object)success);
            this.autoFocusHandler.sendMessageDelayed(message, XQRCode.getAutoFocusInterval());
            this.autoFocusHandler = null;
        } else {
            QCLog.dTag(TAG, "Got auto-focus callback, but no handler for it");
        }
    }
}

