/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xqrcode;

import android.app.Activity;
import android.graphics.Bitmap;
import android.hardware.Camera;
import android.os.Bundle;
import androidx.fragment.app.Fragment;
import com.google.zxing.Result;
import com.xuexiang.xqrcode.R;
import com.xuexiang.xqrcode.camera.CameraManager;
import com.xuexiang.xqrcode.logs.QCLog;
import com.xuexiang.xqrcode.ui.CaptureActivity;
import com.xuexiang.xqrcode.ui.CaptureFragment;
import com.xuexiang.xqrcode.util.QRCodeAnalyzeUtils;
import com.xuexiang.xqrcode.util.QRCodeProduceUtils;
import java.util.List;

public class XQRCode {
    public static final String RESULT_TYPE = "result_type";
    public static final String RESULT_DATA = "result_data";
    public static final int RESULT_SUCCESS = 1;
    public static final int RESULT_FAILED = 2;
    public static final String KEY_LAYOUT_ID = "key_layout_id";
    public static final String KEY_IS_REPEATED = "key_is_repeated";
    public static final String KEY_SCAN_INTERVAL = "key_scan_interval";
    public static final String ACTION_DEFAULT_CAPTURE = "com.xuexiang.xqrcode.ui.captureactivity";
    public static long sAutoFocusInterval = 1500L;

    public static void debug(boolean isDebug) {
        QCLog.debug(isDebug);
    }

    public static void debug(String tag) {
        QCLog.debug(tag);
    }

    public static void setAutoFocusInterval(long sAutoFocusInterval) {
        XQRCode.sAutoFocusInterval = sAutoFocusInterval;
    }

    public static long getAutoFocusInterval() {
        return sAutoFocusInterval;
    }

    public static void startScan(Fragment fragment, int requestCode) {
        CaptureActivity.start(fragment, requestCode, R.style.XQRCodeTheme);
    }

    public static void startScan(Fragment fragment, int requestCode, int theme) {
        CaptureActivity.start(fragment, requestCode, theme);
    }

    public static void startScan(Activity activity, int requestCode) {
        CaptureActivity.start(activity, requestCode, R.style.XQRCodeTheme);
    }

    public static void startScan(Activity activity, int requestCode, int theme) {
        CaptureActivity.start(activity, requestCode, theme);
    }

    public static CaptureFragment getCaptureFragment(int layoutId) {
        return CaptureFragment.newInstance(layoutId);
    }

    public static CaptureFragment getCaptureFragment(int layoutId, boolean isRepeated, long scanInterval) {
        return CaptureFragment.newInstance(layoutId, isRepeated, scanInterval);
    }

    public static void setFragmentArgs(CaptureFragment captureFragment, int layoutId) {
        XQRCode.setFragmentArgs(captureFragment, layoutId, false, 0L);
    }

    public static void setFragmentArgs(CaptureFragment captureFragment, int layoutId, boolean isRepeated, long scanInterval) {
        if (captureFragment == null || layoutId == -1) {
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putInt(KEY_LAYOUT_ID, layoutId);
        bundle.putBoolean(KEY_IS_REPEATED, isRepeated);
        bundle.putLong(KEY_SCAN_INTERVAL, scanInterval);
        captureFragment.setArguments(bundle);
    }

    public static void analyzeQRCode(String QRCodePicPath, QRCodeAnalyzeUtils.AnalyzeCallback analyzeCallback) {
        QRCodeAnalyzeUtils.analyze(QRCodePicPath, analyzeCallback);
    }

    public static void analyzeQRCode(Bitmap QRCodeBitmap, QRCodeAnalyzeUtils.AnalyzeCallback analyzeCallback) {
        QRCodeAnalyzeUtils.analyze(QRCodeBitmap, analyzeCallback);
    }

    public static String analyzeQRCode(String QRCodePicPath) {
        return QRCodeAnalyzeUtils.analyze(QRCodePicPath);
    }

    public static Result analyzeQRCode(Bitmap QRCodeBitmap) {
        return QRCodeAnalyzeUtils.analyze(QRCodeBitmap);
    }

    public static Result getAnalyzeQRCodeResult(String QRCodePicPath) {
        return QRCodeAnalyzeUtils.analyzeQRCode(QRCodePicPath);
    }

    public static Bitmap createQRCodeWithLogo(String contents, int width, int height, Bitmap logo) {
        return QRCodeProduceUtils.create(contents, width, height, logo);
    }

    public static Bitmap createQRCodeWithLogo(String contents, Bitmap logo) {
        return QRCodeProduceUtils.create(contents, 400, 400, logo);
    }

    public static QRCodeProduceUtils.Builder newQRCodeBuilder(String contents) {
        return QRCodeProduceUtils.newBuilder(contents);
    }

    public static void switchFlashLight(boolean isEnable) throws RuntimeException {
        if (isEnable) {
            XQRCode.enableFlashLight();
        } else {
            XQRCode.disableFlashLight();
        }
    }

    public static void disableFlashLight() {
        Camera.Parameters parameter;
        Camera camera = CameraManager.get().getCamera();
        if (camera != null && (parameter = camera.getParameters()) != null) {
            parameter.setFlashMode("off");
            camera.setParameters(parameter);
        }
    }

    public static void enableFlashLight() {
        List supportedFlashModes;
        Camera.Parameters parameter;
        Camera camera = CameraManager.get().getCamera();
        if (camera != null && (parameter = camera.getParameters()) != null && (supportedFlashModes = parameter.getSupportedFlashModes()) != null) {
            if (supportedFlashModes.contains("torch")) {
                parameter.setFlashMode("torch");
            } else if (supportedFlashModes.contains("on")) {
                parameter.setFlashMode("on");
            }
            camera.setParameters(parameter);
        }
    }

    public static boolean isFlashLightOpen() {
        String mode = XQRCode.getFlashMode();
        if (mode != null && mode.length() > 0) {
            return mode.equals("torch") || mode.equals("on");
        }
        return false;
    }

    private static String getFlashMode() {
        Camera camera = CameraManager.get().getCamera();
        if (camera != null) {
            Camera.Parameters parameter = camera.getParameters();
            return parameter.getFlashMode();
        }
        return null;
    }
}

