/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xpage.core;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;
import com.google.gson.reflect.TypeToken;
import com.xuexiang.xpage.R;
import com.xuexiang.xpage.base.XPageActivity;
import com.xuexiang.xpage.base.XPageFragment;
import com.xuexiang.xpage.core.CoreConfig;
import com.xuexiang.xpage.core.CorePage;
import com.xuexiang.xpage.core.CoreSwitcher;
import com.xuexiang.xpage.logger.PageLog;
import com.xuexiang.xpage.utils.GsonUtils;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CorePageManager {
    private static final String PAGE_INFO_JSON = "corepage.json";
    private static volatile CorePageManager sInstance = null;
    private Map<String, CorePage> mPageMap = new HashMap<String, CorePage>();

    private CorePageManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CorePageManager getInstance() {
        if (sInstance != null) return sInstance;
        Class<CorePageManager> clazz = CorePageManager.class;
        synchronized (CorePageManager.class) {
            if (sInstance != null) return sInstance;
            sInstance = new CorePageManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    public void init(Context context) {
        try {
            String content = this.readConfigFromAssets(context);
            this.readConfig(content);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void init(Context context, String pageJson) {
        this.init(context);
        if (!TextUtils.isEmpty((CharSequence)pageJson)) {
            this.readConfig(pageJson);
        }
    }

    public void readConfig(String content) {
        if (TextUtils.isEmpty((CharSequence)content)) {
            return;
        }
        PageLog.d("readConfig from json");
        List pages = (List)GsonUtils.fromJson((String)content, (Type)new TypeToken<List<CorePage>>(){}.getType());
        if (pages == null || pages.isEmpty()) {
            PageLog.e("readConfig is failed, pages is empty!");
            return;
        }
        for (CorePage page : pages) {
            String pageName = page.getName();
            if (TextUtils.isEmpty((CharSequence)pageName) || TextUtils.isEmpty((CharSequence)page.getClazz())) {
                PageLog.d("page Name is null or pageClass is null");
                continue;
            }
            this.mPageMap.put(pageName, page);
            PageLog.d("put a page:" + pageName);
        }
        PageLog.d("finished read pages, page size\uff1a" + this.mPageMap.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private String readConfigFromAssets(Context context) {
        StringBuilder s = new StringBuilder();
        BufferedReader br = null;
        try {
            String line;
            InputStreamReader inputReader = new InputStreamReader(context.getResources().getAssets().open(PAGE_INFO_JSON));
            br = new BufferedReader(inputReader);
            while ((line = br.readLine()) != null) {
                s.append(line);
            }
        }
        catch (Exception exception) {
            CorePageManager.closeIO(br);
            catch (Throwable throwable) {
                CorePageManager.closeIO(br);
                throw throwable;
            }
        }
        CorePageManager.closeIO(br);
        return s.toString();
    }

    static void closeIO(Closeable ... closeables) {
        if (closeables == null) {
            return;
        }
        for (Closeable closeable : closeables) {
            if (closeable == null) continue;
            try {
                closeable.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean putPage(String name, Class<? extends XPageFragment> clazz, Map<String, String> params) {
        if (TextUtils.isEmpty((CharSequence)name) || clazz == null) {
            PageLog.d("page Name is null or pageClass is null");
            return false;
        }
        if (this.mPageMap.containsKey(name)) {
            PageLog.d("page has already put!");
            return false;
        }
        this.mPageMap.put(name, new CorePage(name, clazz.getName(), this.buildParams(params)));
        PageLog.d("put a page:" + name);
        return true;
    }

    private String buildParams(Map<String, String> params) {
        if (params == null) {
            return "";
        }
        String result = GsonUtils.toJson(params);
        PageLog.d("params:" + result);
        return result;
    }

    public Fragment gotoPage(FragmentManager fragmentManager, String pageName, Bundle bundle, int[] animations) {
        PageLog.d("gotoPage:" + pageName);
        Fragment fragment = null;
        if (fragmentManager != null) {
            fragment = fragmentManager.findFragmentByTag(pageName);
        }
        if (fragment != null) {
            try {
                fragmentManager.popBackStackImmediate(pageName, 0);
            }
            catch (Exception e) {
                PageLog.e(e);
            }
        } else {
            fragment = this.openPageWithNewFragmentManager(fragmentManager, pageName, bundle, animations, true);
        }
        return fragment;
    }

    public XPageFragment openPageWithNewFragmentManager(FragmentManager fragmentManager, String pageName, Bundle bundle, int[] animations, boolean addToBackStack) {
        XPageFragment fragment = null;
        try {
            Fragment fragmentContainer;
            CorePage corePage = this.mPageMap.get(pageName);
            if (corePage == null) {
                PageLog.d("Page:" + pageName + " is null");
                return null;
            }
            fragment = this.loadXPageFragmentByCorePage(corePage, pageName, bundle);
            FragmentTransaction fragmentTransaction = fragmentManager.beginTransaction();
            if (animations != null && animations.length >= 4) {
                fragmentTransaction.setCustomAnimations(animations[0], animations[1], animations[2], animations[3]);
            }
            if ((fragmentContainer = fragmentManager.findFragmentById(R.id.fragment_container)) != null) {
                fragmentTransaction.hide(fragmentContainer);
            }
            fragmentTransaction.add(R.id.fragment_container, (Fragment)fragment, pageName);
            if (addToBackStack) {
                fragmentTransaction.addToBackStack(pageName);
            }
            fragmentTransaction.commitAllowingStateLoss();
        }
        catch (Exception e) {
            e.printStackTrace();
            PageLog.d("Fragment.error:" + e.getMessage());
            return null;
        }
        return fragment;
    }

    public XPageFragment changePageWithNewFragmentManager(FragmentManager fragmentManager, String pageName, Bundle bundle, int[] animations, boolean addToBackStack) {
        XPageFragment xPageFragment = null;
        try {
            List fragments;
            CorePage corePage = this.mPageMap.get(pageName);
            if (corePage == null) {
                PageLog.d("Page:" + pageName + " is null");
                return null;
            }
            FragmentTransaction fragmentTransaction = fragmentManager.beginTransaction();
            if (animations != null && animations.length >= 4) {
                fragmentTransaction.setCustomAnimations(animations[0], animations[1], animations[2], animations[3]);
            }
            if ((fragments = fragmentManager.getFragments()) != null && !fragments.isEmpty()) {
                for (Fragment fragment : fragments) {
                    fragmentTransaction.hide(fragment);
                }
            }
            if ((xPageFragment = (XPageFragment)fragmentManager.findFragmentByTag(pageName)) == null) {
                xPageFragment = this.loadXPageFragmentByCorePage(corePage, pageName, bundle);
                fragmentTransaction.add(R.id.fragment_container, (Fragment)xPageFragment, pageName);
            } else {
                fragmentTransaction.show((Fragment)xPageFragment);
            }
            if (addToBackStack) {
                fragmentTransaction.addToBackStack(pageName);
            }
            fragmentTransaction.commitAllowingStateLoss();
        }
        catch (Exception e) {
            e.printStackTrace();
            PageLog.d("Fragment.error:" + e.getMessage());
            return null;
        }
        return xPageFragment;
    }

    private XPageFragment loadXPageFragmentByCorePage(CorePage corePage, String pageName, Bundle bundle) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        XPageFragment fragment;
        if (CoreConfig.isOpenAtlas()) {
            ClassLoader bundleClassLoader = CoreConfig.getBundleClassLoader();
            if (bundleClassLoader == null) {
                PageLog.d("OpenAtlas bundle ClassLoader is null!");
                return null;
            }
            fragment = (XPageFragment)((Object)CoreConfig.getBundleClassLoader().loadClass(corePage.getClazz()).newInstance());
        } else {
            fragment = (XPageFragment)((Object)Class.forName(corePage.getClazz()).newInstance());
        }
        Bundle pageBundle = this.buildBundle(corePage);
        if (bundle != null) {
            pageBundle.putAll(bundle);
        }
        fragment.setArguments(pageBundle);
        fragment.setPageName(pageName);
        return fragment;
    }

    private Bundle buildBundle(CorePage corePage) {
        Map params;
        Bundle bundle = new Bundle();
        if (corePage != null && corePage.getParams() != null && (params = (Map)GsonUtils.fromJson((String)corePage.getParams(), (Type)new TypeToken<Map<String, Object>>(){}.getType())) != null && !params.isEmpty()) {
            Set keySet = params.keySet();
            for (String key : keySet) {
                bundle.putString(key, String.valueOf(params.get(key)));
            }
        }
        return bundle;
    }

    public boolean isFragmentTop(Context context, String fragmentTag) {
        if (context instanceof CoreSwitcher) {
            return ((CoreSwitcher)context).isFragmentTop(fragmentTag);
        }
        XPageActivity topActivity = XPageActivity.getTopActivity();
        return topActivity != null && topActivity.isFragmentTop(fragmentTag);
    }
}

