/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xpage.logger;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.xuexiang.xpage.logger.ILogger;
import com.xuexiang.xpage.logger.LogcatLogger;

public final class PageLog {
    public static final String DEFAULT_LOG_TAG = "[PageLog]";
    private static final int MAX_LOG_PRIORITY = 10;
    private static final int MIN_LOG_PRIORITY = 0;
    private static ILogger sILogger = new LogcatLogger();
    private static String sTag = "[PageLog]";
    private static boolean sIsDebug = false;
    private static int sLogPriority = 10;

    public static void setLogger(@NonNull ILogger logger) {
        sILogger = logger;
    }

    public static void setTag(String tag) {
        sTag = tag;
    }

    public static void setDebug(boolean isDebug) {
        sIsDebug = isDebug;
    }

    public static void setPriority(int priority) {
        sLogPriority = priority;
    }

    public static void debug(boolean isDebug) {
        if (isDebug) {
            PageLog.debug(DEFAULT_LOG_TAG);
        } else {
            PageLog.debug("");
        }
    }

    public static void debug(String tag) {
        if (!TextUtils.isEmpty((CharSequence)tag)) {
            PageLog.setDebug(true);
            PageLog.setPriority(0);
            PageLog.setTag(tag);
        } else {
            PageLog.setDebug(false);
            PageLog.setPriority(10);
            PageLog.setTag("");
        }
    }

    public static void v(String msg) {
        if (PageLog.enableLog(2)) {
            sILogger.log(2, sTag, msg, null);
        }
    }

    public static void vTag(String tag, String msg) {
        if (PageLog.enableLog(2)) {
            sILogger.log(2, tag, msg, null);
        }
    }

    public static void d(String msg) {
        if (PageLog.enableLog(3)) {
            sILogger.log(3, sTag, msg, null);
        }
    }

    public static void dTag(String tag, String msg) {
        if (PageLog.enableLog(3)) {
            sILogger.log(3, tag, msg, null);
        }
    }

    public static void i(String msg) {
        if (PageLog.enableLog(4)) {
            sILogger.log(4, sTag, msg, null);
        }
    }

    public static void iTag(String tag, String msg) {
        if (PageLog.enableLog(4)) {
            sILogger.log(4, tag, msg, null);
        }
    }

    public static void w(String msg) {
        if (PageLog.enableLog(5)) {
            sILogger.log(5, sTag, msg, null);
        }
    }

    public static void wTag(String tag, String msg) {
        if (PageLog.enableLog(5)) {
            sILogger.log(5, tag, msg, null);
        }
    }

    public static void e(String msg) {
        if (PageLog.enableLog(6)) {
            sILogger.log(6, sTag, msg, null);
        }
    }

    public static void eTag(String tag, String msg) {
        if (PageLog.enableLog(6)) {
            sILogger.log(6, tag, msg, null);
        }
    }

    public static void e(Throwable t) {
        if (PageLog.enableLog(6)) {
            sILogger.log(6, sTag, null, t);
        }
    }

    public static void eTag(String tag, Throwable t) {
        if (PageLog.enableLog(6)) {
            sILogger.log(6, tag, null, t);
        }
    }

    public static void e(String msg, Throwable t) {
        if (PageLog.enableLog(6)) {
            sILogger.log(6, sTag, msg, t);
        }
    }

    public static void eTag(String tag, String msg, Throwable t) {
        if (PageLog.enableLog(6)) {
            sILogger.log(6, tag, msg, t);
        }
    }

    public static void wtf(String msg) {
        if (PageLog.enableLog(7)) {
            sILogger.log(7, sTag, msg, null);
        }
    }

    public static void wtfTag(String tag, String msg) {
        if (PageLog.enableLog(7)) {
            sILogger.log(7, tag, msg, null);
        }
    }

    private static boolean enableLog(int logPriority) {
        return sILogger != null && sIsDebug && logPriority >= sLogPriority;
    }

    public static boolean debuggable() {
        return sIsDebug;
    }
}

