/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xpage.utils;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import androidx.fragment.app.Fragment;
import com.xuexiang.xpage.R;
import com.xuexiang.xpage.utils.TitleBar;
import com.xuexiang.xpage.utils.Utils;

public final class TitleUtils {
    private TitleUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static TitleBar initTitleBar(final Activity activity, int titleBarResId, String title) {
        TitleBar titleBar = (TitleBar)activity.findViewById(titleBarResId);
        TitleUtils.initTitleBarStyle(titleBar, title, new View.OnClickListener(){

            public void onClick(View view) {
                activity.finish();
            }
        });
        return titleBar;
    }

    public static TitleBar initTitleBar(ViewGroup viewGroup, int titleBarResId, String title, View.OnClickListener listener) {
        TitleBar titleBar = (TitleBar)viewGroup.findViewById(titleBarResId);
        TitleUtils.initTitleBarStyle(titleBar, title, listener);
        return titleBar;
    }

    public static TitleBar addTitleBarDynamic(final Activity activity, String title) {
        TitleBar titleBar = TitleUtils.initTitleBarDynamic((Context)activity, title, new View.OnClickListener(){

            public void onClick(View view) {
                activity.finish();
            }
        });
        TitleUtils.getRootView(activity).addView((View)titleBar, 0);
        return titleBar;
    }

    public static TitleBar addTitleBarDynamic(ViewGroup viewGroup, String title, View.OnClickListener listener) {
        TitleBar titleBar = TitleUtils.initTitleBarDynamic(viewGroup.getContext(), title, listener);
        viewGroup.addView((View)titleBar, 0);
        return titleBar;
    }

    public static TitleBar initTitleBarDynamic(final Fragment fragment, String title) {
        TitleBar titleBar = TitleUtils.initTitleBarDynamic(fragment.getContext(), title, new View.OnClickListener(){

            public void onClick(View view) {
                fragment.getActivity().finish();
            }
        });
        return titleBar;
    }

    public static TitleBar addTitleBarDynamic(Fragment fragment, ViewGroup viewGroup, String title) {
        TitleBar titleBar = TitleUtils.initTitleBarDynamic(fragment, title);
        viewGroup.addView((View)titleBar, 0);
        return titleBar;
    }

    public static TitleBar initTitleBarDynamic(Context context, String title, View.OnClickListener listener) {
        TitleBar titleBar = new TitleBar(context);
        RelativeLayout.LayoutParams titleBarParams = new RelativeLayout.LayoutParams(-1, -2);
        titleBarParams.addRule(10);
        titleBar.setLayoutParams((ViewGroup.LayoutParams)titleBarParams);
        TitleUtils.initTitleBarStyle(titleBar, title, listener);
        return titleBar;
    }

    public static ViewGroup getRootView(Activity activity) {
        return (ViewGroup)activity.getWindow().getDecorView().findViewById(0x1020002);
    }

    public static TitleBar initTitleBarStyle(TitleBar titleBar, String title, View.OnClickListener listener) {
        titleBar.setLeftImageDrawable(Utils.resolveDrawable(titleBar.getContext(), R.attr.xpage_actionbar_navigation_back, Utils.getVectorDrawable(titleBar.getContext(), R.drawable.xpage_ic_navigation_back_white))).setLeftClickListener(listener).setTitle(title);
        return titleBar;
    }
}

