/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xpage;

import android.content.Context;
import com.xuexiang.xpage.PageConfiguration;
import com.xuexiang.xpage.logger.PageLog;
import com.xuexiang.xpage.model.PageInfo;
import com.xuexiang.xpage.utils.ClassUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class AutoPageConfiguration
implements PageConfiguration {
    private static final String PAGE_CONFIG_PACKAGE_NAME = "com.xuexiang.xpage.config";
    private static final String PAGE_CONFIG_CLASS_NAME_SUFFIX = "PageConfig";

    @Override
    public List<PageInfo> registerPages(Context context) {
        ArrayList<PageInfo> pageInfos = new ArrayList<PageInfo>();
        Set<String> classSet = null;
        try {
            classSet = ClassUtils.getClassNames(context, PAGE_CONFIG_PACKAGE_NAME);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (classSet != null) {
            for (String className : classSet) {
                if (className == null || !className.endsWith(PAGE_CONFIG_CLASS_NAME_SUFFIX)) continue;
                try {
                    pageInfos.addAll(this.getPagesByClass(Class.forName(className)));
                }
                catch (Exception e) {
                    PageLog.e(e);
                }
            }
        }
        return pageInfos;
    }

    private List<PageInfo> getPagesByClass(Class<?> clazz) throws Exception {
        Method getInstanceMethod = clazz.getDeclaredMethod("getInstance", new Class[0]);
        getInstanceMethod.setAccessible(true);
        Object instance = getInstanceMethod.invoke(null, null);
        Method getPagesMethod = clazz.getDeclaredMethod("getPages", null);
        getPagesMethod.setAccessible(true);
        return (List)getPagesMethod.invoke(instance, null);
    }
}

