/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xpage.utils;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import androidx.annotation.AttrRes;
import androidx.annotation.ColorInt;
import androidx.annotation.DimenRes;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.StyleableRes;
import androidx.appcompat.content.res.AppCompatResources;
import com.xuexiang.xpage.core.CoreSwitchBean;
import com.xuexiang.xpage.core.PageOption;

public final class Utils {
    private Utils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    private static Resources getResources(Context context) {
        return context.getResources();
    }

    public static int getDimensionPixelOffset(Context context, @DimenRes int resId) {
        return Utils.getResources(context).getDimensionPixelOffset(resId);
    }

    public static int getDimensionPixelSize(Context context, @DimenRes int resId) {
        return Utils.getResources(context).getDimensionPixelSize(resId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int resolveDimension(Context context, @AttrRes int attr2, int fallback) {
        TypedArray a = context.getTheme().obtainStyledAttributes(new int[]{attr2});
        try {
            int n = a.getDimensionPixelSize(0, fallback);
            return n;
        }
        finally {
            a.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ColorInt
    public static int resolveColor(Context context, @AttrRes int attr2, int fallback) {
        TypedArray a = context.getTheme().obtainStyledAttributes(new int[]{attr2});
        try {
            int n = a.getColor(0, fallback);
            return n;
        }
        finally {
            a.recycle();
        }
    }

    public static int dp2px(Context context, float dpValue) {
        float scale = Utils.getResources((Context)context).getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    public static int px2sp(Context context, float pxValue) {
        float fontScale = context.getResources().getDisplayMetrics().scaledDensity;
        return (int)(pxValue / fontScale + 0.5f);
    }

    public static Drawable getDrawable(Context context, @DrawableRes int resId) {
        if (Build.VERSION.SDK_INT >= 21) {
            return context.getDrawable(resId);
        }
        return context.getResources().getDrawable(resId);
    }

    public static CoreSwitchBean toSwitch(@NonNull PageOption pageOption) {
        CoreSwitchBean page = new CoreSwitchBean(pageOption.getPageName(), pageOption.getBundle(), pageOption.getAnim(), pageOption.isAddToBackStack(), pageOption.isNewActivity());
        page.setRequestCode(pageOption.getRequestCode());
        page.setContainActivityClassName(pageOption.getContainActivityClassName());
        return page;
    }

    public static boolean isShouldHideInput(Window window, MotionEvent event) {
        if (window == null || event == null) {
            return false;
        }
        if (!(window.getCurrentFocus() instanceof EditText)) {
            return false;
        }
        View decorView = window.getDecorView();
        if (decorView instanceof ViewGroup) {
            return Utils.findTouchEditText((ViewGroup)decorView, event) == null;
        }
        return false;
    }

    private static View findTouchEditText(ViewGroup viewGroup, MotionEvent event) {
        if (viewGroup == null) {
            return null;
        }
        for (int i = 0; i < viewGroup.getChildCount(); ++i) {
            View child = viewGroup.getChildAt(i);
            if (child == null || !child.isShown() || !Utils.isTouchView(child, event)) continue;
            if (child instanceof EditText) {
                return child;
            }
            if (!(child instanceof ViewGroup)) continue;
            return Utils.findTouchEditText((ViewGroup)child, event);
        }
        return null;
    }

    private static boolean isTouchView(View view, MotionEvent event) {
        if (view == null || event == null) {
            return false;
        }
        int[] location = new int[2];
        view.getLocationOnScreen(location);
        int left = location[0];
        int top = location[1];
        int right = left + view.getMeasuredWidth();
        int bottom = top + view.getMeasuredHeight();
        return event.getY() >= (float)top && event.getY() <= (float)bottom && event.getX() >= (float)left && event.getX() <= (float)right;
    }

    public static void hideSoftInput(View view) {
        if (view == null) {
            return;
        }
        InputMethodManager imm = (InputMethodManager)view.getContext().getSystemService("input_method");
        if (imm == null) {
            return;
        }
        imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
    }

    public static void hideSoftInputClearFocus(View view) {
        if (view == null) {
            return;
        }
        InputMethodManager imm = (InputMethodManager)view.getContext().getSystemService("input_method");
        if (imm == null) {
            return;
        }
        imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
        if (view instanceof EditText) {
            view.clearFocus();
        }
    }

    public static <T> T checkNotNull(T t, String message) {
        if (t == null) {
            throw new NullPointerException(message);
        }
        return t;
    }

    public static Drawable getDrawableAttrRes(Context context, TypedArray typedArray, @StyleableRes int index) {
        if (Build.VERSION.SDK_INT >= 21) {
            return typedArray.getDrawable(index);
        }
        int resourceId = typedArray.getResourceId(index, -1);
        if (resourceId != -1) {
            return AppCompatResources.getDrawable((Context)context, (int)resourceId);
        }
        return null;
    }

    public static Drawable resolveDrawable(Context context, @AttrRes int attr2) {
        return Utils.resolveDrawable(context, attr2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Drawable resolveDrawable(Context context, @AttrRes int attr2, Drawable fallback) {
        TypedArray array = context.getTheme().obtainStyledAttributes(new int[]{attr2});
        try {
            Drawable drawable2 = null;
            if (Build.VERSION.SDK_INT >= 21) {
                drawable2 = array.getDrawable(0);
            } else {
                int id2 = array.getResourceId(0, -1);
                if (id2 != -1) {
                    drawable2 = AppCompatResources.getDrawable((Context)context, (int)id2);
                }
            }
            if (drawable2 == null && fallback != null) {
                drawable2 = fallback;
            }
            Drawable drawable3 = drawable2;
            return drawable3;
        }
        finally {
            array.recycle();
        }
    }

    public static Drawable getVectorDrawable(Context context, @DrawableRes int resId) {
        if (Build.VERSION.SDK_INT >= 21) {
            return context.getDrawable(resId);
        }
        return AppCompatResources.getDrawable((Context)context, (int)resId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean resolveBoolean(Context context, @AttrRes int attr2, boolean fallback) {
        TypedArray a = context.getTheme().obtainStyledAttributes(new int[]{attr2});
        try {
            boolean bl = a.getBoolean(0, fallback);
            return bl;
        }
        finally {
            a.recycle();
        }
    }

    public static boolean resolveBoolean(Context context, @AttrRes int attr2) {
        return Utils.resolveBoolean(context, attr2, false);
    }
}

