/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xpage.utils;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.AttrRes;
import android.support.annotation.ColorInt;
import android.support.annotation.DimenRes;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.StyleableRes;
import android.support.v7.content.res.AppCompatResources;
import android.view.MotionEvent;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import com.xuexiang.xpage.core.CoreSwitchBean;
import com.xuexiang.xpage.core.PageOption;

public final class Utils {
    private Utils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    private static Resources getResources(Context context) {
        return context.getResources();
    }

    public static int getDimensionPixelOffset(Context context, @DimenRes int resId) {
        return Utils.getResources(context).getDimensionPixelOffset(resId);
    }

    public static int getDimensionPixelSize(Context context, @DimenRes int resId) {
        return Utils.getResources(context).getDimensionPixelSize(resId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int resolveDimension(Context context, @AttrRes int attr2, int fallback) {
        TypedArray a = context.getTheme().obtainStyledAttributes(new int[]{attr2});
        try {
            int n = a.getDimensionPixelSize(0, fallback);
            return n;
        }
        finally {
            a.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ColorInt
    public static int resolveColor(Context context, @AttrRes int attr2, int fallback) {
        TypedArray a = context.getTheme().obtainStyledAttributes(new int[]{attr2});
        try {
            int n = a.getColor(0, fallback);
            return n;
        }
        finally {
            a.recycle();
        }
    }

    public static int dp2px(Context context, float dpValue) {
        float scale = Utils.getResources((Context)context).getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    public static int px2sp(Context context, float pxValue) {
        float fontScale = context.getResources().getDisplayMetrics().scaledDensity;
        return (int)(pxValue / fontScale + 0.5f);
    }

    public static Drawable getDrawable(Context context, @DrawableRes int resId) {
        if (Build.VERSION.SDK_INT >= 21) {
            return context.getDrawable(resId);
        }
        return context.getResources().getDrawable(resId);
    }

    public static CoreSwitchBean toSwitch(@NonNull PageOption pageOption) {
        CoreSwitchBean page = new CoreSwitchBean(pageOption.getPageName(), pageOption.getBundle(), pageOption.getAnim(), pageOption.isAddToBackStack(), pageOption.isNewActivity());
        page.setRequestCode(pageOption.getRequestCode());
        page.setContainActivityClassName(pageOption.getContainActivityClassName());
        return page;
    }

    public static boolean isShouldHideInput(View v, MotionEvent event) {
        if (v != null && v instanceof EditText) {
            int[] leftTop = new int[]{0, 0};
            v.getLocationOnScreen(leftTop);
            int left = leftTop[0];
            int top = leftTop[1];
            int bottom = top + v.getHeight();
            int right = left + v.getWidth();
            return !(event.getRawX() > (float)left && event.getRawX() < (float)right && event.getRawY() > (float)top && event.getRawY() < (float)bottom);
        }
        return false;
    }

    public static void hideSoftInput(View view) {
        if (view == null) {
            return;
        }
        InputMethodManager imm = (InputMethodManager)view.getContext().getSystemService("input_method");
        if (imm == null) {
            return;
        }
        imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
    }

    public static <T> T checkNotNull(T t, String message) {
        if (t == null) {
            throw new NullPointerException(message);
        }
        return t;
    }

    public static Drawable getDrawableAttrRes(Context context, TypedArray typedArray, @StyleableRes int index) {
        if (Build.VERSION.SDK_INT >= 21) {
            return typedArray.getDrawable(index);
        }
        int resourceId = typedArray.getResourceId(index, -1);
        if (resourceId != -1) {
            return AppCompatResources.getDrawable((Context)context, (int)resourceId);
        }
        return null;
    }

    public static Drawable resolveDrawable(Context context, @AttrRes int attr2) {
        return Utils.resolveDrawable(context, attr2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Drawable resolveDrawable(Context context, @AttrRes int attr2, Drawable fallback) {
        TypedArray array = context.getTheme().obtainStyledAttributes(new int[]{attr2});
        try {
            Drawable drawable2 = null;
            if (Build.VERSION.SDK_INT >= 21) {
                drawable2 = array.getDrawable(0);
            } else {
                int id2 = array.getResourceId(0, -1);
                if (id2 != -1) {
                    drawable2 = AppCompatResources.getDrawable((Context)context, (int)id2);
                }
            }
            if (drawable2 == null && fallback != null) {
                drawable2 = fallback;
            }
            Drawable drawable3 = drawable2;
            return drawable3;
        }
        finally {
            array.recycle();
        }
    }

    public static Drawable getVectorDrawable(Context context, @DrawableRes int resId) {
        if (Build.VERSION.SDK_INT >= 21) {
            return context.getDrawable(resId);
        }
        return AppCompatResources.getDrawable((Context)context, (int)resId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean resolveBoolean(Context context, @AttrRes int attr2, boolean fallback) {
        TypedArray a = context.getTheme().obtainStyledAttributes(new int[]{attr2});
        try {
            boolean bl = a.getBoolean(0, fallback);
            return bl;
        }
        finally {
            a.recycle();
        }
    }

    public static boolean resolveBoolean(Context context, @AttrRes int attr2) {
        return Utils.resolveBoolean(context, attr2, false);
    }
}

