/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xpage.base;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import butterknife.ButterKnife;
import butterknife.Unbinder;
import com.squareup.leakcanary.RefWatcher;
import com.xuexiang.xpage.PageConfig;
import com.xuexiang.xpage.base.XPageActivity;
import com.xuexiang.xpage.core.CoreSwitchBean;
import com.xuexiang.xpage.core.CoreSwitcher;
import com.xuexiang.xpage.core.PageOption;
import com.xuexiang.xpage.enums.CoreAnim;
import com.xuexiang.xpage.logger.PageLog;
import com.xuexiang.xpage.utils.TitleBar;
import com.xuexiang.xpage.utils.TitleUtils;

public abstract class XPageFragment
extends Fragment {
    protected Activity mActivity;
    private String mPageName;
    private int mRequestCode;
    private CoreSwitcher mPageCoreSwitcher;
    private OnFragmentFinishListener mFragmentFinishListener;
    private View mRootView;
    private Unbinder mUnbinder;

    public void setFragmentFinishListener(OnFragmentFinishListener listener) {
        this.mFragmentFinishListener = listener;
    }

    public void setFragmentResult(int resultCode, Intent intent) {
        if (this.mFragmentFinishListener != null) {
            this.mFragmentFinishListener.onFragmentResult(this.mRequestCode, resultCode, intent);
        }
    }

    public int getRequestCode() {
        return this.mRequestCode;
    }

    public void setRequestCode(int code) {
        this.mRequestCode = code;
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        return false;
    }

    public void onFragmentDataReset(Bundle bundle) {
    }

    public void popToBackForResult(PopCallback callback) {
        this.popToBack(null, null);
        callback.run();
    }

    public void popToBack() {
        this.popToBack(null, null);
    }

    public final void popToBack(String pageName, Bundle bundle) {
        CoreSwitcher coreSwitcher = this.getSwitcher();
        if (coreSwitcher != null) {
            if (pageName == null) {
                coreSwitcher.popPage();
            } else if (this.findPage(pageName)) {
                CoreSwitchBean page = new CoreSwitchBean(pageName, bundle);
                coreSwitcher.gotoPage(page);
            } else {
                coreSwitcher.popPage();
            }
        } else {
            PageLog.d("pageSwitcher null");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CoreSwitcher getSwitcher() {
        XPageFragment xPageFragment = this;
        synchronized (xPageFragment) {
            if (this.mPageCoreSwitcher == null) {
                XPageActivity topActivity;
                if (this.mActivity != null && this.mActivity instanceof CoreSwitcher) {
                    this.mPageCoreSwitcher = (CoreSwitcher)this.mActivity;
                }
                if (this.mPageCoreSwitcher == null && (topActivity = XPageActivity.getTopActivity()) != null) {
                    this.mPageCoreSwitcher = topActivity;
                }
            }
        }
        return this.mPageCoreSwitcher;
    }

    public XPageFragment setSwitcher(CoreSwitcher pageCoreSwitcher) {
        this.mPageCoreSwitcher = pageCoreSwitcher;
        return this;
    }

    public boolean findPage(String pageName) {
        if (pageName == null) {
            PageLog.d("pageName is null");
            return false;
        }
        CoreSwitcher coreSwitcher = this.getSwitcher();
        if (coreSwitcher != null) {
            return coreSwitcher.findPage(pageName);
        }
        PageLog.d("pageSwitch is null");
        return false;
    }

    public boolean isFragmentTop(String fragmentTag) {
        CoreSwitcher pageCoreSwitcher = this.getSwitcher();
        if (pageCoreSwitcher != null) {
            return pageCoreSwitcher.isFragmentTop(fragmentTag);
        }
        PageLog.d("pageSwitcher is null");
        return false;
    }

    public void onFragmentResult(int requestCode, int resultCode, Intent data) {
        PageLog.d("onFragmentResult from baseFragment\uff1arequestCode-" + requestCode + "  resultCode-" + resultCode);
    }

    public <T extends XPageFragment> T openPage(Class<T> clazz) {
        return (T)((Object)((XPageFragment)this.openPage(PageConfig.getPageInfo(clazz).getName(), null, PageConfig.getPageInfo(clazz).getAnim())));
    }

    public <T extends XPageFragment> T openPage(Class<T> clazz, boolean addToBackStack) {
        return (T)((Object)((XPageFragment)this.openPage(PageConfig.getPageInfo(clazz).getName(), null, PageConfig.getPageInfo(clazz).getAnim(), addToBackStack)));
    }

    public <T extends XPageFragment> T openPage(Class<T> clazz, Bundle bundle) {
        return (T)((Object)((XPageFragment)this.openPage(PageConfig.getPageInfo(clazz).getName(), bundle, PageConfig.getPageInfo(clazz).getAnim())));
    }

    public <T extends XPageFragment> T openPage(Class<T> clazz, Bundle bundle, CoreAnim coreAnim) {
        return (T)((Object)((XPageFragment)this.openPage(PageConfig.getPageInfo(clazz).getName(), bundle, coreAnim)));
    }

    public Fragment openPage(String pageName) {
        return this.openPage(pageName, null, CoreAnim.slide);
    }

    public Fragment openPage(String pageName, Bundle bundle) {
        return this.openPage(pageName, bundle, CoreAnim.slide);
    }

    public final Fragment openPage(String pageName, Bundle bundle, CoreAnim coreAnim) {
        return this.openPage(pageName, bundle, CoreSwitchBean.convertAnimations(coreAnim), true);
    }

    public final Fragment openPage(String pageName, Bundle bundle, int[] anim2, boolean addToBackStack) {
        return this.openPage(pageName, bundle, anim2, addToBackStack, false);
    }

    public final Fragment openPage(String pageName, Bundle bundle, int[] anim2, boolean addToBackStack, boolean newActivity) {
        if (pageName == null) {
            PageLog.d("pageName is null");
            return null;
        }
        CoreSwitcher coreSwitcher = this.getSwitcher();
        if (coreSwitcher != null) {
            CoreSwitchBean page = new CoreSwitchBean(pageName, bundle, anim2, addToBackStack, newActivity);
            return coreSwitcher.openPage(page);
        }
        PageLog.d("pageSwitcher is null");
        return null;
    }

    public final Fragment openPage(String pageName, Bundle bundle, int[] anim2) {
        return this.openPage(pageName, bundle, anim2, true);
    }

    public final Fragment openPage(String pageName, Bundle bundle, CoreAnim coreAnim, boolean addToBackStack) {
        return this.openPage(pageName, bundle, CoreSwitchBean.convertAnimations(coreAnim), addToBackStack, false);
    }

    public final Fragment openPage(String pageName, Bundle bundle, CoreAnim coreAnim, boolean addToBackStack, boolean newActivity) {
        return this.openPage(pageName, bundle, CoreSwitchBean.convertAnimations(coreAnim), addToBackStack, newActivity);
    }

    public Fragment gotoPage(String pageName, Bundle bundle, CoreAnim coreAnim) {
        return this.gotoPage(pageName, bundle, coreAnim, false);
    }

    public Fragment gotoPage(String pageName, Bundle bundle, CoreAnim coreAnim, boolean newActivity) {
        CoreSwitcher pageCoreSwitcher = this.getSwitcher();
        if (pageCoreSwitcher != null) {
            CoreSwitchBean page = new CoreSwitchBean(pageName, bundle, coreAnim, true, newActivity);
            return pageCoreSwitcher.gotoPage(page);
        }
        PageLog.d("pageSwitcher is null");
        return null;
    }

    public final <T extends XPageFragment> T openPageForResult(Class<T> clazz, Bundle bundle, int requestCode) {
        return (T)((Object)((XPageFragment)this.openPageForResult(false, PageConfig.getPageInfo(clazz).getName(), bundle, PageConfig.getPageInfo(clazz).getAnim(), requestCode)));
    }

    public final Fragment openPageForResult(String pageName, Bundle bundle, CoreAnim coreAnim, int requestCode) {
        return this.openPageForResult(false, pageName, bundle, coreAnim, requestCode);
    }

    public final Fragment openPageForResult(boolean newActivity, String pageName, Bundle bundle, CoreAnim coreAnim, int requestCode) {
        return this.openPageForResult(newActivity, pageName, bundle, CoreSwitchBean.convertAnimations(coreAnim), requestCode);
    }

    public final Fragment openPageForResult(boolean newActivity, String pageName, Bundle bundle, int[] coreAnim, int requestCode) {
        CoreSwitcher pageCoreSwitcher = this.getSwitcher();
        if (pageCoreSwitcher != null) {
            CoreSwitchBean page = new CoreSwitchBean(pageName, bundle, coreAnim, true, newActivity);
            page.setRequestCode(requestCode);
            return pageCoreSwitcher.openPageForResult(page, this);
        }
        PageLog.d("pageSwitcher is null");
        return null;
    }

    public final Fragment openPage(@NonNull PageOption pageOption) {
        CoreSwitcher switcher = this.getSwitcher();
        if (switcher != null) {
            CoreSwitchBean page = pageOption.toSwitch();
            if (pageOption.isOpenForResult()) {
                page.setAddToBackStack(true);
                return switcher.openPageForResult(page, this);
            }
            return switcher.openPage(page);
        }
        PageLog.d("pageSwitcher is null");
        return null;
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        this.mActivity = activity;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.getPageName() != null) {
            PageLog.d("====Fragment.onCreate====" + this.getPageName());
        }
    }

    @LayoutRes
    protected abstract int getLayoutId();

    protected String getPageTitle() {
        return PageConfig.getPageInfo(((Object)((Object)this)).getClass()).getName();
    }

    protected void initArgs() {
    }

    protected abstract void initViews();

    protected abstract void initListeners();

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.mRootView = inflater.inflate(this.getLayoutId(), container, false);
        this.mUnbinder = ButterKnife.bind((Object)((Object)this), (View)this.mRootView);
        this.initArgs();
        this.initPage();
        return this.mRootView;
    }

    protected void initPage() {
        this.initTitleBar();
        this.initViews();
        this.initListeners();
    }

    protected TitleBar initTitleBar() {
        return TitleUtils.addTitleBarDynamic((ViewGroup)this.mRootView, this.getPageTitle(), new View.OnClickListener(){

            public void onClick(View v) {
                XPageFragment.this.popToBack();
            }
        });
    }

    public void onDestroyView() {
        if (this.mUnbinder != null) {
            this.mUnbinder.unbind();
        }
        super.onDestroyView();
    }

    public void onDestroy() {
        super.onDestroy();
        if (PageConfig.getInstance().isEnableWatcher()) {
            RefWatcher refWatcher = PageConfig.getInstance().getRefWatcher();
            refWatcher.watch((Object)this);
        }
    }

    public View getRootView() {
        return this.mRootView;
    }

    public String getPageName() {
        return this.mPageName;
    }

    public void setPageName(String pageName) {
        this.mPageName = pageName;
    }

    public void onDetach() {
        super.onDetach();
        this.mActivity = null;
    }

    protected <T extends View> T findViewById(int id2) {
        return (T)this.mRootView.findViewById(id2);
    }

    public static interface OnFragmentFinishListener {
        public void onFragmentResult(int var1, int var2, Intent var3);
    }

    public static interface PopCallback {
        public void run();
    }
}

