/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xpage.core;

import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import com.xuexiang.xpage.PageConfig;
import com.xuexiang.xpage.base.XPageFragment;
import com.xuexiang.xpage.core.CoreSwitchBean;
import com.xuexiang.xpage.enums.CoreAnim;
import com.xuexiang.xpage.model.PageInfo;
import java.util.Arrays;

public class PageOption {
    private String mPageName;
    private Bundle mBundle = null;
    private int[] mAnim = null;
    private boolean mAddToBackStack = true;
    private boolean mNewActivity = false;
    private int mRequestCode = -1;

    public PageOption(String pageName) {
        this.mPageName = pageName;
    }

    public <T extends XPageFragment> PageOption(Class<T> clazz) {
        PageInfo pageInfo = PageConfig.getPageInfo(clazz);
        this.mPageName = pageInfo.getName();
        this.setAnim(pageInfo.getAnim());
    }

    public PageOption(String pageName, Bundle bundle) {
        this.mPageName = pageName;
        this.mBundle = bundle;
    }

    public PageOption(String pageName, Bundle bundle, boolean addToBackStack) {
        this.mPageName = pageName;
        this.mBundle = bundle;
        this.mAddToBackStack = addToBackStack;
    }

    public PageOption(String pageName, Bundle bundle, int[] anim2, boolean addToBackStack, boolean newActivity, int requestCode) {
        this.mPageName = pageName;
        this.mBundle = bundle;
        this.setAnim(anim2);
        this.mAddToBackStack = addToBackStack;
        this.mNewActivity = newActivity;
        this.mRequestCode = requestCode;
    }

    public PageOption(String pageName, Bundle bundle, CoreAnim anim2, boolean addToBackStack, boolean newActivity, int requestCode) {
        this.mPageName = pageName;
        this.mBundle = bundle;
        this.setAnim(anim2);
        this.mAddToBackStack = addToBackStack;
        this.mNewActivity = newActivity;
        this.mRequestCode = requestCode;
    }

    public String getPageName() {
        return this.mPageName;
    }

    public PageOption setPageName(String pageName) {
        this.mPageName = pageName;
        return this;
    }

    public Bundle getBundle() {
        return this.mBundle;
    }

    public PageOption setBundle(Bundle bundle) {
        this.mBundle = bundle;
        return this;
    }

    public PageOption putString(@Nullable String key, @Nullable String value) {
        if (this.mBundle == null) {
            this.mBundle = new Bundle();
        }
        this.mBundle.putString(key, value);
        return this;
    }

    public PageOption putBoolean(@Nullable String key, boolean value) {
        if (this.mBundle == null) {
            this.mBundle = new Bundle();
        }
        this.mBundle.putBoolean(key, value);
        return this;
    }

    public PageOption putInt(@Nullable String key, int value) {
        if (this.mBundle == null) {
            this.mBundle = new Bundle();
        }
        this.mBundle.putInt(key, value);
        return this;
    }

    public PageOption putFloat(@Nullable String key, float value) {
        if (this.mBundle == null) {
            this.mBundle = new Bundle();
        }
        this.mBundle.putFloat(key, value);
        return this;
    }

    public PageOption putDouble(@Nullable String key, double value) {
        if (this.mBundle == null) {
            this.mBundle = new Bundle();
        }
        this.mBundle.putDouble(key, value);
        return this;
    }

    public int[] getAnim() {
        return this.mAnim;
    }

    public PageOption setAnim(int[] anim2) {
        this.mAnim = anim2;
        return this;
    }

    public PageOption setAnim(CoreAnim anim2) {
        this.mAnim = CoreSwitchBean.convertAnimations(anim2);
        return this;
    }

    public boolean isAddToBackStack() {
        return this.mAddToBackStack;
    }

    public PageOption setAddToBackStack(boolean addToBackStack) {
        this.mAddToBackStack = addToBackStack;
        return this;
    }

    public boolean isNewActivity() {
        return this.mNewActivity;
    }

    public PageOption setNewActivity(boolean newActivity) {
        this.mNewActivity = newActivity;
        return this;
    }

    public int getRequestCode() {
        return this.mRequestCode;
    }

    public boolean isOpenForResult() {
        return this.mRequestCode != -1;
    }

    public PageOption setRequestCode(int requestCode) {
        this.mRequestCode = requestCode;
        return this;
    }

    public Fragment open(@NonNull XPageFragment fragment) {
        return fragment.openPage(this);
    }

    public Fragment openForResult(@NonNull XPageFragment fragment, int requestCode) {
        this.setRequestCode(requestCode);
        return fragment.openPage(this);
    }

    public String toString() {
        return "PageOption{mPageName='" + this.mPageName + '\'' + ", mBundle=" + this.mBundle + ", mAnim=" + Arrays.toString(this.mAnim) + ", mAddToBackStack=" + this.mAddToBackStack + ", mNewActivity=" + this.mNewActivity + ", mRequestCode=" + this.mRequestCode + '}';
    }
}

