/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xpage.base;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import com.xuexiang.xpage.PageConfig;
import com.xuexiang.xpage.R;
import com.xuexiang.xpage.base.XPageFragment;
import com.xuexiang.xpage.core.CoreConfig;
import com.xuexiang.xpage.core.CorePageManager;
import com.xuexiang.xpage.core.CoreSwitchBean;
import com.xuexiang.xpage.core.CoreSwitcher;
import com.xuexiang.xpage.enums.CoreAnim;
import com.xuexiang.xpage.logger.PageLog;
import com.xuexiang.xpage.utils.Utils;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.ref.WeakReference;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public class XPageActivity
extends FragmentActivity
implements CoreSwitcher {
    private static List<WeakReference<XPageActivity>> mActivities = new ArrayList<WeakReference<XPageActivity>>();
    protected CoreSwitchBean mFirstCoreSwitchBean;
    private Handler mHandler = null;
    private WeakReference<XPageActivity> mCurrentInstance = null;
    private XPageFragment mFragmentForResult = null;
    private int mFragmentRequestCode = -1;
    private BroadcastReceiver mExitReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("com.xuexiang.xpage.corepage.core.exit".equals(action)) {
                PageLog.d("exit from broadcast");
                XPageActivity.this.finish();
            }
        }
    };

    public static XPageActivity getTopActivity() {
        WeakReference<XPageActivity> ref;
        int size;
        if (mActivities != null && (size = mActivities.size()) >= 1 && (ref = mActivities.get(size - 1)) != null) {
            return (XPageActivity)ref.get();
        }
        return null;
    }

    public static void unInit() {
        if (mActivities != null) {
            mActivities.clear();
        }
    }

    protected String getPageName() {
        XPageFragment frg = this.getActiveFragment();
        if (frg != null) {
            return frg.getPageName();
        }
        return "";
    }

    @Override
    public void popPage() {
        this.popOrFinishActivity();
    }

    private void popOrFinishActivity() {
        if (this.isFinishing()) {
            return;
        }
        if (this.getSupportFragmentManager().getBackStackEntryCount() > 1) {
            if (this.isMainThread()) {
                this.getSupportFragmentManager().popBackStackImmediate();
            } else {
                this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        XPageActivity.this.getSupportFragmentManager().popBackStackImmediate();
                    }
                });
            }
        } else {
            this.finishActivity(this, true);
        }
    }

    private boolean isMainThread() {
        return Thread.currentThread() == Looper.getMainLooper().getThread();
    }

    private void finishActivity(XPageActivity activity, boolean showAnimation) {
        if (activity != null) {
            activity.finish();
            if (this.getIsAddActivityToStack()) {
                mActivities.remove(this.mCurrentInstance);
            }
            if (showAnimation) {
                int[] animations = null;
                if (activity.mFirstCoreSwitchBean != null && activity.mFirstCoreSwitchBean.getAnim() != null) {
                    animations = activity.mFirstCoreSwitchBean.getAnim();
                }
                if (animations != null && animations.length >= 4) {
                    this.overridePendingTransition(animations[2], animations[3]);
                }
            }
        }
    }

    @Override
    public boolean isFragmentTop(String fragmentTag) {
        int count;
        XPageActivity activity;
        FragmentManager manager;
        WeakReference<XPageActivity> ref;
        XPageActivity item;
        int size = mActivities.size();
        if (size > 0 && (item = (XPageActivity)(ref = mActivities.get(size - 1)).get()) != null && item == this && (manager = (activity = item).getSupportFragmentManager()) != null && (count = manager.getBackStackEntryCount()) >= 1) {
            FragmentManager.BackStackEntry entry = manager.getBackStackEntryAt(count - 1);
            return entry.getName().equalsIgnoreCase(fragmentTag);
        }
        return false;
    }

    @Override
    public boolean findPage(String pageName) {
        int size = mActivities.size();
        boolean hasFind = false;
        for (int j = size - 1; j >= 0; --j) {
            WeakReference<XPageActivity> ref = mActivities.get(j);
            if (ref == null) continue;
            XPageActivity item = (XPageActivity)ref.get();
            if (item == null) {
                PageLog.d("item is null");
                continue;
            }
            FragmentManager manager = item.getSupportFragmentManager();
            int count = manager.getBackStackEntryCount();
            for (int i = count - 1; i >= 0; --i) {
                String name = manager.getBackStackEntryAt(i).getName();
                if (!name.equalsIgnoreCase(pageName)) continue;
                hasFind = true;
                break;
            }
            if (hasFind) break;
        }
        return hasFind;
    }

    @Override
    public Fragment gotoPage(CoreSwitchBean page) {
        if (page == null) {
            PageLog.e("page name empty");
            return null;
        }
        String pageName = page.getPageName();
        if (!this.findPage(pageName)) {
            PageLog.d("Be sure you have the right pageName" + pageName);
            return this.openPage(page);
        }
        int size = mActivities.size();
        for (int i = size - 1; i >= 0; --i) {
            WeakReference<XPageActivity> ref = mActivities.get(i);
            if (ref == null) continue;
            XPageActivity item = (XPageActivity)ref.get();
            if (item == null) {
                PageLog.d("item null");
                continue;
            }
            boolean findInActivity = this.popFragmentInActivity(pageName, page.getBundle(), item);
            if (findInActivity) break;
            item.finish();
        }
        return null;
    }

    protected boolean popFragmentInActivity(final String pageName, Bundle bundle, XPageActivity findActivity) {
        Fragment frg;
        if (pageName == null || findActivity == null || findActivity.isFinishing()) {
            return false;
        }
        final FragmentManager fragmentManager = findActivity.getSupportFragmentManager();
        if (fragmentManager != null && (frg = fragmentManager.findFragmentByTag(pageName)) != null && frg instanceof XPageFragment) {
            if (fragmentManager.getBackStackEntryCount() > 1 && this.mHandler != null) {
                this.mHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        fragmentManager.popBackStack(pageName, 0);
                    }
                }, 100L);
            }
            ((XPageFragment)frg).onFragmentDataReset(bundle);
            return true;
        }
        return false;
    }

    public void startActivity(CoreSwitchBean page) {
        try {
            Intent intent = new Intent((Context)this, XPageActivity.class);
            intent.putExtra("SwitchBean", (Parcelable)page);
            this.startActivity(intent);
            int[] animations = page.getAnim();
            if (animations != null && animations.length >= 2) {
                this.overridePendingTransition(animations[0], animations[1]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            PageLog.e(e);
        }
    }

    public void startActivity(Intent intent) {
        if (intent == null) {
            PageLog.e("[startActivity failed]: intent == null");
            return;
        }
        if (this.getPackageManager().resolveActivity(intent, 65536) != null) {
            try {
                super.startActivity(intent);
            }
            catch (Exception e) {
                e.printStackTrace();
                PageLog.e(e);
            }
        } else {
            PageLog.e("[resolveActivity failed]: " + intent.getComponent().getClassName() + " do not register in manifest");
        }
    }

    @Override
    public Fragment openPageForResult(CoreSwitchBean page, XPageFragment fragment) {
        if (page != null) {
            if (page.isNewActivity()) {
                PageLog.d("openPageForResult start new activity-----" + fragment.getPageName());
                this.mFragmentForResult = fragment;
                this.mFragmentRequestCode = page.getRequestCode();
                this.startActivityForResult(page);
                return null;
            }
            String pageName = page.getPageName();
            Bundle bundle = page.getBundle();
            int[] animations = page.getAnim();
            boolean addToBackStack = page.isAddToBackStack();
            XPageFragment frg = CorePageManager.getInstance().openPageWithNewFragmentManager(this.getSupportFragmentManager(), pageName, bundle, animations, addToBackStack);
            if (frg == null) {
                return null;
            }
            final XPageFragment opener = fragment;
            frg.setRequestCode(page.getRequestCode());
            frg.setFragmentFinishListener(new XPageFragment.OnFragmentFinishListener(){

                @Override
                public void onFragmentResult(int requestCode, int resultCode, Intent intent) {
                    opener.onFragmentResult(requestCode, resultCode, intent);
                }
            });
            return frg;
        }
        PageLog.d("openPageForResult.SwitchBean is null");
        return null;
    }

    public void startActivityForResult(CoreSwitchBean page) {
        try {
            Intent intent = new Intent((Context)this, XPageActivity.class);
            intent.putExtra("SwitchBean", (Parcelable)page);
            intent.putExtra("startActivityForResult", true);
            this.startActivityForResult(intent, page.getRequestCode());
            int[] animations = page.getAnim();
            if (animations != null && animations.length >= 2) {
                this.overridePendingTransition(animations[0], animations[1]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void startActivityForResult(Intent intent, int requestCode) {
        if (intent == null) {
            PageLog.e("[startActivity failed]: intent == null");
            return;
        }
        if (this.getPackageManager().resolveActivity(intent, 65536) != null) {
            try {
                super.startActivityForResult(intent, requestCode);
            }
            catch (Exception e) {
                e.printStackTrace();
                PageLog.e(e);
            }
        } else {
            PageLog.e("[resolveActivity failed]: " + intent.getComponent().getClassName() + " do not register in manifest");
        }
    }

    @Override
    public Fragment openPage(CoreSwitchBean page) {
        boolean addToBackStack = page.isAddToBackStack();
        boolean newActivity = page.isNewActivity();
        Bundle bundle = page.getBundle();
        int[] animations = page.getAnim();
        if (newActivity) {
            this.startActivity(page);
            return null;
        }
        String pageName = page.getPageName();
        return CorePageManager.getInstance().openPageWithNewFragmentManager(this.getSupportFragmentManager(), pageName, bundle, animations, addToBackStack);
    }

    @Override
    public Fragment changePage(CoreSwitchBean page) {
        boolean addToBackStack = page.isAddToBackStack();
        boolean newActivity = page.isNewActivity();
        Bundle bundle = page.getBundle();
        int[] animations = page.getAnim();
        if (newActivity) {
            this.startActivity(page);
            return null;
        }
        String pageName = page.getPageName();
        return CorePageManager.getInstance().changePageWithNewFragmentManager(this.getSupportFragmentManager(), pageName, bundle, animations, addToBackStack);
    }

    @Override
    public void removeUnlessFragment(List<String> fragmentLists) {
        if (this.isFinishing()) {
            return;
        }
        FragmentManager manager = this.getSupportFragmentManager();
        if (manager != null) {
            FragmentTransaction transaction = manager.beginTransaction();
            for (String tag : fragmentLists) {
                Fragment fragment = manager.findFragmentByTag(tag);
                if (fragment == null) continue;
                transaction.remove(fragment);
            }
            transaction.commitAllowingStateLoss();
            int count = manager.getBackStackEntryCount();
            if (count == 0) {
                this.finish();
            }
        }
    }

    public Fragment openPage(String pageName) {
        CoreSwitchBean page = new CoreSwitchBean(pageName, null, CoreAnim.slide);
        return this.openPage(page);
    }

    public Fragment openPage(String pageName, Bundle bundle) {
        CoreSwitchBean page = new CoreSwitchBean(pageName, bundle, CoreAnim.slide);
        return this.openPage(page);
    }

    public Fragment openPage(String pageName, Bundle bundle, CoreAnim coreAnim) {
        CoreSwitchBean page = new CoreSwitchBean(pageName, bundle, coreAnim);
        return this.openPage(page);
    }

    public <T extends XPageFragment> T openPage(Class<T> clazz) {
        CoreSwitchBean page = new CoreSwitchBean(PageConfig.getPageInfo(clazz).getName(), null, PageConfig.getPageInfo(clazz).getAnim());
        return (T)((Object)((XPageFragment)this.openPage(page)));
    }

    public <T extends XPageFragment> T openPage(Class<T> clazz, Bundle bundle) {
        CoreSwitchBean page = new CoreSwitchBean(PageConfig.getPageInfo(clazz).getName(), bundle, PageConfig.getPageInfo(clazz).getAnim());
        return (T)((Object)((XPageFragment)this.openPage(page)));
    }

    public Fragment openPage(String pageName, Bundle bundle, CoreAnim coreAnim, boolean addToBackStack, boolean newActivity) {
        CoreSwitchBean page = new CoreSwitchBean(pageName, bundle, coreAnim, addToBackStack, newActivity);
        return this.openPage(page);
    }

    public Fragment openPage(String pageName, Bundle bundle, int[] anim2, boolean addToBackStack, boolean newActivity) {
        CoreSwitchBean page = new CoreSwitchBean(pageName, bundle, anim2, addToBackStack, newActivity);
        return this.openPage(page);
    }

    public Fragment openPage(String pageName, Bundle bundle, CoreAnim coreAnim, boolean addToBackStack) {
        CoreSwitchBean page = new CoreSwitchBean(pageName, bundle, coreAnim, addToBackStack);
        return this.openPage(page);
    }

    public Fragment openPage(String pageName, Bundle bundle, int[] anim2, boolean addToBackStack) {
        CoreSwitchBean page = new CoreSwitchBean(pageName, bundle, anim2, addToBackStack);
        return this.openPage(page);
    }

    public Fragment openPage(String pageName, Bundle bundle, int[] anim2) {
        CoreSwitchBean page = new CoreSwitchBean(pageName, bundle, anim2);
        return this.openPage(page);
    }

    public <T extends XPageFragment> T changePage(Class<T> clazz) {
        CoreSwitchBean page = new CoreSwitchBean(PageConfig.getPageInfo(clazz).getName(), null, PageConfig.getPageInfo(clazz).getAnim()).setAddToBackStack(false);
        return (T)((Object)((XPageFragment)this.changePage(page)));
    }

    public <T extends XPageFragment> T changePage(Class<T> clazz, Bundle bundle) {
        CoreSwitchBean page = new CoreSwitchBean(PageConfig.getPageInfo(clazz).getName(), bundle, PageConfig.getPageInfo(clazz).getAnim()).setAddToBackStack(false);
        return (T)((Object)((XPageFragment)this.changePage(page)));
    }

    public Fragment changePage(String pageName) {
        CoreSwitchBean page = new CoreSwitchBean(pageName, null, CoreAnim.none).setAddToBackStack(false);
        return this.changePage(page);
    }

    public Fragment changePage(String pageName, Bundle bundle) {
        CoreSwitchBean page = new CoreSwitchBean(pageName, bundle, CoreAnim.none).setAddToBackStack(false);
        return this.changePage(page);
    }

    public Fragment changePage(String pageName, Bundle bundle, CoreAnim coreAnim) {
        CoreSwitchBean page = new CoreSwitchBean(pageName, bundle, coreAnim).setAddToBackStack(false);
        return this.changePage(page);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView();
        Intent newIntent = this.getIntent();
        if (savedInstanceState != null) {
            this.loadActivitySavedData(savedInstanceState);
        }
        this.mHandler = new Handler(this.getMainLooper());
        if (this.getIsAddActivityToStack()) {
            this.mCurrentInstance = new WeakReference<XPageActivity>(this);
            mActivities.add(this.mCurrentInstance);
            this.printAllActivities();
        }
        this.init(newIntent);
        if (this.getIsRegisterExitBroadcast()) {
            IntentFilter filter = new IntentFilter();
            filter.addAction("com.xuexiang.xpage.corepage.core.exit");
            filter.addCategory("android.intent.category.DEFAULT");
            CoreConfig.getLocalBroadcastManager().registerReceiver(this.mExitReceiver, filter);
        }
    }

    protected boolean getIsAddActivityToStack() {
        return true;
    }

    protected boolean getIsRegisterExitBroadcast() {
        return true;
    }

    protected void setContentView() {
        int layoutId = this.getLayoutId();
        if (layoutId != -1) {
            this.setContentView(layoutId);
        } else {
            this.setContentView(this.getBaseLayout());
        }
    }

    protected int getLayoutId() {
        return -1;
    }

    protected View getBaseLayout() {
        FrameLayout baseLayout = new FrameLayout((Context)this);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -1);
        baseLayout.setId(R.id.fragment_container);
        baseLayout.setLayoutParams((ViewGroup.LayoutParams)params);
        return baseLayout;
    }

    protected void onDestroy() {
        if (this.getIsRegisterExitBroadcast()) {
            CoreConfig.getLocalBroadcastManager().unregisterReceiver(this.mExitReceiver);
        }
        super.onDestroy();
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        XPageFragment activeFragment = this.getActiveFragment();
        boolean isHandled = false;
        if (activeFragment != null) {
            isHandled = activeFragment.onKeyDown(keyCode, event);
        }
        if (!isHandled) {
            return super.onKeyDown(keyCode, event);
        }
        return isHandled;
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        PageLog.d("onActivityResult from XPageActivity" + requestCode + " " + resultCode);
        if (this.mFragmentRequestCode == requestCode && this.mFragmentForResult != null) {
            this.mFragmentForResult.onFragmentResult(this.mFragmentRequestCode, resultCode, data);
        }
        super.onActivityResult(requestCode, resultCode, data);
    }

    public void onBackPressed() {
        if (this.getSupportFragmentManager().getBackStackEntryCount() == 1) {
            this.finishActivity(this, true);
        } else {
            super.onBackPressed();
        }
    }

    public XPageFragment getActiveFragment() {
        int count;
        if (this.isFinishing()) {
            return null;
        }
        FragmentManager manager = this.getSupportFragmentManager();
        if (manager != null && (count = manager.getBackStackEntryCount()) > 0) {
            String tag = manager.getBackStackEntryAt(count - 1).getName();
            return (XPageFragment)manager.findFragmentByTag(tag);
        }
        return null;
    }

    public <T extends XPageFragment> T getPage(Class<T> clazz) {
        String pageName = PageConfig.getPageInfo(clazz).getName();
        XPageFragment fragment = this.getPageByName(pageName);
        if (fragment != null) {
            return (T)((Object)fragment);
        }
        return null;
    }

    public XPageFragment getPageByName(String pageName) {
        if (this.isFinishing() || TextUtils.isEmpty((CharSequence)pageName)) {
            return null;
        }
        FragmentManager manager = this.getSupportFragmentManager();
        if (manager != null) {
            return (XPageFragment)manager.findFragmentByTag(pageName);
        }
        return null;
    }

    protected void printAllActivities() {
        PageLog.d("------------XPageActivity print all------------activities size:" + mActivities.size());
        for (WeakReference<XPageActivity> ref : mActivities) {
            XPageActivity item;
            if (ref == null || (item = (XPageActivity)ref.get()) == null) continue;
            PageLog.d(item.toString());
        }
    }

    private void init(Intent newIntent) {
        try {
            CoreSwitchBean page = (CoreSwitchBean)newIntent.getParcelableExtra("SwitchBean");
            boolean startActivityForResult = newIntent.getBooleanExtra("startActivityForResult", false);
            this.mFirstCoreSwitchBean = page;
            if (page != null) {
                XPageFragment fragment = null;
                boolean addToBackStack = page.isAddToBackStack();
                String pageName = page.getPageName();
                Bundle bundle = page.getBundle();
                fragment = CorePageManager.getInstance().openPageWithNewFragmentManager(this.getSupportFragmentManager(), pageName, bundle, null, addToBackStack);
                if (fragment != null) {
                    if (startActivityForResult) {
                        fragment.setRequestCode(page.getRequestCode());
                        fragment.setFragmentFinishListener(new XPageFragment.OnFragmentFinishListener(){

                            @Override
                            public void onFragmentResult(int requestCode, int resultCode, Intent intent) {
                                XPageActivity.this.setResult(resultCode, intent);
                            }
                        });
                    }
                } else {
                    this.finish();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            PageLog.e(e);
            this.finish();
        }
    }

    protected void onStop() {
        if (this.isFinishing()) {
            this.onRelease();
        }
        super.onStop();
    }

    protected void onRelease() {
    }

    protected void onSaveInstanceState(Bundle outState) {
        AccessibleObject[] fields = this.getClass().getDeclaredFields();
        Field.setAccessible(fields, true);
        for (AccessibleObject f : fields) {
            Annotation[] ans;
            for (Annotation an : ans = ((Field)f).getDeclaredAnnotations()) {
                if (!(an instanceof SaveWithActivity)) continue;
                try {
                    Object o = ((Field)f).get(this);
                    if (o == null) continue;
                    String fieldName = ((Field)f).getName();
                    if (o instanceof Integer) {
                        outState.putInt(fieldName, ((Field)f).getInt(this));
                        continue;
                    }
                    if (o instanceof String) {
                        outState.putString(fieldName, (String)((Field)f).get(this));
                        continue;
                    }
                    if (o instanceof Long) {
                        outState.putLong(fieldName, ((Field)f).getLong(this));
                        continue;
                    }
                    if (o instanceof Short) {
                        outState.putShort(fieldName, ((Field)f).getShort(this));
                        continue;
                    }
                    if (o instanceof Boolean) {
                        outState.putBoolean(fieldName, ((Field)f).getBoolean(this));
                        continue;
                    }
                    if (o instanceof Byte) {
                        outState.putByte(fieldName, ((Field)f).getByte(this));
                        continue;
                    }
                    if (o instanceof Character) {
                        outState.putChar(fieldName, ((Field)f).getChar(this));
                        continue;
                    }
                    if (o instanceof CharSequence) {
                        outState.putCharSequence(fieldName, (CharSequence)((Field)f).get(this));
                        continue;
                    }
                    if (o instanceof Float) {
                        outState.putFloat(fieldName, ((Field)f).getFloat(this));
                        continue;
                    }
                    if (o instanceof Double) {
                        outState.putDouble(fieldName, ((Field)f).getDouble(this));
                        continue;
                    }
                    if (o instanceof String[]) {
                        outState.putStringArray(fieldName, (String[])((Field)f).get(this));
                        continue;
                    }
                    if (o instanceof Parcelable) {
                        outState.putParcelable(fieldName, (Parcelable)((Field)f).get(this));
                        continue;
                    }
                    if (o instanceof Serializable) {
                        outState.putSerializable(fieldName, (Serializable)((Field)f).get(this));
                        continue;
                    }
                    if (!(o instanceof Bundle)) continue;
                    outState.putBundle(fieldName, (Bundle)((Field)f).get(this));
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    e.printStackTrace();
                    PageLog.e(e);
                }
            }
        }
        super.onSaveInstanceState(outState);
    }

    private void loadActivitySavedData(Bundle savedInstanceState) {
        AccessibleObject[] fields = this.getClass().getDeclaredFields();
        Field.setAccessible(fields, true);
        for (AccessibleObject f : fields) {
            Annotation[] ans;
            for (Annotation an : ans = ((Field)f).getDeclaredAnnotations()) {
                if (!(an instanceof SaveWithActivity)) continue;
                try {
                    String fieldName = ((Field)f).getName();
                    Class<?> cls = ((Field)f).getType();
                    if (cls == Integer.TYPE || cls == Integer.class) {
                        ((Field)f).setInt(this, savedInstanceState.getInt(fieldName));
                        continue;
                    }
                    if (String.class.isAssignableFrom(cls)) {
                        ((Field)f).set(this, savedInstanceState.getString(fieldName));
                        continue;
                    }
                    if (Serializable.class.isAssignableFrom(cls)) {
                        ((Field)f).set(this, savedInstanceState.getSerializable(fieldName));
                        continue;
                    }
                    if (cls == Long.TYPE || cls == Long.class) {
                        ((Field)f).setLong(this, savedInstanceState.getLong(fieldName));
                        continue;
                    }
                    if (cls == Short.TYPE || cls == Short.class) {
                        ((Field)f).setShort(this, savedInstanceState.getShort(fieldName));
                        continue;
                    }
                    if (cls == Boolean.TYPE || cls == Boolean.class) {
                        ((Field)f).setBoolean(this, savedInstanceState.getBoolean(fieldName));
                        continue;
                    }
                    if (cls == Byte.TYPE || cls == Byte.class) {
                        ((Field)f).setByte(this, savedInstanceState.getByte(fieldName));
                        continue;
                    }
                    if (cls == Character.TYPE || cls == Character.class) {
                        ((Field)f).setChar(this, savedInstanceState.getChar(fieldName));
                        continue;
                    }
                    if (CharSequence.class.isAssignableFrom(cls)) {
                        ((Field)f).set(this, savedInstanceState.getCharSequence(fieldName));
                        continue;
                    }
                    if (cls == Float.TYPE || cls == Float.class) {
                        ((Field)f).setFloat(this, savedInstanceState.getFloat(fieldName));
                        continue;
                    }
                    if (cls == Double.TYPE || cls == Double.class) {
                        ((Field)f).setDouble(this, savedInstanceState.getDouble(fieldName));
                        continue;
                    }
                    if (String[].class.isAssignableFrom(cls)) {
                        ((Field)f).set(this, savedInstanceState.getStringArray(fieldName));
                        continue;
                    }
                    if (Parcelable.class.isAssignableFrom(cls)) {
                        ((Field)f).set(this, savedInstanceState.getParcelable(fieldName));
                        continue;
                    }
                    if (!Bundle.class.isAssignableFrom(cls)) continue;
                    ((Field)f).set(this, savedInstanceState.getBundle(fieldName));
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    e.printStackTrace();
                    PageLog.e(e);
                }
            }
        }
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        View v;
        if (ev.getAction() == 0 && Utils.isShouldHideInput(v = this.getCurrentFocus(), ev)) {
            Utils.hideSoftInput(v);
        }
        return super.dispatchTouchEvent(ev);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface SaveWithActivity {
    }
}

