/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xpage.core;

import android.content.Context;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.text.TextUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xuexiang.xpage.R;
import com.xuexiang.xpage.base.BaseActivity;
import com.xuexiang.xpage.base.BaseFragment;
import com.xuexiang.xpage.core.CoreConfig;
import com.xuexiang.xpage.core.CorePage;
import com.xuexiang.xpage.core.CoreSwitcher;
import com.xuexiang.xpage.logger.PageLog;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class CorePageManager {
    private static final String PAGE_INFO_JSON = "corepage.json";
    private static volatile CorePageManager mInstance = null;
    private Context mContext;
    private Map<String, CorePage> mPageMap = new HashMap<String, CorePage>();

    private CorePageManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CorePageManager getInstance() {
        if (mInstance != null) return mInstance;
        Class<CorePageManager> clazz = CorePageManager.class;
        synchronized (CorePageManager.class) {
            if (mInstance != null) return mInstance;
            mInstance = new CorePageManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    public void init(Context context) {
        try {
            this.mContext = context.getApplicationContext();
            String content = this.readFileFromAssets(this.mContext, PAGE_INFO_JSON);
            this.readConfig(content);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void init(Context context, String pageJson) {
        this.init(context);
        if (!TextUtils.isEmpty((CharSequence)pageJson)) {
            this.readConfig(pageJson);
        }
    }

    public void readConfig(String content) {
        if (TextUtils.isEmpty((CharSequence)content)) {
            return;
        }
        PageLog.d("readConfig from json");
        JSONArray jsonArray = JSON.parseArray((String)content);
        for (JSONObject jsonPage : jsonArray) {
            String pageName = jsonPage.getString("name");
            String pageClazz = jsonPage.getString("classPath");
            String pageParams = jsonPage.getString("params");
            if (TextUtils.isEmpty((CharSequence)pageName) || TextUtils.isEmpty((CharSequence)pageClazz)) {
                PageLog.d("page Name is null or pageClass is null");
                return;
            }
            this.mPageMap.put(pageName, new CorePage(pageName, pageClazz, pageParams));
            PageLog.d("put a page:" + pageName);
        }
        PageLog.d("finished read pages,page size\uff1a" + this.mPageMap.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private String readFileFromAssets(Context context, String fileName) {
        StringBuilder s = new StringBuilder();
        BufferedReader br = null;
        try {
            String line;
            InputStreamReader inputReader = new InputStreamReader(context.getResources().getAssets().open(fileName));
            br = new BufferedReader(inputReader);
            while ((line = br.readLine()) != null) {
                s.append(line);
            }
        }
        catch (Exception exception) {
            CorePageManager.closeIO(br);
            catch (Throwable throwable) {
                CorePageManager.closeIO(br);
                throw throwable;
            }
        }
        CorePageManager.closeIO(br);
        return s.toString();
    }

    static void closeIO(Closeable ... closeables) {
        if (closeables == null) {
            return;
        }
        for (Closeable closeable : closeables) {
            if (closeable == null) continue;
            try {
                closeable.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean putPage(String name, Class<? extends BaseFragment> clazz, Map<String, String> params) {
        if (TextUtils.isEmpty((CharSequence)name) || clazz == null) {
            PageLog.d("page Name is null or pageClass is null");
            return false;
        }
        if (this.mPageMap.containsKey(name)) {
            PageLog.d("page has already put!");
            return false;
        }
        this.mPageMap.put(name, new CorePage(name, clazz.getName(), this.buildParams(params)));
        PageLog.d("put a page:" + name);
        return true;
    }

    private String buildParams(Map<String, String> params) {
        if (params == null) {
            return "";
        }
        String result = JSON.toJSONString(params);
        PageLog.d("params:" + result);
        return result;
    }

    public Fragment gotoPage(FragmentManager fragmentManager, String pageName, Bundle bundle, int[] animations) {
        PageLog.d("gotoPage:" + pageName);
        Fragment fragment = null;
        if (fragmentManager != null) {
            fragment = fragmentManager.findFragmentByTag(pageName);
        }
        if (fragment != null) {
            fragmentManager.popBackStackImmediate(pageName, 0);
        } else {
            fragment = this.openPageWithNewFragmentManager(fragmentManager, pageName, bundle, animations, true);
        }
        return fragment;
    }

    public Fragment openPageWithNewFragmentManager(FragmentManager fragmentManager, String pageName, Bundle bundle, int[] animations, boolean addToBackStack) {
        BaseFragment fragment = null;
        try {
            Fragment fragmentContainer;
            CorePage corePage = this.mPageMap.get(pageName);
            if (corePage == null) {
                PageLog.d("Page:" + pageName + " is null");
                return null;
            }
            if (CoreConfig.isOpenAtlas()) {
                ClassLoader bundleClassLoader = CoreConfig.getBundleClassLoader();
                if (bundleClassLoader == null) {
                    PageLog.d("OpenAtlas bundle ClassLoader is null!");
                    return null;
                }
                fragment = (BaseFragment)((Object)CoreConfig.getBundleClassLoader().loadClass(corePage.getClazz()).newInstance());
            } else {
                fragment = (BaseFragment)((Object)Class.forName(corePage.getClazz()).newInstance());
            }
            Bundle pageBundle = this.buildBundle(corePage);
            if (bundle != null) {
                pageBundle.putAll(bundle);
            }
            fragment.setArguments(pageBundle);
            fragment.setPageName(pageName);
            FragmentTransaction fragmentTransaction = fragmentManager.beginTransaction();
            if (animations != null && animations.length >= 4) {
                fragmentTransaction.setCustomAnimations(animations[0], animations[1], animations[2], animations[3]);
            }
            if ((fragmentContainer = fragmentManager.findFragmentById(R.id.fragment_container)) != null) {
                fragmentTransaction.hide(fragmentContainer);
            }
            fragmentTransaction.add(R.id.fragment_container, (Fragment)fragment, pageName);
            if (addToBackStack) {
                fragmentTransaction.addToBackStack(pageName);
            }
            fragmentTransaction.commitAllowingStateLoss();
        }
        catch (Exception e) {
            e.printStackTrace();
            PageLog.d("Fragment.error:" + e.getMessage());
            return null;
        }
        return fragment;
    }

    private Bundle buildBundle(CorePage corePage) {
        Set keySet;
        JSONObject j;
        Bundle bundle = new Bundle();
        String key2 = null;
        Object value = null;
        if (corePage != null && corePage.getParams() != null && (j = JSON.parseObject((String)corePage.getParams())) != null && (keySet = j.keySet()) != null) {
            for (String key2 : keySet) {
                value = j.get((Object)key2);
                bundle.putString(key2, value.toString());
            }
        }
        return bundle;
    }

    public boolean isFragmentTop(Context context, String fragmentTag) {
        if (context != null && context instanceof CoreSwitcher) {
            return ((CoreSwitcher)context).isFragmentTop(fragmentTag);
        }
        BaseActivity topActivity = BaseActivity.getTopActivity();
        return topActivity != null && topActivity.isFragmentTop(fragmentTag);
    }
}

