/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xpage.utils;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.xuexiang.xpage.R;
import com.xuexiang.xpage.utils.Utils;
import java.util.LinkedList;

public class TitleBar
extends ViewGroup
implements View.OnClickListener {
    private static final String STATUS_BAR_HEIGHT_RES_NAME = "status_bar_height";
    private static int DEFAULT_TEXT_COLOR = -1;
    private TextView mLeftText;
    private LinearLayout mRightLayout;
    private LinearLayout mCenterLayout;
    private TextView mCenterText;
    private TextView mSubTitleText;
    private View mCustomCenterView;
    private View mDividerView;
    private boolean mImmersive;
    private int mScreenWidth;
    private int mBarHeight;
    private int mStatusBarHeight;
    private int mActionPadding;
    private int mSideTextPadding;
    private int mSideTextSize;
    private int mTitleTextSize;
    private int mSubTitleTextSize;
    private int mActionTextSize;
    private int mSideTextColor;
    private int mTitleTextColor;
    private int mSubTitleTextColor;
    private int mActionTextColor;
    private Drawable mLeftImageResource;
    private String mLeftTextString;
    private String mTitleTextString;
    private String mSubTextString;
    private int mDividerColor;

    public TitleBar(Context context) {
        this(context, null);
    }

    public TitleBar(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public TitleBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.getAttr(context, attrs);
        this.init(context);
    }

    private void getAttr(Context context, AttributeSet attrs) {
        if (this.isInEditMode()) {
            return;
        }
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.TitleBar);
        if (typedArray != null) {
            this.mBarHeight = typedArray.getDimensionPixelOffset(R.styleable.TitleBar_tb_barHeight, Utils.getDimensionPixelOffset(context, R.dimen.default_titlebar_height));
            this.mImmersive = typedArray.getBoolean(R.styleable.TitleBar_tb_immersive, false);
            this.mActionPadding = typedArray.getDimensionPixelOffset(R.styleable.TitleBar_tb_actionPadding, Utils.getDimensionPixelOffset(context, R.dimen.default_action_padding));
            this.mSideTextPadding = typedArray.getDimensionPixelOffset(R.styleable.TitleBar_tb_sideTextPadding, Utils.getDimensionPixelOffset(context, R.dimen.default_sidetext_padding));
            this.mSideTextSize = typedArray.getDimensionPixelSize(R.styleable.TitleBar_tb_sideTextSize, Utils.getDimensionPixelSize(context, R.dimen.default_action_text_size));
            this.mTitleTextSize = typedArray.getDimensionPixelSize(R.styleable.TitleBar_tb_titleTextSize, Utils.getDimensionPixelSize(context, R.dimen.default_main_text_size));
            this.mSubTitleTextSize = typedArray.getDimensionPixelSize(R.styleable.TitleBar_tb_subTitleTextSize, Utils.getDimensionPixelSize(context, R.dimen.default_sub_text_size));
            this.mActionTextSize = typedArray.getDimensionPixelSize(R.styleable.TitleBar_tb_actionTextSize, Utils.getDimensionPixelSize(context, R.dimen.default_action_text_size));
            this.mSideTextColor = typedArray.getColor(R.styleable.TitleBar_tb_sideTextColor, DEFAULT_TEXT_COLOR);
            this.mTitleTextColor = typedArray.getColor(R.styleable.TitleBar_tb_titleTextColor, DEFAULT_TEXT_COLOR);
            this.mSubTitleTextColor = typedArray.getColor(R.styleable.TitleBar_tb_subTitleTextColor, DEFAULT_TEXT_COLOR);
            this.mActionTextColor = typedArray.getColor(R.styleable.TitleBar_tb_actionTextColor, DEFAULT_TEXT_COLOR);
            this.mLeftImageResource = typedArray.getDrawable(R.styleable.TitleBar_tb_leftImageResource);
            this.mLeftTextString = typedArray.getString(R.styleable.TitleBar_tb_leftText);
            this.mTitleTextString = typedArray.getString(R.styleable.TitleBar_tb_titleText);
            this.mSubTextString = typedArray.getString(R.styleable.TitleBar_tb_subTitleText);
            this.mDividerColor = typedArray.getColor(R.styleable.TitleBar_tb_dividerColor, 0);
            typedArray.recycle();
        }
    }

    private void init(Context context) {
        this.mScreenWidth = this.getResources().getDisplayMetrics().widthPixels;
        if (this.mImmersive) {
            this.mStatusBarHeight = TitleBar.getStatusBarHeight();
        }
        this.initView(context);
    }

    private void initView(Context context) {
        this.mLeftText = new TextView(context);
        this.mCenterLayout = new LinearLayout(context);
        this.mRightLayout = new LinearLayout(context);
        this.mDividerView = new View(context);
        ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-2, -1);
        this.mLeftText.setTextSize(0, (float)this.mSideTextSize);
        this.mLeftText.setTextColor(this.mSideTextColor);
        this.mLeftText.setText((CharSequence)this.mLeftTextString);
        if (this.mLeftImageResource != null) {
            this.mLeftText.setCompoundDrawablesWithIntrinsicBounds(this.mLeftImageResource, null, null, null);
        }
        this.mLeftText.setSingleLine();
        this.mLeftText.setGravity(16);
        this.mLeftText.setPadding(this.mSideTextPadding, 0, this.mSideTextPadding, 0);
        this.mCenterText = new TextView(context);
        this.mSubTitleText = new TextView(context);
        if (!TextUtils.isEmpty((CharSequence)this.mSubTextString)) {
            this.mCenterLayout.setOrientation(1);
        }
        this.mCenterLayout.addView((View)this.mCenterText);
        this.mCenterLayout.addView((View)this.mSubTitleText);
        this.mCenterLayout.setGravity(17);
        this.mCenterText.setTextSize(0, (float)this.mTitleTextSize);
        this.mCenterText.setTextColor(this.mTitleTextColor);
        this.mCenterText.setText((CharSequence)this.mTitleTextString);
        this.mCenterText.setSingleLine();
        this.mCenterText.setGravity(17);
        this.mCenterText.setEllipsize(TextUtils.TruncateAt.END);
        this.mSubTitleText.setTextSize(0, (float)this.mSubTitleTextSize);
        this.mSubTitleText.setTextColor(this.mSubTitleTextColor);
        this.mSubTitleText.setText((CharSequence)this.mSubTextString);
        this.mSubTitleText.setSingleLine();
        this.mSubTitleText.setGravity(17);
        this.mSubTitleText.setPadding(0, Utils.dip2px(this.getContext(), 2.0f), 0, 0);
        this.mSubTitleText.setEllipsize(TextUtils.TruncateAt.END);
        this.mRightLayout.setPadding(this.mSideTextPadding, 0, this.mSideTextPadding, 0);
        this.mDividerView.setBackgroundColor(this.mDividerColor);
        this.addView((View)this.mLeftText, layoutParams);
        this.addView((View)this.mCenterLayout);
        this.addView((View)this.mRightLayout, layoutParams);
        this.addView(this.mDividerView, new ViewGroup.LayoutParams(-1, 1));
    }

    public TitleBar setImmersive(boolean immersive) {
        this.mImmersive = immersive;
        this.mStatusBarHeight = this.mImmersive ? TitleBar.getStatusBarHeight() : 0;
        return this;
    }

    public TitleBar setHeight(int height) {
        this.mBarHeight = height;
        this.setMeasuredDimension(this.getMeasuredWidth(), this.mBarHeight);
        return this;
    }

    public TitleBar setLeftImageResource(int resId) {
        this.mLeftText.setCompoundDrawablesWithIntrinsicBounds(resId, 0, 0, 0);
        return this;
    }

    public TitleBar setBackImageResource(int resId) {
        this.mLeftImageResource = Utils.getDrawable(this.getContext(), resId);
        this.mLeftImageResource.setBounds(0, 0, Utils.dip2px(this.getContext(), 12.0f), Utils.dip2px(this.getContext(), 22.0f));
        this.mLeftText.setCompoundDrawables(this.mLeftImageResource, null, null, null);
        return this;
    }

    public TitleBar setLeftClickListener(View.OnClickListener l) {
        this.mLeftText.setOnClickListener(l);
        return this;
    }

    public TitleBar setLeftText(CharSequence title) {
        this.mLeftText.setText(title);
        return this;
    }

    public TitleBar setLeftText(int resid) {
        this.mLeftText.setText(resid);
        return this;
    }

    public TitleBar setLeftTextSize(float size) {
        this.mLeftText.setTextSize(0, size);
        return this;
    }

    public TitleBar setLeftTextColor(int color) {
        this.mLeftText.setTextColor(color);
        return this;
    }

    public TitleBar setLeftVisible(boolean visible) {
        this.mLeftText.setVisibility(visible ? 0 : 8);
        return this;
    }

    public TitleBar setTitle(CharSequence title) {
        int index = title.toString().indexOf("\n");
        if (index > 0) {
            this.setTitle(title.subSequence(0, index), title.subSequence(index + 1, title.length()), 1);
        } else {
            index = title.toString().indexOf("\t");
            if (index > 0) {
                this.setTitle(title.subSequence(0, index), "  " + title.subSequence(index + 1, title.length()), 0);
            } else {
                this.mCenterText.setText(title);
                this.mSubTitleText.setVisibility(8);
            }
        }
        return this;
    }

    private TitleBar setTitle(CharSequence title, CharSequence subTitle, int orientation) {
        this.mCenterLayout.setOrientation(orientation);
        this.mCenterText.setText(title);
        this.mSubTitleText.setText(subTitle);
        this.mSubTitleText.setVisibility(0);
        return this;
    }

    public TitleBar setCenterClickListener(View.OnClickListener l) {
        this.mCenterLayout.setOnClickListener(l);
        return this;
    }

    public TitleBar setTitle(int resid) {
        this.setTitle(this.getResources().getString(resid));
        return this;
    }

    public TitleBar setTitleColor(int resid) {
        this.mCenterText.setTextColor(resid);
        return this;
    }

    public TitleBar setTitleSize(float size) {
        this.mCenterText.setTextSize(0, size);
        return this;
    }

    public TitleBar setTitleBackground(int resid) {
        this.mCenterText.setBackgroundResource(resid);
        return this;
    }

    public TitleBar setSubTitleColor(int resid) {
        this.mSubTitleText.setTextColor(resid);
        return this;
    }

    public TitleBar setSubTitleSize(float size) {
        this.mSubTitleText.setTextSize(0, size);
        return this;
    }

    public TitleBar setCustomTitle(View titleView) {
        if (titleView == null) {
            this.mCenterText.setVisibility(0);
            if (this.mCustomCenterView != null) {
                this.mCenterLayout.removeView(this.mCustomCenterView);
            }
        } else {
            if (this.mCustomCenterView != null) {
                this.mCenterLayout.removeView(this.mCustomCenterView);
            }
            ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-1, -1);
            this.mCustomCenterView = titleView;
            this.mCenterLayout.addView(titleView, layoutParams);
            this.mCenterText.setVisibility(8);
        }
        return this;
    }

    public TitleBar setDivider(Drawable drawable2) {
        this.mDividerView.setBackgroundDrawable(drawable2);
        return this;
    }

    public TitleBar setDividerColor(int color) {
        this.mDividerView.setBackgroundColor(color);
        return this;
    }

    public TitleBar setDividerHeight(int dividerHeight) {
        this.mDividerView.getLayoutParams().height = dividerHeight;
        return this;
    }

    public TitleBar setActionTextColor(int colorResId) {
        this.mActionTextColor = colorResId;
        return this;
    }

    public TitleBar setOnTitleClickListener(View.OnClickListener listener) {
        this.mCenterText.setOnClickListener(listener);
        return this;
    }

    public void onClick(View view) {
        Object tag = view.getTag();
        if (tag instanceof Action) {
            Action action = (Action)tag;
            action.performAction(view);
        }
    }

    public TitleBar addActions(ActionList actionList) {
        int actions = actionList.size();
        for (int i = 0; i < actions; ++i) {
            this.addAction((Action)actionList.get(i));
        }
        return this;
    }

    public View addAction(Action action) {
        int index = this.mRightLayout.getChildCount();
        return this.addAction(action, index);
    }

    public View addAction(Action action, int index) {
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-2, -1);
        View view = this.inflateAction(action);
        this.mRightLayout.addView(view, index, (ViewGroup.LayoutParams)params);
        return view;
    }

    public void removeAllActions() {
        this.mRightLayout.removeAllViews();
    }

    public void removeActionAt(int index) {
        this.mRightLayout.removeViewAt(index);
    }

    public void removeAction(Action action) {
        int childCount = this.mRightLayout.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            Object tag;
            View view = this.mRightLayout.getChildAt(i);
            if (view == null || !((tag = view.getTag()) instanceof Action) || !tag.equals(action)) continue;
            this.mRightLayout.removeView(view);
        }
    }

    public int getActionCount() {
        return this.mRightLayout.getChildCount();
    }

    private View inflateAction(Action action) {
        ImageView view = null;
        if (TextUtils.isEmpty((CharSequence)action.getText())) {
            ImageView img = new ImageView(this.getContext());
            img.setImageResource(action.getDrawable());
            view = img;
        } else {
            TextView text = new TextView(this.getContext());
            text.setGravity(17);
            text.setText((CharSequence)action.getText());
            text.setTextSize(0, (float)this.mActionTextSize);
            if (this.mActionTextColor != 0) {
                text.setTextColor(this.mActionTextColor);
            }
            view = text;
        }
        view.setPadding(this.mActionPadding, 0, this.mActionPadding, 0);
        view.setTag((Object)action);
        view.setOnClickListener((View.OnClickListener)this);
        return view;
    }

    public View getViewByAction(Action action) {
        View view = this.findViewWithTag(action);
        return view;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int height;
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        if (heightMode != 0x40000000) {
            height = this.mBarHeight + this.mStatusBarHeight;
            heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)this.mBarHeight, (int)0x40000000);
        } else {
            height = View.MeasureSpec.getSize((int)heightMeasureSpec) + this.mStatusBarHeight;
        }
        this.measureChild((View)this.mLeftText, widthMeasureSpec, heightMeasureSpec);
        this.measureChild((View)this.mRightLayout, widthMeasureSpec, heightMeasureSpec);
        if (this.mLeftText.getMeasuredWidth() > this.mRightLayout.getMeasuredWidth()) {
            this.mCenterLayout.measure(View.MeasureSpec.makeMeasureSpec((int)(this.mScreenWidth - 2 * this.mLeftText.getMeasuredWidth()), (int)0x40000000), heightMeasureSpec);
        } else {
            this.mCenterLayout.measure(View.MeasureSpec.makeMeasureSpec((int)(this.mScreenWidth - 2 * this.mRightLayout.getMeasuredWidth()), (int)0x40000000), heightMeasureSpec);
        }
        this.measureChild(this.mDividerView, widthMeasureSpec, heightMeasureSpec);
        this.setMeasuredDimension(View.MeasureSpec.getSize((int)widthMeasureSpec), height);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        this.mLeftText.layout(0, this.mStatusBarHeight, this.mLeftText.getMeasuredWidth(), this.mLeftText.getMeasuredHeight() + this.mStatusBarHeight);
        this.mRightLayout.layout(this.mScreenWidth - this.mRightLayout.getMeasuredWidth(), this.mStatusBarHeight, this.mScreenWidth, this.mRightLayout.getMeasuredHeight() + this.mStatusBarHeight);
        if (this.mLeftText.getMeasuredWidth() > this.mRightLayout.getMeasuredWidth()) {
            this.mCenterLayout.layout(this.mLeftText.getMeasuredWidth(), this.mStatusBarHeight, this.mScreenWidth - this.mLeftText.getMeasuredWidth(), this.getMeasuredHeight());
        } else {
            this.mCenterLayout.layout(this.mRightLayout.getMeasuredWidth(), this.mStatusBarHeight, this.mScreenWidth - this.mRightLayout.getMeasuredWidth(), this.getMeasuredHeight());
        }
        this.mDividerView.layout(0, this.getMeasuredHeight() - this.mDividerView.getMeasuredHeight(), this.getMeasuredWidth(), this.getMeasuredHeight());
    }

    public static int getStatusBarHeight() {
        return TitleBar.getInternalDimensionSize(Resources.getSystem(), STATUS_BAR_HEIGHT_RES_NAME);
    }

    private static int getInternalDimensionSize(Resources res, String key) {
        int result = 0;
        int resourceId = res.getIdentifier(key, "dimen", "android");
        if (resourceId > 0) {
            result = res.getDimensionPixelSize(resourceId);
        }
        return result;
    }

    public static abstract class TextAction
    implements Action {
        private final String mText;

        public TextAction(String text) {
            this.mText = text;
        }

        @Override
        public int getDrawable() {
            return 0;
        }

        @Override
        public String getText() {
            return this.mText;
        }
    }

    public static abstract class ImageAction
    implements Action {
        private int mDrawable;

        public ImageAction(int drawable2) {
            this.mDrawable = drawable2;
        }

        @Override
        public int getDrawable() {
            return this.mDrawable;
        }

        @Override
        public String getText() {
            return null;
        }
    }

    public static interface Action {
        public String getText();

        public int getDrawable();

        public void performAction(View var1);
    }

    public static class ActionList
    extends LinkedList<Action> {
    }
}

