/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xpage.utils;

import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.DimenRes;
import android.support.annotation.DrawableRes;
import android.view.MotionEvent;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import java.util.List;

public class Utils {
    public static Resources getResources(Context context) {
        return context.getResources();
    }

    public static int getDimensionPixelOffset(Context context, @DimenRes int resId) {
        return Utils.getResources(context).getDimensionPixelOffset(resId);
    }

    public static int getDimensionPixelSize(Context context, @DimenRes int resId) {
        return Utils.getResources(context).getDimensionPixelSize(resId);
    }

    public static int dip2px(Context context, float dpValue) {
        float scale = Utils.getResources((Context)context).getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    public static Drawable getDrawable(Context context, @DrawableRes int resId) {
        if (Build.VERSION.SDK_INT >= 21) {
            return context.getDrawable(resId);
        }
        return context.getResources().getDrawable(resId);
    }

    public static boolean isShouldHideInput(View v, MotionEvent event) {
        if (v != null && v instanceof EditText) {
            int[] leftTop = new int[]{0, 0};
            v.getLocationOnScreen(leftTop);
            int left = leftTop[0];
            int top = leftTop[1];
            int bottom = top + v.getHeight();
            int right = left + v.getWidth();
            return !(event.getRawX() > (float)left) || !(event.getRawX() < (float)right) || !(event.getRawY() > (float)top) || !(event.getRawY() < (float)bottom);
        }
        return false;
    }

    public static void hideKeyboard(View v) {
        InputMethodManager imm = (InputMethodManager)v.getContext().getSystemService("input_method");
        if (imm.isActive()) {
            imm.hideSoftInputFromWindow(v.getApplicationWindowToken(), 2);
        }
    }

    public static <T> T checkNotNull(T t, String message) {
        if (t == null) {
            throw new NullPointerException(message);
        }
        return t;
    }

    public static void stopAllRunningService(Context context) {
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        List servicesList = activityManager.getRunningServices(Integer.MAX_VALUE);
        for (ActivityManager.RunningServiceInfo si : servicesList) {
            if (!context.getPackageName().equals(si.service.getPackageName())) continue;
            Utils.stopRunningService(context, si.service.getClassName());
        }
    }

    public static boolean stopRunningService(Context context, String className) {
        Intent intent_service = null;
        boolean ret = false;
        try {
            intent_service = new Intent(context, Class.forName(className));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (intent_service != null) {
            ret = context.stopService(intent_service);
        }
        return ret;
    }
}

