/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xpage.utils;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.widget.Toast;

public class ToastUtil {
    private static ToastUtil sInstance = null;
    private Context mContext;
    private final Handler mMainHandler = new Handler(Looper.getMainLooper());
    private Toast mToast = null;

    private ToastUtil(Context context) {
        this.mContext = context.getApplicationContext();
    }

    private boolean isMainThread() {
        return Thread.currentThread() == Looper.getMainLooper().getThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ToastUtil getInstance(Context context) {
        if (sInstance != null) return sInstance;
        Class<ToastUtil> clazz = ToastUtil.class;
        synchronized (ToastUtil.class) {
            if (sInstance != null) return sInstance;
            sInstance = new ToastUtil(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sInstance;
        }
    }

    public void showToast(String text) {
        this.showToast(text, 0);
    }

    public void showToast(int resId) {
        this.showToast(this.mContext.getResources().getString(resId), 0);
    }

    public void showToast(final String msg, final int duration) {
        if (this.isMainThread()) {
            this.toast(msg, duration);
        } else {
            this.mMainHandler.post(new Runnable(){

                @Override
                public void run() {
                    ToastUtil.this.toast(msg, duration);
                }
            });
        }
    }

    private void toast(String text, int duration) {
        if (this.mToast == null) {
            this.mToast = Toast.makeText((Context)this.mContext, (CharSequence)text, (int)duration);
        } else {
            this.mToast.setText((CharSequence)text);
        }
        this.mToast.show();
    }

    public void cancelToast() {
        if (this.mToast != null) {
            this.mToast.cancel();
        }
    }
}

