/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xpage;

import android.app.Application;
import android.content.Context;
import android.text.TextUtils;
import com.squareup.leakcanary.LeakCanary;
import com.squareup.leakcanary.RefWatcher;
import com.xuexiang.xpage.PageConfiguration;
import com.xuexiang.xpage.annotation.Page;
import com.xuexiang.xpage.core.CoreConfig;
import com.xuexiang.xpage.logger.PageLog;
import com.xuexiang.xpage.model.PageInfo;
import com.xuexiang.xpage.utils.Utils;
import java.util.ArrayList;
import java.util.List;

public class PageConfig {
    private RefWatcher mRefWatcher;
    private PageConfiguration mPageConfiguration;
    private List<PageInfo> mPages = new ArrayList<PageInfo>();
    private static PageConfig gInstance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PageConfig getInstance() {
        if (gInstance != null) return gInstance;
        Class<PageConfig> clazz = PageConfig.class;
        synchronized (PageConfig.class) {
            if (gInstance != null) return gInstance;
            gInstance = new PageConfig();
            // ** MonitorExit[var0] (shouldn't be in output)
            return gInstance;
        }
    }

    public PageConfig setPageConfiguration(PageConfiguration pageConfiguration) {
        this.mPageConfiguration = pageConfiguration;
        return this;
    }

    public void init(Application application) {
        this.initCanary(application);
        this.initPages((Context)application);
    }

    public PageConfig debug(String tag) {
        PageLog.debug(tag);
        return this;
    }

    private void initPages(Context context) {
        Utils.checkNotNull(this.mPageConfiguration, "mPageConfiguration == null");
        this.registerPageInfos(this.mPageConfiguration.registerPages(context));
        CoreConfig.init(context, this.getPages());
    }

    private void initCanary(Application application) {
        if (LeakCanary.isInAnalyzerProcess((Context)application)) {
            return;
        }
        this.mRefWatcher = LeakCanary.install((Application)application);
    }

    public RefWatcher getRefWatcher() {
        return this.mRefWatcher;
    }

    public PageConfig registerPageInfo(Class<?> clazz) {
        this.mPages.add(PageConfig.getPageInfo(clazz));
        return this;
    }

    public PageConfig registerPageInfos(Class ... clazz) {
        for (int i = 0; i < clazz.length; ++i) {
            this.registerPageInfo(clazz[i]);
        }
        return this;
    }

    private PageConfig registerPageInfos(List<PageInfo> pageInfos) {
        if (pageInfos != null && pageInfos.size() > 0) {
            this.mPages.clear();
            this.mPages.addAll(pageInfos);
        }
        return this;
    }

    public List<PageInfo> getPages() {
        return this.mPages;
    }

    public static PageInfo getPageInfo(Class<?> clazz) {
        Page page = PageConfig.getPage(clazz);
        PageInfo pageInfo = new PageInfo(TextUtils.isEmpty((CharSequence)page.name()) ? clazz.getSimpleName() : page.name(), clazz);
        if (!TextUtils.isEmpty((CharSequence)page.params()[0])) {
            pageInfo.setParams(page.params());
        }
        pageInfo.setAnim(page.anim());
        return pageInfo;
    }

    public static Page getPage(Class<?> clazz) {
        return Utils.checkNotNull(clazz.getAnnotation(Page.class), "Page == null");
    }
}

