/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xpage.utils;

import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.support.v4.app.Fragment;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.xuexiang.xpage.R;
import com.xuexiang.xpage.utils.TitleBar;

public class TitleUtil {
    public static TitleBar initTitleBar(final Activity activity, int titleBarResId, String title) {
        TitleBar titleBar = (TitleBar)activity.findViewById(titleBarResId);
        TitleUtil.initTitleBarStyle(titleBar, title, new View.OnClickListener(){

            public void onClick(View view) {
                activity.finish();
            }
        });
        return titleBar;
    }

    public static TitleBar initTitleBar(ViewGroup viewGroup, int titleBarResId, String title, View.OnClickListener listener) {
        TitleBar titleBar = (TitleBar)viewGroup.findViewById(titleBarResId);
        TitleUtil.initTitleBarStyle(titleBar, title, listener);
        return titleBar;
    }

    public static TitleBar addTitleBarDynamic(final Activity activity, String title) {
        TitleBar titleBar = TitleUtil.initTitleBarDynamic((Context)activity, title, new View.OnClickListener(){

            public void onClick(View view) {
                activity.finish();
            }
        });
        TitleUtil.getRootView(activity).addView((View)titleBar, 0);
        return titleBar;
    }

    public static TitleBar addTitleBarDynamic(ViewGroup viewGroup, String title, View.OnClickListener listener) {
        TitleBar titleBar = TitleUtil.initTitleBarDynamic(viewGroup.getContext(), title, listener);
        viewGroup.addView((View)titleBar, 0);
        return titleBar;
    }

    public static TitleBar initTitleBarDynamic(final Fragment fragment, String title) {
        TitleBar titleBar = TitleUtil.initTitleBarDynamic(fragment.getContext(), title, new View.OnClickListener(){

            public void onClick(View view) {
                fragment.getActivity().finish();
            }
        });
        return titleBar;
    }

    public static TitleBar addTitleBarDynamic(Fragment fragment, ViewGroup viewGroup, String title) {
        TitleBar titleBar = TitleUtil.initTitleBarDynamic(fragment, title);
        viewGroup.addView((View)titleBar, 0);
        return titleBar;
    }

    public static TitleBar initTitleBarDynamic(Context context, String title, View.OnClickListener listener) {
        TitleBar titleBar = new TitleBar(context);
        RelativeLayout.LayoutParams titleBarParams = new RelativeLayout.LayoutParams(-1, -2);
        titleBarParams.addRule(10);
        titleBar.setLayoutParams((ViewGroup.LayoutParams)titleBarParams);
        TitleUtil.initTitleBarStyle(titleBar, title, listener);
        return titleBar;
    }

    public static ViewGroup getRootView(Activity activity) {
        return (ViewGroup)activity.getWindow().getDecorView().findViewById(0x1020002);
    }

    public static TitleBar initTitleBarStyle(TitleBar titleBar, String title, View.OnClickListener listener) {
        titleBar.setImmersive(false).setBackImageResource(R.drawable.xpage_ic_return_back).setLeftClickListener(listener).setTitle(title).setBackgroundColor(Color.parseColor((String)"#299EE3"));
        return titleBar;
    }
}

