/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xpage.util;

import javax.annotation.processing.Messager;
import javax.tools.Diagnostic;
import org.apache.commons.lang3.StringUtils;

public class Logger {
    private Messager msg;

    public Logger(Messager messager) {
        this.msg = messager;
    }

    public void info(CharSequence info) {
        if (StringUtils.isNotEmpty((CharSequence)info)) {
            this.msg.printMessage(Diagnostic.Kind.NOTE, "XPage::Compiler " + info);
        }
    }

    public void error(CharSequence error) {
        if (StringUtils.isNotEmpty((CharSequence)error)) {
            this.msg.printMessage(Diagnostic.Kind.ERROR, "XPage::Compiler An exception is encountered, [" + error + "]");
        }
    }

    public void error(Throwable error) {
        if (null != error) {
            this.msg.printMessage(Diagnostic.Kind.ERROR, "XPage::Compiler An exception is encountered, [" + error.getMessage() + "]\n" + this.formatStackTrace(error.getStackTrace()));
        }
    }

    public void warning(CharSequence warning) {
        if (StringUtils.isNotEmpty((CharSequence)warning)) {
            this.msg.printMessage(Diagnostic.Kind.WARNING, "XPage::Compiler " + warning);
        }
    }

    private String formatStackTrace(StackTraceElement[] stackTrace) {
        StringBuilder sb = new StringBuilder();
        for (StackTraceElement element : stackTrace) {
            sb.append("    at ").append(element.toString());
            sb.append("\n");
        }
        return sb.toString();
    }
}

